/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.controls.XMLTableModel;
import org.opensourcephysics.display.Hidable;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorTool
extends JFrame
implements Tool,
Hidable,
Translator {
    private Dimension dim = new Dimension(320, 240);
    private Map<Class<?>, Map<String, String>> defaultProps = new HashMap();
    private Map<Class<?>, Map<String, Map<String, String>>> classes = new HashMap();
    private Map<Object, Class<?>> associates = new HashMap();
    private Set<Map<String, String>> changed = new HashSet<Map<String, String>>();
    private Locale locale = Locale.getDefault();
    private Set<Class<?>> searched = new HashSet();
    private String helpURL = "http://www.opensourcephysics.org/online_help/tools/translator_tool_help.html";
    private boolean keepHidden = false;
    private XMLControl control = new XMLControlElement();
    private XMLTable table;
    private Class<?> classType;
    private JPanel contentPane = new JPanel(new BorderLayout());
    private String fileExtension;
    private JLabel descriptionLabel;
    private JComboBox localeDropDown;
    private Icon saveIcon;
    private JButton saveButton;
    private JButton closeButton;
    private JButton helpButton;
    private static final TranslatorTool TOOL = new TranslatorTool();

    public static TranslatorTool getTool() {
        return TOOL;
    }

    @Override
    public void show() {
        if (!this.keepHidden) {
            super.show();
        }
    }

    @Override
    public void dispose() {
        this.keepHidden = true;
        super.dispose();
    }

    @Override
    public void setVisible(boolean bl) {
        if (!this.keepHidden) {
            super.setVisible(bl);
        }
    }

    @Override
    public void setKeepHidden(boolean bl) {
        this.keepHidden = bl;
        if (this.keepHidden) {
            super.setVisible(false);
        }
    }

    @Override
    public boolean isKeepHidden() {
        return this.keepHidden;
    }

    private TranslatorTool() {
        if (OSPRuntime.appletMode) {
            this.keepHidden = true;
        }
        String string = "TranslatorTool";
        this.setName(string);
        this.createGUI();
        this.refreshGUI();
        this.setLocale(ToolsRes.locale);
        Toolbox.addTool(string, this);
    }

    @Override
    public void send(Job job, Tool tool) {
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == this.locale) {
            return;
        }
        this.locale = locale;
        this.showProperties(this.classType);
        LocaleItem localeItem = null;
        if (this.localeDropDown != null) {
            int n = 0;
            while (n < this.localeDropDown.getItemCount()) {
                localeItem = (LocaleItem)this.localeDropDown.getItemAt(n);
                if (localeItem.loc.getLanguage().equals(locale.getLanguage())) break;
                localeItem = null;
                ++n;
            }
            if (localeItem == null) {
                localeItem = new LocaleItem(locale);
                this.addDropDownItem(localeItem);
            }
            this.localeDropDown.setSelectedItem(localeItem);
            Map<String, String> map = this.getProperties(this.classType, locale);
            this.saveButton.setEnabled(this.changed.contains(map));
            this.refreshAssociates(this.classType);
        }
    }

    @Override
    public synchronized void associate(Object object, Class<?> clazz) {
        if (object == null) {
            return;
        }
        this.associates.put(object, clazz);
    }

    @Override
    public void showProperties(Class<?> clazz) {
        Object object2;
        if (clazz == null) {
            return;
        }
        this.classType = clazz;
        this.control.clearValues();
        this.fileExtension = "";
        String string = this.locale.getLanguage();
        if (!string.equals("")) {
            this.fileExtension = String.valueOf(this.fileExtension) + "_" + string;
        }
        this.fileExtension = String.valueOf(this.fileExtension) + ".properties";
        Collection<String> collection = this.control.getPropertyNames();
        for (String object22 : collection) {
            this.control.setValue(object22, object22);
        }
        Map<String, String> map = this.getProperties(clazz, this.locale);
        for (Object object2 : map.keySet()) {
            this.control.setValue((String)object2, map.get(object2));
        }
        object2 = this.getDefaults(clazz).keySet();
        for (String string2 : map.keySet()) {
            if (object2.contains(string2)) continue;
            this.table.setBackgroundColor(string2, Color.PINK);
        }
        this.table.refresh();
        this.refreshGUI();
    }

    @Override
    public String getProperty(Class<?> clazz, String string) {
        return this.getProperty(clazz, string, string, ToolsRes.locale);
    }

    @Override
    public String getProperty(Class<?> clazz, String string, String string2) {
        return this.getProperty(clazz, string, string2, ToolsRes.locale);
    }

    @Override
    public String getProperty(Object object, String string) {
        return this.getProperty(object, string, string);
    }

    @Override
    public String getProperty(Object object, String string, String string2) {
        if (object == null) {
            return string2 == null ? string : string2;
        }
        Class<?> clazz = this.associates.get(object);
        return this.getProperty(clazz, string, string2, ToolsRes.locale);
    }

    public void removeProperty(Class<?> clazz, String string) {
        if (clazz == null) {
            return;
        }
        this.getDefaults(clazz).remove(string);
        Map<String, Map<String, String>> map = this.classes.get(clazz);
        if (map != null) {
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Map<String, String> map2 = map.get(iterator.next());
                map2.remove(string);
                this.flagChange(map2);
            }
        }
        TOOL.showProperties(TranslatorTool.TOOL.classType);
        this.refreshAssociates(TranslatorTool.TOOL.classType);
    }

    public void removeProperty(Object object, String string) {
        Class<?> clazz = this.associates.get(object);
        this.removeProperty(clazz, string);
    }

    public void addProperty(Class<?> clazz, String string, String string2) {
        Map<String, Map<String, String>> map;
        if (clazz == null || string == null) {
            return;
        }
        if (string2 == null) {
            string2 = string;
        }
        this.getDefaults(clazz).put(string, string2);
        Map<String, String> map2 = this.getProperties(clazz, this.locale);
        if (map2.get(string) == null) {
            map2.put(string, string2);
            this.flagChange(map2);
        }
        if ((map = this.classes.get(clazz)) != null) {
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                map2 = map.get(iterator.next());
                if (map2.get(string) != null) continue;
                map2.put(string, string2);
                this.flagChange(map2);
            }
        }
        TOOL.showProperties(TranslatorTool.TOOL.classType);
        this.refreshAssociates(TranslatorTool.TOOL.classType);
    }

    public Collection<Object> getAssociates(Class<?> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : this.associates.keySet()) {
            if (!this.associates.get(object).equals(clazz)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale[] getTranslatedLocales(Class<?> clazz) {
        Object object;
        Object object2;
        HashMap<String, TreeMap<String, String>> hashMap;
        if (!this.searched.contains(clazz)) {
            hashMap = this.searched;
            synchronized (hashMap) {
                this.searched.add(clazz);
            }
            hashMap = this.classes.get(clazz);
            if (hashMap == null) {
                hashMap = new HashMap<String, TreeMap<String, String>>();
                object2 = this.classes;
                synchronized (object2) {
                    this.classes.put(clazz, hashMap);
                }
            }
            if (OSPRuntime.applet == null) {
                object2 = hashMap.keySet();
                object = this.getPath(clazz);
                Resource resource = null;
                String[] stringArray = Locale.getISOLanguages();
                int n = 0;
                while (n < stringArray.length) {
                    if (!object2.contains(stringArray[n]) && (resource = ResourceLoader.getResource(String.valueOf(object) + "_" + stringArray[n] + ".properties")) != null) {
                        TreeMap<String, String> treeMap = new TreeMap<String, String>();
                        hashMap.put(stringArray[n], treeMap);
                        OSPLog.finer(resource.getAbsolutePath());
                        this.readProperties(resource.openReader(), treeMap);
                    }
                    ++n;
                }
            }
        }
        hashMap = new TreeSet();
        hashMap.addAll(this.classes.get(clazz).keySet());
        object2 = new ArrayList<Locale>();
        object = hashMap.iterator();
        while (object.hasNext()) {
            ((ArrayList)object2).add(new Locale(((String)((Object)object.next())).toString()));
        }
        return ((ArrayList)object2).toArray(new Locale[0]);
    }

    protected boolean isLanguage(String string) {
        String[] stringArray = Locale.getISOLanguages();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void addDropDownItem(LocaleItem localeItem) {
        LocaleItem localeItem2;
        TreeMap<String, LocaleItem> treeMap = new TreeMap<String, LocaleItem>();
        LocaleItem localeItem3 = localeItem2 = localeItem.isDefault() ? localeItem : null;
        if (!localeItem.isDefault()) {
            treeMap.put(localeItem.language.toLowerCase(), localeItem);
        }
        int n = 0;
        while (n < this.localeDropDown.getItemCount()) {
            LocaleItem localeItem4 = (LocaleItem)this.localeDropDown.getItemAt(n);
            if (localeItem4.isDefault()) {
                localeItem2 = localeItem4;
            } else {
                treeMap.put(localeItem4.language.toLowerCase(), localeItem4);
            }
            ++n;
        }
        this.localeDropDown.removeAllItems();
        if (localeItem2 != null) {
            this.localeDropDown.addItem(localeItem2);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.localeDropDown.addItem(treeMap.get(iterator.next()));
        }
    }

    private synchronized String getProperty(Class<?> clazz, String string, String string2, Locale locale) {
        if (string2 == null) {
            string2 = string;
        }
        if (clazz == null) {
            return string2;
        }
        if (!this.getDefaults(clazz).keySet().contains(string)) {
            this.addProperty(clazz, string, string2);
        }
        return this.getProperties(clazz, locale).get(string);
    }

    private String getPath(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        int n = string.indexOf(".");
        while (n != -1) {
            string = String.valueOf(string.substring(0, n)) + "/" + string.substring(n + 1);
            n = string.indexOf(".");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getDefaults(Class<?> clazz) {
        Map<String, String> map = this.defaultProps.get(clazz);
        if (map == null) {
            map = new TreeMap<String, String>();
            Map<Class<?>, Map<String, String>> map2 = this.defaultProps;
            synchronized (map2) {
                this.defaultProps.put(clazz, map);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getProperties(Class<?> clazz, Locale locale) {
        Map<Object, Object> map;
        Map<String, Map<String, String>> map2 = this.classes.get(clazz);
        if (map2 == null) {
            map2 = new HashMap<String, Map<String, String>>();
            map = this.classes;
            synchronized (map) {
                this.classes.put(clazz, map2);
            }
        }
        if ((map = map2.get(locale.getLanguage())) == null) {
            map = new TreeMap<String, String>();
            map2.put(locale.getLanguage(), map);
            String string = this.getPath(clazz);
            Resource resource = null;
            String string2 = locale.getLanguage();
            if (!string2.equals("")) {
                resource = ResourceLoader.getResource(String.valueOf(string) + "_" + string2 + ".properties");
            }
            if (resource == null) {
                resource = ResourceLoader.getResource(String.valueOf(string) + ".properties");
            }
            if (resource != null) {
                OSPLog.finer(resource.getAbsolutePath());
                this.readProperties(resource.openReader(), map);
            } else {
                Map<String, String> map3 = this.getDefaults(clazz);
                for (String string3 : map3.keySet()) {
                    String string4 = map3.get(string3);
                    map.put(string3, string4);
                }
                this.flagChange(map);
            }
        }
        return map;
    }

    private void readProperties(BufferedReader bufferedReader, Map<String, String> map) {
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                int n = string.indexOf("=");
                if (n > -1) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    map.put(string2, string3);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String save(String string) {
        block13: {
            File file;
            Object iOException;
            CharSequence charSequence;
            block12: {
                Object object3;
                if (string == null || string.equals("")) {
                    return null;
                }
                int n = string.lastIndexOf("/");
                if (n < 0) {
                    n = string.lastIndexOf("\\");
                }
                if (n > 0) {
                    charSequence = string.substring(0, n + 1);
                    object3 = new File((String)charSequence);
                    if (!((File)object3).exists()) {
                        XML.createFolders((String)charSequence);
                    }
                    if (!((File)object3).exists()) {
                        return null;
                    }
                }
                charSequence = new StringBuffer();
                object3 = XML.stripExtension(string);
                ((StringBuffer)charSequence).append("# This is the " + (String)object3 + ".properties file" + XML.NEW_LINE + XML.NEW_LINE);
                for (String object22 : this.control.getPropertyNames()) {
                    iOException = this.control.getString(object22);
                    ((StringBuffer)charSequence).append(String.valueOf(object22) + "=" + (String)iOException + XML.NEW_LINE);
                }
                file = new File(string);
                if (!file.exists() || file.canWrite()) break block12;
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Tool.Dialog.ReadOnlyFile"));
                return null;
            }
            try {
                iOException = new FileOutputStream(file);
                Charset charset = Charset.forName("UTF-8");
                Writer writer = new OutputStreamWriter((OutputStream)iOException, charset);
                writer = new BufferedWriter(writer);
                writer.write(((StringBuffer)charSequence).toString());
                writer.flush();
                writer.close();
                if (!file.exists()) break block13;
                OSPLog.finest(file.getAbsolutePath());
                Set<Map<String, String>> set = this.changed;
                synchronized (set) {
                    this.changed.remove(this.getProperties(this.classType, this.locale));
                }
                this.saveButton.setEnabled(false);
                return file.getAbsolutePath();
            }
            catch (IOException iOException2) {
                OSPLog.warning(iOException2.getMessage());
            }
        }
        return null;
    }

    private void createGUI() {
        XMLTableModel xMLTableModel = new XMLTableModel(this.control){

            public String getColumnName(int n) {
                return n == 0 ? ToolsRes.getString("TranslatorTool.ColumnTitle.Property") : ToolsRes.getString("TranslatorTool.ColumnTitle.PropValue");
            }
        };
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Locale locale = (Locale)propertyChangeEvent.getNewValue();
                if (locale != null) {
                    TranslatorTool.this.setLocale(locale);
                }
            }
        });
        this.contentPane.setPreferredSize(this.dim);
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(1);
        this.table = new XMLTable(xMLTableModel);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    int n = 0;
                    while (n < TranslatorTool.this.table.getRowCount()) {
                        Rectangle rectangle = TranslatorTool.this.table.getCellRect(n, 0, true);
                        if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                            TranslatorTool.this.table.setRowSelectionInterval(n, n);
                            final String string = (String)TranslatorTool.this.table.getValueAt(n, 0);
                            JPopupMenu jPopupMenu = new JPopupMenu();
                            JMenuItem jMenuItem = new JMenuItem(String.valueOf(ToolsRes.getString("TranslatorTool.Popup.MenuItem.Remove")) + " \"" + string + "\"");
                            jPopupMenu.add(jMenuItem);
                            jMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    TranslatorTool.this.removeProperty(TranslatorTool.this.classType, string);
                                }
                            });
                            jPopupMenu.show(TranslatorTool.this.table, mouseEvent.getX(), mouseEvent.getY() + 8);
                        }
                        ++n;
                    }
                }
            }
        });
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof TableModelEvent) {
                    TableModelEvent tableModelEvent = (TableModelEvent)object;
                    int n = tableModelEvent.getFirstRow();
                    if (n < 0) {
                        return;
                    }
                    Map map = TranslatorTool.this.getProperties(TranslatorTool.this.classType, TranslatorTool.this.locale);
                    String string = (String)TranslatorTool.this.table.getValueAt(n, 0);
                    String string2 = (String)TranslatorTool.this.table.getValueAt(n, 1);
                    if (string2 != null && !string2.equals("")) {
                        map.put(string, string2);
                    } else {
                        TranslatorTool.this.table.setValueAt(string, n, 1);
                        map.put(string, string);
                    }
                    TranslatorTool.this.refreshAssociates(TranslatorTool.this.classType);
                    TranslatorTool.this.flagChange(map);
                    TranslatorTool.this.saveButton.setEnabled(true);
                }
            }
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.contentPane.add((Component)jToolBar, "North");
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.contentPane.add((Component)jScrollPane, "Center");
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        this.contentPane.add((Component)jToolBar2, "South");
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 6));
        jToolBar.add(this.descriptionLabel);
        this.localeDropDown = new JComboBox();
        LocaleItem localeItem = new LocaleItem(this.locale);
        this.localeDropDown.addItem(localeItem);
        Locale[] localeArray = OSPRuntime.getInstalledLocales();
        int n = 0;
        while (n < localeArray.length) {
            if (!localeArray[n].getDisplayLanguage().equals(this.locale.getDisplayLanguage())) {
                this.addDropDownItem(new LocaleItem(localeArray[n]));
            }
            ++n;
        }
        this.localeDropDown.setSelectedItem(localeItem);
        this.localeDropDown.setEditable(true);
        this.localeDropDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = TranslatorTool.this.localeDropDown.getSelectedItem();
                if (object == null) {
                    return;
                }
                if (object instanceof LocaleItem) {
                    ToolsRes.setLocale(((LocaleItem)object).loc);
                } else if (TranslatorTool.this.isLanguage(object.toString())) {
                    String string = new Locale(object.toString()).getLanguage();
                    Locale locale = null;
                    LocaleItem localeItem = null;
                    int n = 0;
                    while (n < TranslatorTool.this.localeDropDown.getItemCount()) {
                        localeItem = (LocaleItem)TranslatorTool.this.localeDropDown.getItemAt(n);
                        if (string.equals(localeItem.loc.getLanguage())) {
                            locale = localeItem.loc;
                            break;
                        }
                        localeItem = null;
                        ++n;
                    }
                    if (locale == null) {
                        locale = new Locale(object.toString());
                        Map map = TranslatorTool.this.getProperties(TranslatorTool.this.classType, locale);
                        TranslatorTool.this.flagChange(map);
                    }
                    ToolsRes.setLocale(locale);
                    if (localeItem != null) {
                        TranslatorTool.this.localeDropDown.setSelectedItem(localeItem);
                    }
                    TranslatorTool.this.localeDropDown.getEditor().selectAll();
                } else {
                    TranslatorTool.this.localeDropDown.setSelectedIndex(0);
                    TranslatorTool.this.localeDropDown.getEditor().selectAll();
                }
            }
        });
        jToolBar.add(this.localeDropDown);
        this.helpButton = new JButton();
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFrame textFrame;
                if (ResourceLoader.getResource(TranslatorTool.this.helpURL) != null) {
                    textFrame = new TextFrame(TranslatorTool.this.helpURL);
                } else {
                    String string = "/org/opensourcephysics/resources/tools/html/translator_tool_help.html";
                    textFrame = new TextFrame(string);
                }
                textFrame.setSize(800, 600);
                textFrame.setVisible(true);
            }
        });
        jToolBar2.add(this.helpButton);
        String string = "/org/opensourcephysics/resources/tools/images/save.gif";
        this.saveIcon = ResourceLoader.getIcon(string);
        this.saveButton = new JButton(this.saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslatorTool.this.save(String.valueOf(TranslatorTool.this.getPath(TranslatorTool.this.classType)) + TranslatorTool.this.fileExtension);
            }
        });
        this.saveButton.setEnabled(false);
        jToolBar2.add(Box.createHorizontalGlue());
        jToolBar2.add(this.saveButton);
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslatorTool.this.setVisible(false);
            }
        });
        jToolBar2.add(this.closeButton);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension.width - this.getBounds().width) / 2;
        int n3 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n2, n3);
    }

    protected void refreshGUI() {
        String string = ToolsRes.getString("TranslatorTool.Title");
        String string2 = XML.getName(this.getPath(this.classType));
        string = String.valueOf(string) + " " + string2;
        this.setTitle(string);
        string2 = String.valueOf(string2) + this.fileExtension;
        if (this.classType != null) {
            Map<String, String> map = this.getProperties(this.classType, this.locale);
            this.saveButton.setEnabled(this.changed.contains(map));
        }
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.saveButton.setText(ToolsRes.getString("TranslatorTool.Button.Save"));
        this.saveButton.setToolTipText(String.valueOf(ToolsRes.getString("TranslatorTool.Button.Save.ToolTip")) + string2);
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.setToolTipText(ToolsRes.getString("Tool.Button.Close.ToolTip"));
        this.descriptionLabel.setText(ToolsRes.getString("TranslatorTool.Label.Description"));
        this.table.refresh();
    }

    protected void refreshAssociates(Class<?> clazz) {
        for (Object object : this.getAssociates(clazz)) {
            if (object instanceof XMLTable) {
                ((XMLTable)object).refresh();
                continue;
            }
            if (!(object instanceof PropertyChangeListener)) continue;
            ((PropertyChangeListener)object).propertyChange(new PropertyChangeEvent(TOOL, "translation", null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flagChange(Map<String, String> map) {
        Set<Map<String, String>> set = this.changed;
        synchronized (set) {
            this.changed.add(map);
        }
    }

    private class LocaleItem {
        Locale loc;
        String language;

        LocaleItem(Locale locale) {
            this.loc = locale;
            this.language = this.loc.getDisplayLanguage(this.loc);
            if (this.isDefault()) {
                this.language = String.valueOf(this.language) + " (" + ToolsRes.getString("TranslatorTool.Language.Default") + ")";
            }
        }

        public String toString() {
            return this.language;
        }

        public boolean isDefault() {
            return this.loc.getDisplayLanguage(this.loc).equals(Locale.getDefault().getDisplayLanguage(this.loc));
        }
    }
}

