/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.ToolsRes;

public class FunctionPanel
extends JPanel
implements PropertyChangeListener {
    protected FunctionTool functionTool;
    protected ParamEditor paramEditor;
    protected FunctionEditor functionEditor;
    protected Container box;
    protected JTextPane instructions;
    private JButton undoButton;
    private JButton redoButton;
    private UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    private int varBegin;
    private int varEnd;
    protected JTextField tableEditorField;
    protected String prevName;

    public FunctionPanel(FunctionEditor functionEditor) {
        super(new BorderLayout());
        this.functionEditor = functionEditor;
        functionEditor.functionPanel = this;
        this.createGUI();
        this.refreshGUI();
    }

    public ParamEditor getParamEditor() {
        return this.paramEditor;
    }

    public FunctionEditor getFunctionEditor() {
        return this.functionEditor;
    }

    public FunctionEditor.Table getFunctionTable() {
        return this.functionEditor.getTable();
    }

    public FunctionEditor.Table getParamTable() {
        return this.paramEditor.getTable();
    }

    public String getLabel() {
        return ToolsRes.getString("FunctionPanel.Label");
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = this.paramEditor.buttonPanel.getPreferredSize().width;
        return dimension;
    }

    protected void addForbiddenNames(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.functionEditor.forbiddenNames.add(stringArray[n]);
            if (this.paramEditor != null) {
                this.paramEditor.forbiddenNames.add(stringArray[n]);
            }
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("edit")) {
            if (propertyChangeEvent.getNewValue() instanceof UndoableEdit) {
                this.undoSupport.postEdit((UndoableEdit)propertyChangeEvent.getNewValue());
            }
            this.refreshFunctions();
            this.refreshGUI();
            if (this.functionTool != null && this.functionEditor.getObjects().size() > 0) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = null;
                if (propertyChangeEvent.getNewValue() instanceof FunctionEditor.DefaultEdit) {
                    FunctionEditor.DefaultEdit defaultEdit = (FunctionEditor.DefaultEdit)propertyChangeEvent.getNewValue();
                    if (defaultEdit.editType == 2) {
                        string2 = defaultEdit.undoObj.toString();
                    }
                } else if (propertyChangeEvent.getNewValue() instanceof String) {
                    string2 = propertyChangeEvent.getNewValue().toString();
                }
                this.functionTool.firePropertyChange("function", string2, string);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("function")) {
            this.refreshFunctions();
            this.refreshGUI();
            if (this.functionTool != null) {
                this.functionTool.firePropertyChange("function", null, null);
            }
        }
    }

    protected void clearSelection() {
        this.getFunctionTable().clearSelection();
        this.getParamTable().clearSelection();
        this.refreshInstructions(null, false, -1);
    }

    protected void createGUI() {
        this.instructions = new JTextPane(){

            public void paintComponent(Graphics graphics) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(graphics);
            }
        };
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setFocusable(false);
        this.instructions.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        StyledDocument styledDocument = this.instructions.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style2 = styledDocument.addStyle("blue", style);
        StyleConstants.setBold(style2, false);
        StyleConstants.setForeground(style2, Color.blue);
        Style style3 = styledDocument.addStyle("red", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setForeground(style3, Color.red);
        this.instructions.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (FunctionPanel.this.varEnd == 0) {
                    return;
                }
                FunctionPanel.this.instructions.setCaretPosition(FunctionPanel.this.varBegin);
                FunctionPanel.this.instructions.moveCaretPosition(FunctionPanel.this.varEnd);
                FunctionPanel.this.tableEditorField.replaceSelection(FunctionPanel.this.instructions.getSelectedText());
                FunctionPanel.this.tableEditorField.setBackground(Color.yellow);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (!FunctionPanel.this.hasCircularErrors() && !FunctionPanel.this.hasInvalidExpressions()) {
                    StyledDocument styledDocument = FunctionPanel.this.instructions.getStyledDocument();
                    Style style = styledDocument.getStyle("blue");
                    styledDocument.setCharacterAttributes(0, FunctionPanel.this.instructions.getText().length(), style, false);
                    FunctionPanel.this.varEnd = 0;
                    FunctionPanel.this.varBegin = 0;
                }
            }
        });
        this.instructions.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                FunctionPanel.this.varEnd = 0;
                FunctionPanel.this.varBegin = 0;
                String string = FunctionPanel.this.instructions.getText();
                int n = string.indexOf(":");
                if (n == -1) {
                    return;
                }
                StyledDocument styledDocument = FunctionPanel.this.instructions.getStyledDocument();
                Style style = styledDocument.getStyle("blue");
                Style style2 = styledDocument.getStyle("red");
                int n2 = FunctionPanel.this.instructions.viewToModel(mouseEvent.getPoint()) - n - 1;
                if (n2 < 1) {
                    styledDocument.setCharacterAttributes(0, string.length(), style, false);
                    return;
                }
                String string2 = string.substring(n + 1);
                String string3 = string2.substring(0, n2);
                int n3 = string3.lastIndexOf(" ") + 1;
                int n4 = (string3 = string2.substring(n3)).indexOf(",");
                if (n4 == -1) {
                    n4 = string3.length();
                }
                FunctionPanel.this.varBegin = n + 1 + n3;
                FunctionPanel.this.varEnd = FunctionPanel.this.varBegin + n4;
                styledDocument.setCharacterAttributes(0, FunctionPanel.this.varBegin, style, false);
                styledDocument.setCharacterAttributes(FunctionPanel.this.varBegin, n4, style2, false);
                styledDocument.setCharacterAttributes(FunctionPanel.this.varEnd, string.length() - FunctionPanel.this.varEnd, style, false);
            }
        });
        this.box = Box.createVerticalBox();
        this.add((Component)this.box, "Center");
        this.paramEditor = new ParamEditor();
        this.paramEditor.functionPanel = this;
        this.functionEditor.setParamEditor(this.paramEditor);
        this.paramEditor.setFunctionEditors(new FunctionEditor[]{this.functionEditor});
        this.box.add(this.paramEditor);
        this.box.add(this.functionEditor);
        this.paramEditor.addPropertyChangeListener(this);
        this.paramEditor.addPropertyChangeListener(this.functionEditor);
        this.functionEditor.addPropertyChangeListener(this);
        this.functionEditor.addPropertyChangeListener(this.paramEditor);
        JScrollPane jScrollPane = new JScrollPane(this.instructions){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Font font = FunctionPanel.this.instructions.getFont();
                dimension.height = font.getSize() * 3;
                return dimension;
            }
        };
        this.box.add(jScrollPane);
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.undoButton = new JButton();
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionPanel.this.undoManager.undo();
            }
        });
        this.redoButton = new JButton();
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionPanel.this.undoManager.redo();
            }
        });
    }

    protected void refreshGUI() {
        this.undoButton.setText(ToolsRes.getString("DataFunctionPanel.Button.Undo"));
        this.undoButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.Undo.Tooltip"));
        this.redoButton.setText(ToolsRes.getString("DataFunctionPanel.Button.Redo"));
        this.redoButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.Redo.Tooltip"));
        if (this.functionTool != null) {
            this.functionTool.buttonbar.removeAll();
            this.functionTool.buttonbar.add(this.functionTool.helpButton);
            this.functionTool.buttonbar.add(this.undoButton);
            this.functionTool.buttonbar.add(this.redoButton);
            this.functionTool.buttonbar.add(this.functionTool.fontButton);
            this.functionTool.buttonbar.add(this.functionTool.closeButton);
        }
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
        this.paramEditor.refreshGUI();
        this.functionEditor.refreshGUI();
        this.refreshInstructions(null, false, -1);
    }

    protected void setFontLevel(int n) {
        FontSizer.setFonts(this, n);
        FontSizer.setFonts(this.undoButton, n);
        FontSizer.setFonts(this.redoButton, n);
    }

    protected void refreshFunctions() {
        this.functionEditor.evaluateAll();
    }

    protected void refreshParameters() {
        this.paramEditor.refreshParametersFromData();
        this.refreshFunctions();
    }

    protected void setFunctionTool(FunctionTool functionTool) {
        this.functionTool = functionTool;
    }

    protected void tabToNext(FunctionEditor functionEditor) {
        if (functionEditor == this.functionEditor) {
            this.functionTool.helpButton.requestFocusInWindow();
        } else {
            this.functionEditor.newButton.requestFocusInWindow();
        }
    }

    protected void refreshInstructions(FunctionEditor functionEditor, boolean bl, int n) {
        String string;
        StyledDocument styledDocument = this.instructions.getStyledDocument();
        Style style = styledDocument.getStyle("blue");
        String string2 = string = this.isEmpty() ? ToolsRes.getString("FunctionPanel.Instructions.GetStarted") : ToolsRes.getString("FunctionPanel.Instructions.General");
        if (!bl && this.hasCircularErrors()) {
            string = ToolsRes.getString("FunctionPanel.Instructions.CircularErrors");
            style = styledDocument.getStyle("red");
        } else if (!bl && this.hasInvalidExpressions()) {
            string = ToolsRes.getString("FunctionPanel.Instructions.BadCell");
            style = styledDocument.getStyle("red");
        } else if (functionEditor != null) {
            if (n == 0 && bl) {
                string = ToolsRes.getString("FunctionPanel.Instructions.NameCell");
            } else if (n == 1 && bl) {
                string = functionEditor.getVariablesString();
            } else if (n > -1) {
                string = ToolsRes.getString("FunctionPanel.Instructions.EditCell");
                string = n == 0 ? String.valueOf(string) + " " + ToolsRes.getString("FunctionPanel.Instructions.NameCell") : String.valueOf(string) + " " + ToolsRes.getString("FunctionPanel.Instructions.Help");
            }
        }
        this.instructions.setText(string);
        int n2 = this.instructions.getText().length();
        styledDocument.setCharacterAttributes(0, n2, style, false);
        this.revalidate();
    }

    protected boolean isEmpty() {
        return this.functionEditor.getObjects().size() == 0 && this.paramEditor.getObjects().size() == 0;
    }

    protected boolean hasInvalidExpressions() {
        return this.functionEditor.containsInvalidExpressions() || this.paramEditor.containsInvalidExpressions();
    }

    protected boolean hasCircularErrors() {
        return !this.functionEditor.circularErrors.isEmpty() || !this.paramEditor.circularErrors.isEmpty();
    }
}

