/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.display.DataRowTable;

public class DataPanel
extends JPanel {
    DataRowTable table = new DataRowTable();
    JScrollPane scrollPane = new JScrollPane(this.table);

    public DataPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    public void refreshTable() {
        this.table.refreshTable();
    }

    public void setColumnNames(int n, String string) {
        if (this.table.rowModel.setColumnNames(n, string)) {
            this.refreshTable();
        }
    }

    public void setColumnNames(String[] stringArray) {
        boolean bl = false;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (this.table.rowModel.setColumnNames(n, stringArray[n])) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.refreshTable();
        }
    }

    public void setRowNumberVisible(boolean bl) {
        if (this.table.rowModel.setRowNumberVisible(bl)) {
            this.refreshTable();
        }
    }

    public void setFirstRowIndex(int n) {
        if (this.table.rowModel.firstRowIndex != n) {
            this.table.rowModel.firstRowIndex = n;
            this.refreshTable();
        }
    }

    public void setRefreshDelay(int n) {
        this.table.setRefreshDelay(n);
    }

    public synchronized void appendArray(Object object) throws IllegalArgumentException {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("");
        }
        Class<?> clazz = object.getClass().getComponentType();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String string = clazz.getName();
        if (string.equals("double")) {
            double[][] dArray = (double[][])object;
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            int n2 = dArray[0].length;
            while (n < n2) {
                int n3 = 0;
                int n4 = dArray2.length;
                while (n3 < n4) {
                    dArray2[n3] = dArray[n3][n];
                    ++n3;
                }
                this.appendRow(dArray2);
                ++n;
            }
        } else if (string.equals("int")) {
            int[][] nArray = (int[][])object;
            int[] nArray2 = new int[nArray.length];
            int n = 0;
            int n5 = nArray[0].length;
            while (n < n5) {
                int n6 = 0;
                int n7 = nArray2.length;
                while (n6 < n7) {
                    nArray2[n6] = nArray[n6][n];
                    ++n6;
                }
                this.appendRow(nArray2);
                ++n;
            }
        } else if (string.equals("byte")) {
            byte[][] byArray = (byte[][])object;
            byte[] byArray2 = new byte[byArray.length];
            int n = 0;
            int n8 = byArray[0].length;
            while (n < n8) {
                int n9 = 0;
                int n10 = byArray2.length;
                while (n9 < n10) {
                    byArray2[n9] = byArray[n9][n];
                    ++n9;
                }
                this.appendRow(byArray2);
                ++n;
            }
        } else {
            Object[][] objectArray = (Object[][])object;
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            int n11 = objectArray[0].length;
            while (n < n11) {
                int n12 = 0;
                int n13 = objectArray2.length;
                while (n12 < n13) {
                    objectArray2[n12] = objectArray[n12][n];
                    ++n12;
                }
                this.appendRow(objectArray2);
                ++n;
            }
        }
    }

    public synchronized void appendRow(double[] dArray) {
        this.table.rowModel.appendDoubles(dArray);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(int[] nArray) {
        this.table.rowModel.appendInts(nArray);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(Object[] objectArray) {
        this.table.rowModel.appendRow(objectArray);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(byte[] byArray) {
        this.table.rowModel.appendBytes(byArray);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public boolean isRowNumberVisible() {
        return this.table.rowModel.rowNumberVisible;
    }

    public int getColumnCount() {
        return this.table.rowModel.getColumnCount();
    }

    public int getRowCount() {
        return this.table.rowModel.getRowCount();
    }

    public int getTotalRowCount() {
        return this.table.rowModel.rowList.size();
    }

    public int getStride() {
        return this.table.rowModel.stride;
    }

    public void setColumnFormat(int n, String string) {
        this.table.setColumnFormat(n, string);
    }

    public void setNumericFormat(String string) {
        this.table.setNumericFormat(string);
    }

    public void setMaxPoints(int n) {
        this.table.rowModel.setMaxPoints(n);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.table.refreshTable();
        }
        super.setVisible(bl);
    }

    public void setStride(int n) {
        this.table.setStride(n);
    }

    public void clearData() {
        this.table.clearData();
    }

    public void clear() {
        this.table.clear();
    }
}

