/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.GroupVariable;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.PropertyEditor;
import org.colos.ejs.library.control.VariableEditor;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.InterpretedValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.tools.ResourceLoader;

public abstract class ControlElement {
    protected EjsControl myGroup = null;
    protected Hashtable myPropertiesTable = new Hashtable();
    protected Object myObject = null;
    private boolean myActiveState = true;
    private Vector myActionsList = new Vector();
    private GroupVariable[] myProperties = null;
    private String[] myPropertiesNames = null;
    protected boolean isUnderEjs = false;
    MethodWithOneParameter[] myMethodsForProperties = null;
    Value[] myExpressionsForProperties = null;
    protected PropertyEditor myEjsPropertyEditor = null;
    VariableEditor myEjsVariableEditor = null;
    public static final int NAME = 0;
    public static final int ACTION = 0;
    public static final int VARIABLE_CHANGED = 1;
    public static final int METHOD_FOR_VARIABLE = 2;
    public static final int ACTION_ERROR = 1001;
    public static final int ACTION_SUCCESS = 1002;
    public static final String METHOD_TRIGGER = "_expr_";

    public static int indexOf(String string, String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (string.equals(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ControlElement() {
        ArrayList arrayList = this.getPropertyList();
        this.myPropertiesNames = new String[arrayList.size()];
        this.myProperties = new GroupVariable[arrayList.size()];
        this.myMethodsForProperties = new MethodWithOneParameter[arrayList.size()];
        this.myExpressionsForProperties = new Value[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            String string;
            this.myPropertiesNames[n] = string = (String)arrayList.get(n);
            this.myProperties[n] = null;
            this.myMethodsForProperties[n] = null;
            this.myExpressionsForProperties[n] = null;
            ++n;
        }
    }

    public Object getObject() {
        return this.myObject;
    }

    public String getObjectClassname() {
        return this.myObject.getClass().getName();
    }

    public Object getObject(String string) {
        if (string == null || string.trim().length() <= 0) {
            return this.getObject();
        }
        return null;
    }

    public void addMenuEntries() {
    }

    public void replaceVisual(Frame frame) {
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.myEjsPropertyEditor = propertyEditor;
    }

    protected final boolean editorIsReading() {
        return this.myEjsPropertyEditor.isReading();
    }

    public void setVariableEditor(VariableEditor variableEditor) {
        this.myEjsVariableEditor = variableEditor;
    }

    public final void setFieldListValue(int n, Value value) {
        this.setFieldListValue(n, value, true);
    }

    protected final void setFieldListValue(int n, Value value, boolean bl) {
        if (this.myEjsPropertyEditor == null || this.myEjsVariableEditor == null) {
            return;
        }
        if (this.myMethodsForProperties[n] == null && this.myExpressionsForProperties[n] == null) {
            if (this.myProperties[n] != null) {
                this.myEjsVariableEditor.updateTableValues(this.myEjsPropertyEditor, this.myProperties[n].getName(), this.toStringValue(value));
            } else {
                String string = this.myPropertiesNames[n];
                for (JTextComponent jTextComponent : this.myEjsPropertyEditor.getFieldList()) {
                    if (!jTextComponent.getName().equals(string)) continue;
                    jTextComponent.setText(this.toStringValue(value));
                    jTextComponent.setCaretPosition(0);
                    jTextComponent.setBackground(Color.white);
                    this.setProperty(string, this.toStringValue(value));
                    this.reset();
                    break;
                }
            }
        }
        if (bl) {
            this.myEjsVariableEditor.updateControlValues(false);
        }
    }

    protected final void setFieldListValueWithAlternative(int n, int n2, Value value) {
        if (this.myEjsPropertyEditor == null || this.myEjsVariableEditor == null) {
            return;
        }
        if (this.myMethodsForProperties[n] == null && this.myExpressionsForProperties[n] == null) {
            if (this.myProperties[n] != null) {
                this.myEjsVariableEditor.updateTableValues(this.myEjsPropertyEditor, this.myProperties[n].getName(), this.toStringValue(value));
                this.setFieldListValue(n2, value);
                return;
            }
            String string = this.myPropertiesNames[n];
            for (JTextComponent jTextComponent : this.myEjsPropertyEditor.getFieldList()) {
                if (!jTextComponent.getName().equals(string)) continue;
                jTextComponent.setText(this.toStringValue(value));
                jTextComponent.setCaretPosition(0);
                jTextComponent.setBackground(Color.white);
                this.setProperty(string, this.toStringValue(value));
                this.reset();
            }
        }
        this.myEjsVariableEditor.updateControlValues(false);
    }

    public final void setFieldListValues(int[] nArray, Value[] valueArray) {
        if (this.myEjsPropertyEditor == null || this.myEjsVariableEditor == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int n3 = nArray[n];
            if (n3 >= 0 && this.myMethodsForProperties[n3] == null && this.myExpressionsForProperties[n3] == null) {
                if (this.myProperties[n3] != null) {
                    bl = true;
                    this.myEjsVariableEditor.updateTableValues(this.myEjsPropertyEditor, this.myProperties[n3].getName(), valueArray[n].getString());
                } else {
                    String string = this.myPropertiesNames[n3];
                    if (!this.propertyIsTypeOf(string, "DEPRECATED") || this.myGroup == null || this.myGroup.getBoolean("_Ejs_ShowDeprecated_")) {
                        for (JTextComponent jTextComponent : this.myEjsPropertyEditor.getFieldList()) {
                            if (!jTextComponent.getName().equals(string)) continue;
                            jTextComponent.setText(valueArray[n].getString());
                            jTextComponent.setCaretPosition(0);
                            jTextComponent.setBackground(Color.white);
                            this.setProperty(string, valueArray[n].getString());
                            this.reset();
                        }
                    }
                }
            }
            ++n;
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ControlElement.this.myEjsVariableEditor.updateControlValues(false);
                }
            });
        }
    }

    public abstract ArrayList getPropertyList();

    public abstract String getPropertyInfo(String var1);

    public String getPropertyCommonName(String string) {
        return string;
    }

    public Value parseConstant(String string, String string2) {
        Value value;
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("boolean") >= 0 && (value = ConstantParser.booleanConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("Color") >= 0 && (value = ConstantParser.colorConstant(string2)) != null) {
            return value;
        }
        if (string.indexOf("File") >= 0 && ResourceLoader.getResource(string2) != null) {
            return new StringValue(string2);
        }
        if (string.indexOf("Font") >= 0) {
            Font font = null;
            if (this.getVisual() != null) {
                font = this.getVisual().getFont();
            }
            if ((value = ConstantParser.fontConstant(font, string2)) != null) {
                return value;
            }
        }
        if (string.indexOf("Format") >= 0 && (value = ConstantParser.formatConstant(string2)) != null) {
            return value;
        }
        if ((string.indexOf("Margins") >= 0 || string.indexOf("Rectangle") >= 0) && (value = ConstantParser.rectangleConstant(string2)) != null) {
            return value;
        }
        return null;
    }

    public String toStringValue(Value value) {
        if (value instanceof StringValue) {
            return "\"" + value.getString() + "\"";
        }
        return value.getString();
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.myGroup == null) break;
                this.myGroup.rename(this, value.toString());
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                if (this.myGroup == null) break;
                this.myGroup.rename(this, null);
            }
        }
    }

    public String getDefaultValueString(int n) {
        return "???";
    }

    public Value getValue(int n) {
        return null;
    }

    public ControlElement setProperty(String string, String string2) {
        return this.setProperty(string, string2, true);
    }

    public ControlElement setProperty(String string, String string2, boolean bl) {
        int n;
        if ((string = string.trim()).equals("_ejs_")) {
            this.isUnderEjs = true;
        }
        if ((n = this.propertyIndex(string)) < 0) {
            if (string2 == null) {
                this.myPropertiesTable.remove(string);
            } else if (bl) {
                this.myPropertiesTable.put(string, string2);
            }
            return this;
        }
        this.myMethodsForProperties[n] = null;
        this.myExpressionsForProperties[n] = null;
        if (this.myProperties[n] != null) {
            this.myProperties[n].removeElementListener(this, n);
            this.myProperties[n] = null;
        }
        if (string2 == null) {
            if (this.myProperties[n] != null) {
                this.myProperties[n].removeElementListener(this, n);
                this.myProperties[n] = null;
            }
            this.setDefaultValue(n);
            this.myPropertiesTable.remove(string);
            return this;
        }
        if (!this.propertyIsTypeOf(string, "NotTrimmed")) {
            string2 = string2.trim();
        }
        String string3 = string2;
        Value value = null;
        if (string2.startsWith("%") && string2.endsWith("%") && string2.length() > 2) {
            string2 = string2.substring(1, string2.length() - 1);
        } else if (!(string2.startsWith("@") && string2.endsWith("@") && string2.length() > 2 || string2.startsWith("#") && string2.endsWith("#") && string2.length() > 2)) {
            if (!string2.startsWith("\"") && !string2.startsWith("'")) {
                if (this.propertyIsTypeOf(string, "CONSTANT")) {
                    value = new StringValue(string2);
                }
                if (value == null && this.propertyType(string).equals("String") && !this.propertyIsTypeOf(string, "VARIABLE_EXPECTED")) {
                    value = new StringValue(string2);
                }
            }
            if (value == null) {
                value = this.parseConstant(this.propertyType(string), string2);
            }
            if (value == null) {
                value = Value.parseConstantOrArray(string2, true);
            }
        }
        if (value != null) {
            this.setValue(n, value);
            if (bl) {
                this.myPropertiesTable.put(string, string3);
            }
            return this;
        }
        if (this.myGroup == null) {
            if (bl) {
                this.myPropertiesTable.put(string, string3);
            }
            return this;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        if (string2.startsWith("#") && string2.endsWith("#") && string2.length() > 2) {
            string2 = string2.substring(1, string2.length() - 1);
            bl2 = true;
        } else if (string2.startsWith("@") && string2.endsWith("@") && string2.length() > 2) {
            string3 = string2 = string2.substring(1, string2.length() - 1);
            bl2 = false;
            bl3 = true;
        } else if (string2.startsWith("new ")) {
            string3 = string2;
            bl2 = false;
            bl3 = false;
        } else if (string2.indexOf(40) >= 0) {
            bl2 = false;
        }
        if (bl2) {
            Value value2 = null;
            value2 = this.getValue(n);
            if (value2 == null) {
                value2 = this.propertyIsTypeOf(string, "double") ? new DoubleValue(0.0) : (this.propertyIsTypeOf(string, "boolean") ? new BooleanValue(false) : (this.propertyIsTypeOf(string, "int") ? new IntegerValue(0) : (this.propertyIsTypeOf(string, "String") ? new StringValue(string2) : new ObjectValue(null))));
            }
            this.myProperties[n] = this.myGroup.registerVariable(string2, this, n, value2);
        } else if (bl3) {
            String string4 = null;
            if (this.propertyIsTypeOf(string, "double")) {
                string4 = "double";
            } else if (this.propertyIsTypeOf(string, "boolean")) {
                string4 = "boolean";
            } else if (this.propertyIsTypeOf(string, "int")) {
                string4 = "int";
            } else if (this.propertyIsTypeOf(string, "String")) {
                string4 = "String";
            } else if (this.propertyIsTypeOf(string, "Action")) {
                string4 = "Action";
            } else {
                this.myPropertiesTable.put(string, string3);
                return this;
            }
            if (!string4.equals("Action")) {
                this.myExpressionsForProperties[n] = new InterpretedValue(string2, this.myEjsPropertyEditor);
                this.myGroup.methodTriggerVariable.addElementListener(this, n);
                this.myProperties[n] = this.myGroup.methodTriggerVariable;
            }
        } else if (this.getProperty("_ejs_") == null) {
            Object object;
            String string5 = null;
            if (this.propertyIsTypeOf(string, "String")) {
                string5 = "String";
            } else if (this.propertyIsTypeOf(string, "Color")) {
                string5 = "Object";
            } else if (this.propertyIsTypeOf(string, "double")) {
                string5 = "double";
            } else if (this.propertyIsTypeOf(string, "boolean")) {
                string5 = "boolean";
            } else if (this.propertyIsTypeOf(string, "int")) {
                string5 = "int";
            } else if (this.propertyIsTypeOf(string, "double[]")) {
                string5 = "Object";
            } else if (this.propertyIsTypeOf(string, "int[]")) {
                string5 = "Object";
            } else if (this.propertyIsTypeOf(string, "Object")) {
                string5 = "Object";
            } else {
                System.out.println("Error for property " + string + " of the element " + this.toString() + ". Cannot be set to : " + string3);
                this.myPropertiesTable.put(string, string3);
                return this;
            }
            String[] stringArray = MethodWithOneParameter.splitMethodName(string2);
            if (stringArray == null) {
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! method <" + string3 + "> not found");
                this.myPropertiesTable.put(string, string3);
                return this;
            }
            if (stringArray[0] == null) {
                stringArray[0] = "_default_";
            }
            if ((object = this.myGroup.getTarget(stringArray[0])) == null) {
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + stringArray[0] + "> not assigned");
                this.myPropertiesTable.put(string, string3);
                return this;
            }
            string2 = stringArray[2] == null ? String.valueOf(stringArray[1]) + "()" : String.valueOf(stringArray[1]) + "(" + stringArray[2] + ")";
            this.myMethodsForProperties[n] = new MethodWithOneParameter(2, object, string2, string5, null, this);
            this.myGroup.methodTriggerVariable.addElementListener(this, n);
            this.myProperties[n] = this.myGroup.methodTriggerVariable;
            this.myGroup.update();
        }
        if (bl) {
            this.myPropertiesTable.put(string, string3);
        }
        return this;
    }

    public final ControlElement setProperties(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.trim().length() <= 0) continue;
            int n = string2.indexOf("=");
            if (n < 0) {
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Token <" + string2 + "> invalid for " + this.toString());
                continue;
            }
            hashtable.put(string2.substring(0, n).trim(), string2.substring(n + 1));
        }
        return this.setProperties(hashtable);
    }

    private void preprocess(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            this.setProperty(string, string2);
            hashtable.remove(string);
        }
    }

    private ControlElement setProperties(Hashtable hashtable) {
        String string;
        this.preprocess("_ejs_", hashtable);
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.propertyIsTypeOf(string, "PREVIOUS")) {
                this.preprocess(string, hashtable);
                continue;
            }
            if (!this.propertyIsTypeOf(string, "POSTPROCESS")) continue;
            String string2 = (String)hashtable.get(string);
            hashtable.remove(string);
            hashtable2.put(string, string2);
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.setProperty(string, (String)hashtable.get(string));
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.setProperty(string, (String)hashtable2.get(string));
        }
        return this;
    }

    public final String getProperty(String string) {
        return (String)this.myPropertiesTable.get(string);
    }

    public final boolean propertyIsTypeOf(String string, String string2) {
        String string3 = this.getPropertyInfo(string);
        if (string3 == null) {
            return false;
        }
        string2 = string2.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " |");
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().toLowerCase().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public final String propertyType(String string) {
        String string2 = this.getPropertyInfo(string);
        if (string2 == null) {
            return "double";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        if (stringTokenizer.countTokens() >= 1) {
            return stringTokenizer.nextToken();
        }
        return "double";
    }

    public Component getComponent() {
        return null;
    }

    public Component getVisual() {
        return null;
    }

    public boolean acceptsChild(ControlElement controlElement) {
        return false;
    }

    public void reset() {
    }

    public void initialize() {
    }

    public void onExit() {
    }

    @Deprecated
    public final void flush() {
    }

    public int propertyIndex(String string) {
        if (this.myPropertiesNames != null) {
            int n = 0;
            while (n < this.myPropertiesNames.length) {
                if (this.myPropertiesNames[n].equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean implementsProperty(String string) {
        return this.propertyIndex(string) >= 0;
    }

    public final void variablePropertiesClear() {
        if (this.myPropertiesNames != null) {
            int n = 0;
            while (n < this.myPropertiesNames.length) {
                this.setProperty(this.myPropertiesNames[n], null);
                ++n;
            }
        }
    }

    public String toString() {
        String string = (String)this.myPropertiesTable.get("name");
        if (string != null) {
            return string;
        }
        String string2 = this.getClass().getName();
        int n = string2.lastIndexOf(".");
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        return "Unnamed element of type " + string2;
    }

    public void destroy() {
        this.setProperty("parent", null);
        if (this.myProperties != null) {
            int n = 0;
            while (n < this.myProperties.length) {
                if (this.myProperties[n] != null) {
                    this.myProperties[n].removeElementListener(this, n);
                }
                ++n;
            }
        }
    }

    public final ControlElement addAction(int n, Object object, String string) {
        this.myActionsList.addElement(new MethodWithOneParameter(n, object, string, null, null, this));
        return this;
    }

    public final ControlElement addAction(int n, Object object, String string, MethodWithOneParameter methodWithOneParameter) {
        this.myActionsList.addElement(new MethodWithOneParameter(n, object, string, null, methodWithOneParameter, this));
        return this;
    }

    public final ControlElement addAction(int n, String string) {
        if (this.getProperty("_ejs_") != null) {
            string = "_ejs_.execute(\"" + string + "\")";
        }
        Object object = null;
        MethodWithOneParameter methodWithOneParameter = null;
        String[] stringArray = MethodWithOneParameter.splitMethodName(string);
        if (stringArray == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Method <" + string + "> not assigned");
            return this;
        }
        if (stringArray[0] == null) {
            stringArray[0] = "_default_";
        }
        if (this.myGroup != null) {
            object = this.myGroup.getTarget(stringArray[0]);
            if (n != 1 && this.getProperty("_ejs_SecondAction_") != null && this.myGroup.getTarget("_default_") != null) {
                methodWithOneParameter = new MethodWithOneParameter(n, this.myGroup.getTarget("_default_"), this.getProperty("_ejs_SecondAction_"), null, null, this);
            }
        }
        if (object == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + stringArray[0] + "> not assigned");
            return this;
        }
        if (stringArray[2] == null) {
            return this.addAction(n, object, String.valueOf(stringArray[1]) + "()", methodWithOneParameter);
        }
        return this.addAction(n, object, String.valueOf(stringArray[1]) + "(" + stringArray[2] + ")", methodWithOneParameter);
    }

    public final void removeAction(int n, Object object, String string) {
        if (string == null) {
            return;
        }
        Enumeration enumeration = this.myActionsList.elements();
        while (enumeration.hasMoreElements()) {
            MethodWithOneParameter methodWithOneParameter = (MethodWithOneParameter)enumeration.nextElement();
            if (!methodWithOneParameter.equals(n, object, string)) continue;
            if (!this.myActionsList.removeElement(methodWithOneParameter)) {
                System.err.println(String.valueOf(this.getClass().getName()) + ": Error! Action " + string + " not removed");
            }
            return;
        }
    }

    public final void removeAction(int n, String string) {
        String[] stringArray;
        if (string == null) {
            return;
        }
        if (this.getProperty("_ejs_") != null) {
            string = "_ejs_.execute(\"" + string + "\")";
        }
        if ((stringArray = MethodWithOneParameter.splitMethodName(string)) == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Method <" + string + "> not removed");
            return;
        }
        if (stringArray[0] == null) {
            stringArray[0] = "_default_";
        }
        Object object = null;
        if (this.myGroup != null) {
            object = this.myGroup.getTarget(stringArray[0]);
        }
        if (object == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + stringArray[0] + "> not assigned");
            return;
        }
        this.removeAction(n, object, String.valueOf(stringArray[1]) + "(" + stringArray[2] + ")");
    }

    public final void invokeActions() {
        this.invokeActions(0);
    }

    public final void invokeActions(int n) {
        if (this.myActiveState) {
            Enumeration enumeration = this.myActionsList.elements();
            while (enumeration.hasMoreElements()) {
                ((MethodWithOneParameter)enumeration.nextElement()).invoke(n, this);
            }
        }
    }

    public final void variableChangedDoNotUpdate(int n, Value value) {
        if (this.myGroup != null && this.myProperties != null) {
            this.myGroup.setReportingChange(true);
            this.myGroup.variableChanged(this.myProperties[n], this, value);
            this.myGroup.setReportingChange(false);
        }
        if (this.myActiveState) {
            Enumeration enumeration = this.myActionsList.elements();
            while (enumeration.hasMoreElements()) {
                MethodWithOneParameter methodWithOneParameter = (MethodWithOneParameter)enumeration.nextElement();
                methodWithOneParameter.invoke(1, this);
            }
        }
    }

    public final void variableChanged(int n, Value value) {
        if (this.myMethodsForProperties[n] != null) {
            return;
        }
        this.variableChangedDoNotUpdate(n, value);
        if (this.myGroup != null) {
            this.myGroup.updateSimulation();
        }
    }

    public final void variableExtraChanged(int n, Value value) {
        if (this.myMethodsForProperties[n] != null) {
            return;
        }
        if (this.myGroup != null && this.myProperties != null) {
            this.myGroup.variableChanged(this.myProperties[n], this, value);
        }
        if (this.myGroup != null) {
            this.myGroup.updateSimulation();
        }
    }

    public final void variablesChanged(int[] nArray, Value[] valueArray) {
        boolean bl = false;
        if (this.myGroup != null && this.myProperties != null) {
            int n = 0;
            while (n < nArray.length) {
                if (this.myMethodsForProperties[nArray[n]] == null) {
                    this.myGroup.variableChanged(this.myProperties[nArray[n]], this, valueArray[n]);
                    bl = true;
                }
                ++n;
            }
        }
        if (!bl) {
            return;
        }
        if (this.myActiveState) {
            Enumeration enumeration = this.myActionsList.elements();
            while (enumeration.hasMoreElements()) {
                MethodWithOneParameter methodWithOneParameter = (MethodWithOneParameter)enumeration.nextElement();
                methodWithOneParameter.invoke(1, this);
            }
        }
        if (this.myGroup != null) {
            this.myGroup.updateSimulation();
        }
    }

    public final void setActive(boolean bl) {
        this.myActiveState = bl;
    }

    public final boolean isActive() {
        return this.myActiveState;
    }

    public final void setGroup(EjsControl ejsControl) {
        this.myGroup = ejsControl;
    }

    public final EjsControl getGroup() {
        return this.myGroup;
    }

    public final Simulation getSimulation() {
        if (this.myGroup == null) {
            return null;
        }
        return this.myGroup.getSimulation();
    }
}

