/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionEditor
extends JPanel
implements PropertyChangeListener {
    public static final int ADD_EDIT = 0;
    public static final int REMOVE_EDIT = 1;
    public static final int NAME_EDIT = 2;
    public static final int EXPRESSION_EDIT = 3;
    protected static String[] editTypes = new String[]{"add row", "delete row", "edit name", "edit expression"};
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    static final Color LIGHT_MAGENTA = new Color(255, 153, 204);
    static final Color LIGHT_RED = new Color(255, 204, 204);
    static final Color LIGHT_GRAY = UIManager.getColor("Panel.background");
    static NumberFormat decimalFormat = NumberFormat.getInstance();
    static DecimalFormat sciFormat;
    protected ParamEditor paramEditor;
    protected ArrayList<Object> objects = new ArrayList();
    protected String[] names = new String[0];
    protected ArrayList<Object> sortedObjects = new ArrayList();
    protected HashSet<String> forbiddenNames = new HashSet();
    protected boolean removablesAtTop = false;
    protected Collection<Object> circularErrors = new HashSet<Object>();
    protected Collection<Object> errors = new HashSet<Object>();
    protected List<Object> evaluate = new ArrayList<Object>();
    protected Table table;
    protected TableModel tableModel = new TableModel();
    protected CellEditor tableCellEditor = new CellEditor();
    protected CellRenderer tableCellRenderer = new CellRenderer();
    protected JScrollPane tableScroller;
    protected JButton newButton;
    protected JButton cutButton;
    protected JButton copyButton;
    protected JButton pasteButton;
    protected JPanel buttonPanel;
    protected FunctionPanel functionPanel;
    protected AbstractButton[] customButtons;

    static {
        decimalFormat.setMaximumFractionDigits(6);
        decimalFormat.setMinimumFractionDigits(1);
        decimalFormat.setMaximumIntegerDigits(3);
        decimalFormat.setMinimumIntegerDigits(1);
        sciFormat = new DecimalFormat("0.000000E0");
    }

    public FunctionEditor() {
        super(new BorderLayout());
        this.createGUI();
        this.refreshGUI();
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.table.getPreferredSize();
        dimension.height += this.table.getTableHeader().getHeight();
        dimension.height += this.buttonPanel.getPreferredSize().height;
        dimension.height = (int)((double)dimension.height + (1.25 * (double)this.table.getRowHeight() + 14.0));
        return dimension;
    }

    public void setObjects(List<Object> list) {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        this.objects.clear();
        this.objects.addAll(list);
        this.evaluateAll();
        this.tableModel.fireTableStructureChanged();
        if (n < this.table.getRowCount()) {
            this.table.rowToSelect = n;
            this.table.columnToSelect = n2;
        }
        this.table.requestFocusInWindow();
        this.refreshGUI();
    }

    public List<Object> getObjects() {
        return new ArrayList<Object>(this.objects);
    }

    public String[] getNames() {
        return this.names;
    }

    public String getName(Object object) {
        return null;
    }

    public String getExpression(Object object) {
        return null;
    }

    public String getTooltip(Object object) {
        return null;
    }

    public Object getObject(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        for (Object object : this.objects) {
            if (!string.equals(this.getName(object))) continue;
            return object;
        }
        return null;
    }

    public void setExpression(String string, String string2, boolean bl) {
        if (string == null || string.equals("")) {
            return;
        }
        int n = 0;
        while (n < this.objects.size()) {
            Object object = this.objects.get(n);
            if (string.equals(this.getName(object)) && !this.getExpression(object).equals(string2)) {
                String string3 = this.getExpression(object);
                object = this.createObject(string, string2, object);
                this.objects.remove(n);
                this.objects.add(n, object);
                this.evaluateAll();
                this.tableModel.fireTableStructureChanged();
                if (n >= 0) {
                    this.table.changeSelection(n, 1, false, false);
                }
                UndoableEdit undoableEdit = null;
                if (bl) {
                    undoableEdit = this.getUndoableEdit(3, string2, n, 1, string3, n, 1, this.getName(object));
                }
                this.firePropertyChange("edit", this.getName(object), undoableEdit);
            }
            ++n;
        }
    }

    public Object addObject(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        int n = this.objects.size();
        if (this.isRemovable(object)) {
            if (this.removablesAtTop) {
                n = this.getRemovableRowCount();
            }
        } else if (!this.removablesAtTop) {
            n -= this.getRemovableRowCount();
        }
        return this.addObject(object, n, bl, true);
    }

    public Object addObject(Object object, int n, boolean bl, boolean bl2) {
        if ((object = this.createUniqueObject(object, this.getName(object), true)) == null) {
            return null;
        }
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.getSelectedColumn();
        ArrayList<Object> arrayList = new ArrayList<Object>(this.objects);
        arrayList.add(n, object);
        this.setObjects(arrayList);
        this.table.columnToSelect = 0;
        this.table.rowToSelect = n;
        this.table.selectOnFocus = true;
        this.table.requestFocusInWindow();
        UndoableEdit undoableEdit = null;
        if (bl) {
            undoableEdit = this.getUndoableEdit(0, object, n, 0, object, n2, n3, this.getName(object));
        }
        if (bl2) {
            this.firePropertyChange("edit", this.getName(object), undoableEdit);
        }
        this.refreshGUI();
        return object;
    }

    public Object removeObject(Object object, boolean bl) {
        if (object == null || !this.isRemovable(object)) {
            return null;
        }
        int n = this.table.getSelectedColumn();
        int n2 = 0;
        while (n2 < this.objects.size()) {
            Object object2 = this.objects.get(n2);
            if (object2.equals(object)) {
                int n3;
                this.objects.remove(object);
                this.tableModel.fireTableStructureChanged();
                int n4 = n3 = n2 == this.objects.size() ? n2 - 1 : n2;
                if (n3 >= 0) {
                    this.table.changeSelection(n3, 0, false, false);
                }
                UndoableEdit undoableEdit = null;
                if (bl) {
                    undoableEdit = this.getUndoableEdit(1, object, n3, 0, object, n2, n, this.getName(object));
                }
                this.evaluateAll();
                this.firePropertyChange("edit", this.getName(object), undoableEdit);
                this.refreshGUI();
            }
            ++n2;
        }
        return object;
    }

    public void refreshStrings() {
        this.refreshGUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("focus") || string.equals("edit")) {
            this.table.clearSelection();
            this.table.rowToSelect = 0;
            this.table.columnToSelect = 0;
            this.table.selectOnFocus = false;
            this.refreshButtons();
        } else if (propertyChangeEvent.getPropertyName().equals("clipboard")) {
            this.refreshButtons();
        }
    }

    public void setCustomButtons(AbstractButton[] abstractButtonArray) {
        this.customButtons = abstractButtonArray;
        if (abstractButtonArray == null || abstractButtonArray.length == 0) {
            this.remove(this.buttonPanel);
            return;
        }
        this.buttonPanel.removeAll();
        int n = 0;
        while (n < abstractButtonArray.length) {
            this.buttonPanel.add(abstractButtonArray[n]);
            ++n;
        }
        this.add((Component)this.buttonPanel, "North");
    }

    protected UndoableEdit getUndoableEdit(int n, Object objectArray, int n2, int n3, Object objectArray2, int n4, int n5, String string) {
        if (n == 3) {
            ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
            objectArray2 = new Object[]{objectArray2, arrayList};
            objectArray = new Object[]{objectArray, arrayList};
            if (this.customButtons != null) {
                AbstractButton[] abstractButtonArray = this.customButtons;
                int n6 = this.customButtons.length;
                int n7 = 0;
                while (n7 < n6) {
                    AbstractButton abstractButton = abstractButtonArray[n7];
                    if (abstractButton.isSelected()) {
                        arrayList.add(abstractButton);
                    }
                    ++n7;
                }
            }
        }
        return new DefaultEdit(n, objectArray, n2, n3, objectArray2, n4, n5, string);
    }

    public boolean isNameEditable(Object object) {
        return true;
    }

    public boolean isExpressionEditable(Object object) {
        return true;
    }

    protected boolean isRemovable(Object object) {
        return !this.isImportant(object) && this.isNameEditable(object) && this.isExpressionEditable(object);
    }

    protected boolean isImportant(Object object) {
        return false;
    }

    public void evaluateAll() {
        String string;
        Iterator<Object> iterator;
        if (this.names.length != this.objects.size()) {
            this.names = new String[this.objects.size()];
        }
        int n = 0;
        while (n < this.names.length) {
            this.names[n] = this.getName(this.objects.get(n));
            ++n;
        }
        this.sortedObjects.clear();
        if (this.objects.size() > 0) {
            this.sortedObjects.add(this.objects.get(0));
            n = 1;
            while (n < this.objects.size()) {
                int n2 = this.sortedObjects.size();
                int n3 = 0;
                while (n3 < n2) {
                    iterator = this.objects.get(n);
                    string = this.getName(iterator);
                    if (string.length() > this.getName(this.sortedObjects.get(n3)).length()) {
                        this.sortedObjects.add(n3, iterator);
                        break;
                    }
                    if (n3 == n2 - 1) {
                        this.sortedObjects.add(iterator);
                    }
                    ++n3;
                }
                ++n;
            }
        }
        this.circularErrors.clear();
        for (Object object : this.objects) {
            String string2 = this.getName(object);
            if (!this.getReferences(string2, null).contains(string2)) continue;
            this.circularErrors.add(object);
        }
        this.errors.clear();
        block4: for (Object object : this.objects) {
            String string3 = this.getName(object);
            iterator = this.circularErrors.iterator();
            while (iterator.hasNext()) {
                string = this.getName(iterator.next());
                if (!this.getReferences(string3, null).contains(string)) continue;
                this.errors.add(object);
                continue block4;
            }
        }
        this.evaluate.clear();
        ArrayList<Object> arrayList = new ArrayList<Object>(this.objects);
        arrayList.removeAll(this.errors);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (!arrayList.isEmpty()) {
            int n4 = 0;
            while (n4 < arrayList.size()) {
                iterator = arrayList.get(n4);
                string = this.getName(iterator);
                Set<String> set = this.getReferences(string, null);
                if (arrayList2.containsAll(set)) {
                    this.evaluate.add(iterator);
                    arrayList2.add(string);
                }
                ++n4;
            }
            arrayList.removeAll(this.evaluate);
        }
    }

    protected Set<String> getReferences(String string, Set<String> set) {
        Object object;
        if (set == null) {
            set = new HashSet<String>();
        }
        if ((object = this.getObject(string)) != null) {
            String string2 = this.getExpression(object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object2 : this.sortedObjects) {
                if (object2 == object || string2.indexOf(string = this.getName(object2)) <= -1) continue;
                string2 = string2.replaceAll(string, "#");
                arrayList.add(object2);
                if (set.contains(string)) continue;
                set.add(string);
                set.addAll(this.getReferences(string, set));
            }
            this.setReferences(object, arrayList);
        }
        return set;
    }

    protected void setReferences(Object object, List<Object> list) {
    }

    protected void createGUI() {
        this.table = new Table(this.tableModel);
        this.tableScroller = new JScrollPane(this.table);
        this.tableScroller.createHorizontalScrollBar();
        this.add((Component)this.tableScroller, "Center");
        this.buttonPanel = new JPanel(new FlowLayout());
        this.newButton = new JButton();
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = FunctionEditor.this.getDefaultName();
                Object object = FunctionEditor.this.createUniqueObject(null, string, false);
                FunctionEditor.this.addObject(object, true);
            }
        });
        this.cutButton = new JButton();
        this.cutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = FunctionEditor.this.getSelectedObjects();
                FunctionEditor.this.copy(objectArray);
                int n = objectArray.length;
                while (n > 0) {
                    FunctionEditor.this.removeObject(objectArray[n - 1], true);
                    --n;
                }
                FunctionEditor.this.evaluateAll();
            }
        });
        this.copyButton = new JButton();
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionEditor.this.copy(FunctionEditor.this.getSelectedObjects());
            }
        });
        this.pasteButton = new JButton();
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionEditor.this.paste();
            }
        });
        this.buttonPanel.add(this.newButton);
        this.buttonPanel.add(this.copyButton);
        this.buttonPanel.add(this.cutButton);
        this.buttonPanel.add(this.pasteButton);
        this.add((Component)this.buttonPanel, "North");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                FunctionEditor.this.table.requestFocusInWindow();
                FunctionEditor.this.functionPanel.clearSelection();
            }
        };
        this.table.getTableHeader().addMouseListener(mouseAdapter);
        this.tableScroller.addMouseListener(mouseAdapter);
        this.buttonPanel.addMouseListener(mouseAdapter);
        this.buttonPanel.addMouseListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    protected void refreshGUI() {
        int[] nArray = this.table.getSelectedRows();
        int n = this.table.getSelectedColumn();
        this.tableModel.fireTableStructureChanged();
        this.revalidate();
        int n2 = 0;
        while (n2 < nArray.length) {
            this.table.addRowSelectionInterval(nArray[n2], nArray[n2]);
            ++n2;
        }
        if (nArray.length > 0) {
            this.table.setColumnSelectionInterval(n, n);
            this.table.requestFocusInWindow();
        }
        this.newButton.setText(ToolsRes.getString("FunctionEditor.Button.New"));
        this.newButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.New.Tooltip"));
        this.cutButton.setText(ToolsRes.getString("FunctionEditor.Button.Cut"));
        this.cutButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Cut.Tooltip"));
        this.copyButton.setText(ToolsRes.getString("FunctionEditor.Button.Copy"));
        this.copyButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Copy.Tooltip"));
        this.pasteButton.setText(ToolsRes.getString("FunctionEditor.Button.Paste"));
        this.pasteButton.setToolTipText(ToolsRes.getString("FunctionEditor.Button.Paste.Tooltip"));
        Border border = this.getBorder();
        if (border != null && border instanceof TitledBorder) {
            ((TitledBorder)border).setTitle(ToolsRes.getString("FunctionEditor.Border.Title"));
        } else {
            this.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("FunctionEditor.Border.Title")));
        }
        this.refreshButtons();
    }

    protected void refreshButtons() {
        boolean bl = this.getSelectedObject() != null;
        this.copyButton.setEnabled(bl);
        this.cutButton.setEnabled(bl && this.isRemovable(this.getSelectedObject()));
        this.pasteButton.setEnabled(this.getClipboardContents() != null);
    }

    protected ParamEditor getParamEditor() {
        return this.paramEditor;
    }

    protected void setParamEditor(ParamEditor paramEditor) {
        if (this.paramEditor == null && paramEditor != null) {
            this.paramEditor = paramEditor;
            this.evaluateAll();
            this.refreshGUI();
        }
    }

    protected String getDefaultName() {
        return ToolsRes.getString("FunctionEditor.New.Name.Default");
    }

    protected String getVariablesString() {
        StringBuffer stringBuffer = new StringBuffer(" ");
        int n = stringBuffer.length();
        boolean bl = true;
        String string = this.getName(this.getSelectedObject());
        int n2 = 0;
        while (n2 < this.names.length) {
            if (!this.names[n2].equals(string)) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.names[n2]);
                bl = false;
            }
            ++n2;
        }
        if (stringBuffer.length() == n) {
            return ToolsRes.getString("FunctionPanel.Instructions.Help");
        }
        return String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.ValueCell")) + ":" + stringBuffer.toString();
    }

    private int getRemovableRowCount() {
        int n = 0;
        for (Object object : this.objects) {
            if (!this.isRemovable(object)) continue;
            ++n;
        }
        return n;
    }

    protected int getPartlyEditableRowCount() {
        int n = 0;
        for (Object object : this.objects) {
            if (!this.isNameEditable(object) && !this.isExpressionEditable(object)) continue;
            ++n;
        }
        return n;
    }

    protected boolean isInvalidExpression(Object object) {
        return false;
    }

    protected boolean containsInvalidExpressions() {
        Iterator<Object> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            if (!this.isInvalidExpression(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private void copy(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            XMLControlElement xMLControlElement = new XMLControlElement(this);
            xMLControlElement.setValue("selected", objectArray);
            StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
            this.pasteButton.setEnabled(true);
            this.firePropertyChange("clipboard", null, null);
        }
    }

    protected void paste() {
        XMLControl[] xMLControlArray = this.getClipboardContents();
        if (xMLControlArray == null) {
            return;
        }
        int n = 0;
        while (n < xMLControlArray.length) {
            Object object = xMLControlArray[n].loadObject(null);
            this.addObject(object, true);
            ++n;
        }
        this.evaluateAll();
    }

    protected XMLControl[] getClipboardContents() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (string != null) {
                XMLControlElement xMLControlElement = new XMLControlElement();
                xMLControlElement.readXML(string);
                if (xMLControlElement.getObjectClass() == this.getClass()) {
                    List<Object> list = xMLControlElement.getPropertyContent();
                    int n = 0;
                    while (n < list.size()) {
                        XMLProperty xMLProperty;
                        Object object = list.get(n);
                        if (object instanceof XMLProperty && (xMLProperty = (XMLProperty)object).getPropertyName().equals("selected")) {
                            return xMLProperty.getChildControls();
                        }
                        ++n;
                    }
                    return null;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected Object getSelectedObject() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.objects.get(n);
    }

    protected Object[] getSelectedObjects() {
        int[] nArray = this.table.getSelectedRows();
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.objects.get(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    protected Object createObject(String string, String string2, Object object) {
        return null;
    }

    protected boolean isDisallowedName(Object object, String string) {
        if (this.forbiddenNames.contains(string)) {
            return true;
        }
        for (Object parameterArray : this.objects) {
            if (parameterArray == object || !string.equals(this.getName(parameterArray))) continue;
            return true;
        }
        if (this.paramEditor != null && this.paramEditor != this) {
            Parameter[] parameterArray = this.paramEditor.getParameters();
            int n = 0;
            while (n < parameterArray.length) {
                if (parameterArray[n] != object && string.equals(parameterArray[n].getName())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private String getValidName(String string) {
        if (string.trim().equals("")) {
            return "";
        }
        String string2 = string;
        ArrayList<String> arrayList = this.getInvalidTokens(string2);
        while (!arrayList.isEmpty()) {
            for (String string3 : arrayList) {
                int n = string2.indexOf(string3);
                while (n > -1) {
                    string2 = n == 0 ? string2.substring(string3.length()) : String.valueOf(string2.substring(0, n)) + string2.substring(n + string3.length());
                    n = string2.indexOf(string3);
                }
            }
            Object object = JOptionPane.showInputDialog(this, ToolsRes.getString("FunctionEditor.Dialog.InvalidName.Message"), ToolsRes.getString("FunctionEditor.Dialog.InvalidName.Title"), 2, null, null, string2);
            if (object == null) {
                return null;
            }
            if (object.equals(string2)) break;
            string2 = object.toString();
            arrayList = this.getInvalidTokens(string2);
        }
        return string2;
    }

    private ArrayList<String> getInvalidTokens(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{" ", "*", "+", "(", ")", "=", ">", "<", "&", "|", "!", "-", "/", "^"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.indexOf(stringArray[n]) > -1) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    protected Object createUniqueObject(Object object, String string, boolean bl) {
        if ((string = this.getValidName(string)).trim().equals("")) {
            return null;
        }
        String string2 = string;
        while (this.isDisallowedName(object, string)) {
            int n = 0;
            while (this.isDisallowedName(object, string2)) {
                string2 = String.valueOf(string) + ++n;
            }
            if (!bl) break;
            Object object2 = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("FunctionEditor.Dialog.DuplicateName.Message"), ToolsRes.getString("FunctionEditor.Dialog.DuplicateName.Title"), 2, null, null, string2);
            if (object2 == null) {
                return null;
            }
            if (object2.equals("") || object2.equals(string2)) break;
            string2 = string = object2.toString();
        }
        String string3 = object == null ? "0" : this.getExpression(object);
        return this.createObject(string2, string3, object);
    }

    public static String format(double d, double d2) {
        double d3;
        int n;
        if (Math.abs(d) < d2) {
            d = 0.0;
        }
        if (Math.abs(d - (double)(n = (int)Math.round(d))) < d2) {
            d = n;
        }
        boolean bl = (d3 = Math.abs(d)) < 0.1 && d != 0.0 || d3 >= 1000.0;
        String string = bl ? sciFormat.format(d) : decimalFormat.format(d);
        int n2 = string.indexOf("E");
        String string2 = n2 > -1 ? string.substring(n2) : "";
        string = n2 > -1 ? string.substring(0, n2) : string;
        if ((n2 = string.indexOf("0000")) > 1) {
            string = string.substring(0, n2 + 1);
        }
        if ((n2 = string.indexOf("9999")) > 1) {
            DecimalFormatSymbols decimalFormatSymbols;
            char c;
            int n3 = (string = string.substring(0, n2)).indexOf(c = (decimalFormatSymbols = sciFormat.getDecimalFormatSymbols()).getDecimalSeparator());
            if (n3 == string.length() - 1) {
                int n4 = Integer.parseInt(string.substring(0, n3)) + 1;
                string = String.valueOf(Integer.toString(n4)) + c + "0";
            } else {
                int n5 = Integer.parseInt(string.substring(n2 - 1)) + 1;
                string = String.valueOf(string.substring(0, n2 - 1)) + n5;
            }
        }
        return String.valueOf(string) + string2;
    }

    private class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        boolean keyPressed = false;
        boolean mouseClicked = false;

        CellEditor() {
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.panel.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 2));
            this.field.setBorder(null);
            this.field.setEditable(true);
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        CellEditor.this.keyPressed = true;
                        CellEditor.this.stopCellEditing();
                    } else {
                        CellEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    CellEditor.this.mouseClicked = false;
                    ((CellEditor)CellEditor.this).FunctionEditor.this.table.clearSelection();
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (!CellEditor.this.mouseClicked) {
                        CellEditor.this.stopCellEditing();
                    }
                    if (CellEditor.this.keyPressed) {
                        CellEditor.this.keyPressed = false;
                        ((CellEditor)CellEditor.this).FunctionEditor.this.table.requestFocusInWindow();
                    }
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            FunctionEditor.this.table.rowToSelect = n;
            FunctionEditor.this.table.columnToSelect = n2;
            this.field.setText(object.toString());
            FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, true, n2);
            FunctionEditor.this.functionPanel.tableEditorField = this.field;
            return this.panel;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                FunctionEditor.this.firePropertyChange("focus", null, null);
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                if (mouseEvent.getClickCount() == 2) {
                    this.mouseClicked = true;
                    Runnable runnable = new Runnable(){

                        public synchronized void run() {
                            CellEditor.this.field.selectAll();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    return true;
                }
            } else if (eventObject == null || eventObject instanceof ActionEvent) {
                return true;
            }
            return false;
        }

        public Object getCellEditorValue() {
            this.field.setBackground(Color.WHITE);
            return this.field.getText();
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        Font font = new JTextField().getFont();

        public CellRenderer() {
            this.setOpaque(true);
            this.setFont(this.font);
            this.setHorizontalAlignment(2);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            Object object2 = FunctionEditor.this.objects.get(n);
            String string = FunctionEditor.this.getTooltip(object2);
            this.setToolTipText(n2 == 0 && string != null ? string : (n2 == 0 ? ToolsRes.getString("FunctionEditor.Table.Cell.Name.Tooltip") : ToolsRes.getString("FunctionEditor.Table.Cell.Value.Tooltip")));
            if (n2 == 1 && FunctionEditor.this.circularErrors.contains(object2)) {
                this.setToolTipText(ToolsRes.getString("FunctionEditor.Table.Cell.CircularErrors.Tooltip"));
                if (bl) {
                    this.setForeground(bl2 ? Color.RED : Color.BLACK);
                    this.setBackground(LIGHT_MAGENTA);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setBackground(LIGHT_RED);
                }
            } else if (n2 == 1 && FunctionEditor.this.isInvalidExpression(object2)) {
                this.setToolTipText(ToolsRes.getString("FunctionEditor.Table.Cell.Invalid.Tooltip"));
                if (bl) {
                    this.setForeground(bl2 ? Color.RED : Color.BLACK);
                    this.setBackground(LIGHT_MAGENTA);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setBackground(LIGHT_RED);
                }
            } else if (n2 == 0 && !FunctionEditor.this.isNameEditable(object2) || n2 == 1 && !FunctionEditor.this.isExpressionEditable(object2)) {
                this.setForeground(Color.BLACK);
                this.setBackground(LIGHT_GRAY);
            } else if (bl) {
                this.setForeground(bl2 ? Color.RED : Color.BLACK);
                this.setBackground(LIGHT_BLUE);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
            this.setFont(n2 == 0 && FunctionEditor.this.isImportant(object2) ? this.font.deriveFont(1) : this.font);
            FunctionEditor.this.refreshButtons();
            return this;
        }
    }

    protected class DefaultEdit
    extends AbstractUndoableEdit {
        Object redoObj;
        Object undoObj;
        int redoRow;
        int redoCol;
        int undoRow;
        int undoCol;
        int editType;
        String name;

        public DefaultEdit(int n, Object object, int n2, int n3, Object object2, int n4, int n5, String string) {
            this.editType = n;
            this.redoObj = object;
            this.undoObj = object2;
            this.redoRow = n2;
            this.redoCol = n3;
            this.undoRow = n4;
            this.undoCol = n5;
            this.name = string;
            OSPLog.finer(String.valueOf(editTypes[n]) + ": \"" + string + "\"" + "\nold value: " + object2 + "\nnew value: " + object);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            switch (this.editType) {
                case 0: {
                    FunctionEditor.this.removeObject(this.undoObj, false);
                    break;
                }
                case 1: {
                    FunctionEditor.this.addObject(this.undoObj, this.undoRow, false, true);
                    break;
                }
                case 2: {
                    Object object = FunctionEditor.this.objects.get(this.undoRow);
                    String string = FunctionEditor.this.getExpression(object);
                    this.name = this.undoObj.toString();
                    String string2 = this.redoObj.toString();
                    object = FunctionEditor.this.createObject(this.name, string, object);
                    FunctionEditor.this.objects.remove(this.undoRow);
                    FunctionEditor.this.objects.add(this.undoRow, object);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange("edit", this.name, string2);
                    break;
                }
                case 3: {
                    Object object = FunctionEditor.this.objects.get(this.undoRow);
                    Object[] objectArray = (Object[])this.undoObj;
                    ArrayList arrayList = (ArrayList)objectArray[1];
                    for (Object e : arrayList) {
                        AbstractButton abstractButton = (AbstractButton)e;
                        if (abstractButton.isSelected()) continue;
                        abstractButton.doClick(0);
                    }
                    object = FunctionEditor.this.createObject(this.name, objectArray[0].toString(), object);
                    FunctionEditor.this.objects.remove(this.undoRow);
                    FunctionEditor.this.objects.add(this.undoRow, object);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange("edit", this.name, null);
                }
            }
            FunctionEditor.this.table.rowToSelect = this.undoRow;
            FunctionEditor.this.table.columnToSelect = this.undoCol;
            FunctionEditor.this.getTable().selectOnFocus = true;
            FunctionEditor.this.getTable().requestFocusInWindow();
            FunctionEditor.this.refreshGUI();
        }

        public void redo() throws CannotUndoException {
            super.redo();
            switch (this.editType) {
                case 0: {
                    FunctionEditor.this.addObject(this.redoObj, this.redoRow, false, true);
                    break;
                }
                case 1: {
                    FunctionEditor.this.removeObject(this.redoObj, false);
                    break;
                }
                case 2: {
                    Object object = FunctionEditor.this.objects.get(this.redoRow);
                    String string = FunctionEditor.this.getExpression(object);
                    this.name = this.redoObj.toString();
                    String string2 = this.undoObj.toString();
                    object = FunctionEditor.this.createObject(this.name, string, object);
                    FunctionEditor.this.objects.remove(this.redoRow);
                    FunctionEditor.this.objects.add(this.redoRow, object);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange("edit", this.name, string2);
                    break;
                }
                case 3: {
                    Object object = FunctionEditor.this.objects.get(this.redoRow);
                    Object[] objectArray = (Object[])this.redoObj;
                    ArrayList arrayList = (ArrayList)objectArray[1];
                    for (Object e : arrayList) {
                        AbstractButton abstractButton = (AbstractButton)e;
                        if (abstractButton.isSelected()) continue;
                        abstractButton.doClick(0);
                    }
                    object = FunctionEditor.this.createObject(this.name, objectArray[0].toString(), object);
                    FunctionEditor.this.objects.remove(this.redoRow);
                    FunctionEditor.this.objects.add(this.redoRow, object);
                    FunctionEditor.this.evaluateAll();
                    FunctionEditor.this.firePropertyChange("edit", this.name, null);
                }
            }
            FunctionEditor.this.table.rowToSelect = this.redoRow;
            FunctionEditor.this.table.columnToSelect = this.redoCol;
            FunctionEditor.this.getTable().selectOnFocus = true;
            FunctionEditor.this.getTable().requestFocusInWindow();
            FunctionEditor.this.refreshGUI();
        }

        public String getPresentationName() {
            if (this.editType == 1) {
                return "Deletion";
            }
            return "Edit";
        }
    }

    public class Table
    extends JTable {
        public boolean selectOnFocus = true;
        int rowToSelect;
        int columnToSelect;

        Table(TableModel tableModel) {
            this.setModel(tableModel);
            this.setSelectionMode(2);
            this.setColumnSelectionAllowed(false);
            this.getTableHeader().setReorderingAllowed(false);
            this.setGridColor(Color.BLACK);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = Table.this.rowAtPoint(mouseEvent.getPoint());
                    int n2 = Table.this.columnAtPoint(mouseEvent.getPoint());
                    ((Table)Table.this).FunctionEditor.this.table.rowToSelect = n;
                    ((Table)Table.this).FunctionEditor.this.table.columnToSelect = n2;
                    if (!((Table)Table.this).FunctionEditor.this.tableModel.isCellEditable(n, n2)) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.clearSelection();
                        Table.this.selectOnFocus = false;
                    } else if (mouseEvent.getClickCount() == 1) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, n2);
                        Table.this.selectOnFocus = ((Table)Table.this).FunctionEditor.this.table.hasFocus();
                    }
                }
            });
            this.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Table.this.firePropertyChange("focus", null, null);
                    if (Table.this.getRowCount() == 0) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.tabToNext(FunctionEditor.this);
                        return;
                    }
                    if (Table.this.selectOnFocus && Table.this.getRowCount() > 0) {
                        Table.this.selectCell(Table.this.rowToSelect, Table.this.columnToSelect);
                        int n = ((Table)Table.this).FunctionEditor.this.table.getSelectedColumn();
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, n);
                    }
                    Table.this.selectOnFocus = true;
                }

                public void focusLost(FocusEvent focusEvent) {
                    Table.this.rowToSelect = Math.max(0, Table.this.getSelectedRow());
                    Table.this.columnToSelect = Math.max(0, Table.this.getSelectedColumn());
                }
            });
            InputMap inputMap = this.getInputMap(1);
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    jTable.editCellAt(n, n2, actionEvent);
                    ((Table)Table.this).FunctionEditor.this.tableCellEditor.field.requestFocus();
                    ((Table)Table.this).FunctionEditor.this.tableCellEditor.field.selectAll();
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 0);
            AbstractAction abstractAction2 = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ((Table)Table.this).FunctionEditor.this.table.getRowCount();
                    int n2 = ((Table)Table.this).FunctionEditor.this.table.rowToSelect;
                    int n3 = ((Table)Table.this).FunctionEditor.this.table.columnToSelect;
                    boolean bl = n3 == 1 && n2 == n - 1;
                    int n4 = n3 = n3 == 0 ? 1 : 0;
                    int n5 = n3 == 0 ? (n2 == Table.this.getRowCount() - 1 ? 0 : n2 + 1) : (n2 = n2);
                    if (((Table)Table.this).FunctionEditor.this.table.isEditing()) {
                        ((Table)Table.this).FunctionEditor.this.table.rowToSelect = n2;
                        ((Table)Table.this).FunctionEditor.this.table.columnToSelect = n3;
                        ((Table)Table.this).FunctionEditor.this.tableCellEditor.stopCellEditing();
                    }
                    if (bl) {
                        ((Table)Table.this).FunctionEditor.this.functionPanel.tabToNext(FunctionEditor.this);
                        ((Table)Table.this).FunctionEditor.this.table.clearSelection();
                    } else {
                        ((Table)Table.this).FunctionEditor.this.table.requestFocusInWindow();
                        Table.this.selectCell(n2, n3);
                        ((Table)Table.this).FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, n3);
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
        }

        /*
         * Unable to fully structure code
         */
        public void selectCell(int var1_1, int var2_2) {
            if (var1_1 == this.getRowCount()) {
                var1_1 = this.getRowCount() - 1;
                var2_2 = 0;
            }
            if (var1_1 != -1) ** GOTO lbl14
            return;
lbl-1000:
            // 1 sources

            {
                if (var2_2 == 0) {
                    var2_2 = 1;
                } else {
                    var2_2 = 0;
                    ++var1_1;
                }
                if (var1_1 == this.getRowCount()) {
                    var1_1 = 0;
                }
                if (var1_1 == this.getSelectedRow() && var2_2 == this.getSelectedColumn()) break;
lbl14:
                // 2 sources

                ** while (!this.isCellEditable((int)var1_1, (int)var2_2))
            }
lbl15:
            // 2 sources

            FunctionEditor.this.table.rowToSelect = var1_1;
            FunctionEditor.this.table.columnToSelect = var2_2;
            FunctionEditor.this.table.changeSelection(var1_1, var2_2, false, false);
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            return FunctionEditor.this.tableCellEditor;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return FunctionEditor.this.tableCellRenderer;
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.getTableHeader().setFont(font);
            FunctionEditor.this.tableCellRenderer.font = font;
            FunctionEditor.this.tableCellEditor.field.setFont(font);
            this.setRowHeight(font.getSize() + 4);
        }
    }

    protected class TableModel
    extends AbstractTableModel {
        boolean settingValue = false;

        protected TableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return FunctionEditor.this.objects.size();
        }

        public String getColumnName(int n) {
            return n == 0 ? ToolsRes.getString("FunctionEditor.Table.Column.Name") : ToolsRes.getString("FunctionEditor.Table.Column.Value");
        }

        public Object getValueAt(int n, int n2) {
            Object object = FunctionEditor.this.objects.get(n);
            return n2 == 0 ? FunctionEditor.this.getName(object) : FunctionEditor.this.getExpression(object);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (this.settingValue) {
                return;
            }
            if (object instanceof String) {
                String string = (String)object;
                String string2 = null;
                int n3 = 0;
                Object object2 = FunctionEditor.this.objects.get(n);
                if (n2 == 0) {
                    string2 = FunctionEditor.this.getName(object2);
                    n3 = 2;
                    this.settingValue = true;
                    if (!string.equals(string2)) {
                        object2 = FunctionEditor.this.createUniqueObject(object2, string, true);
                    }
                    this.settingValue = false;
                    if (object2 == null || string.equals(string2)) {
                        FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, 0);
                        return;
                    }
                    FunctionEditor.this.objects.remove(n);
                    FunctionEditor.this.objects.add(n, object2);
                } else {
                    string2 = FunctionEditor.this.getExpression(object2);
                    n3 = 3;
                    if (string.equals(string2)) {
                        FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, 1);
                        return;
                    }
                    if (string.equals("")) {
                        string = "0";
                    }
                    object2 = FunctionEditor.this.createObject(FunctionEditor.this.getName(object2), string, object2);
                    FunctionEditor.this.objects.remove(n);
                    FunctionEditor.this.objects.add(n, object2);
                }
                FunctionEditor.this.evaluateAll();
                FunctionEditor.this.table.repaint();
                UndoableEdit undoableEdit = FunctionEditor.this.getUndoableEdit(n3, string, n, n2, string2, n, n2, FunctionEditor.this.getName(object2));
                FunctionEditor.this.firePropertyChange("edit", FunctionEditor.this.getName(object2), undoableEdit);
                FunctionEditor.this.functionPanel.refreshInstructions(FunctionEditor.this, false, n2);
            }
        }

        public boolean isCellEditable(int n, int n2) {
            Object object = FunctionEditor.this.objects.get(n);
            return n2 == 0 && FunctionEditor.this.isNameEditable(object) || n2 == 1 && FunctionEditor.this.isExpressionEditable(object);
        }
    }
}

