/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Comparator;
import java.util.Random;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayLib {
    public static final int SORT_THRESHOLD = 30;

    public static final void shuffle(int[] nArray, Random random) {
        ArrayLib.shuffle(nArray, 0, nArray.length, random);
    }

    public static final void shuffle(int[] nArray, int n, int n2, Random random) {
        int n3 = n + n2;
        while (--n3 > 0) {
            int n4 = nArray[n3];
            int n5 = random.nextInt(n3);
            nArray[n3] = nArray[n5];
            nArray[n5] = n4;
        }
    }

    public static final void shuffle(long[] lArray, Random random) {
        ArrayLib.shuffle(lArray, 0, lArray.length, random);
    }

    public static final void shuffle(long[] lArray, int n, int n2, Random random) {
        int n3 = n + n2;
        while (n3 > 1) {
            long l = lArray[n3];
            int n4 = random.nextInt(n3);
            lArray[n3] = lArray[n4];
            lArray[n4] = l;
            --n3;
        }
    }

    public static final void shuffle(float[] fArray, Random random) {
        ArrayLib.shuffle(fArray, 0, fArray.length, random);
    }

    public static final void shuffle(float[] fArray, int n, int n2, Random random) {
        int n3 = n + n2;
        while (n3 > 1) {
            float f = fArray[n3];
            int n4 = random.nextInt(n3);
            fArray[n3] = fArray[n4];
            fArray[n4] = f;
            --n3;
        }
    }

    public static final void shuffle(double[] dArray, Random random) {
        ArrayLib.shuffle(dArray, 0, dArray.length, random);
    }

    public static final void shuffle(double[] dArray, int n, int n2, Random random) {
        int n3 = n + n2;
        while (n3 > 1) {
            double d = dArray[n3];
            int n4 = random.nextInt(n3);
            dArray[n3] = dArray[n4];
            dArray[n4] = d;
            --n3;
        }
    }

    public static final void shuffle(Object[] objectArray, Random random) {
        ArrayLib.shuffle(objectArray, 0, objectArray.length, random);
    }

    public static final void shuffle(Object[] objectArray, int n, int n2, Random random) {
        int n3 = n + n2;
        while (n3 > 1) {
            Object object = objectArray[n3];
            int n4 = random.nextInt(n3);
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object;
            --n3;
        }
    }

    public static final double max(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] > d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static final double min(double[] dArray) {
        double d = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] < d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static final double sum(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public static final int binarySearch(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n3 / 2;
        while (n2 < n3) {
            if (nArray[n4] == n) {
                return n4;
            }
            if (nArray[n4] < n) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * (n4 + 1);
    }

    public static final int binarySearch(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = n4 / 2;
        while (n3 < n4) {
            if (nArray[n5] == n) {
                return n5;
            }
            if (nArray[n5] < n) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = n4 + (n5 - n4) / 2;
        while (n4 < n5) {
            if (nArray[n6] == n) {
                return n6;
            }
            if (nArray[n6] < n) {
                n4 = n6 + 1;
            } else {
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
        }
        return -1 * (n6 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.length;
        int n3 = n2 / 2;
        while (n < n2) {
            int n4 = ((Comparable)objectArray[n3]).compareTo(object);
            if (n4 == 0) {
                return n3;
            }
            if (n4 < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1 * (n3 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = n3 / 2;
        while (n2 < n3) {
            int n5 = ((Comparable)objectArray[n4]).compareTo(object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * (n4 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = n3 + (n4 - n3) / 2;
        while (n3 < n4) {
            int n6 = ((Comparable)objectArray[n5]).compareTo(object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator<Object> comparator) {
        int n = 0;
        int n2 = objectArray.length;
        int n3 = n2 / 2;
        while (n < n2) {
            int n4 = comparator.compare(objectArray[n3], object);
            if (n4 == 0) {
                return n3;
            }
            if (n4 < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1 * (n3 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator<Object> comparator, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = n3 / 2;
        while (n2 < n3) {
            int n5 = comparator.compare(objectArray[n4], object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * (n4 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator<Object> comparator, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = n3 + (n4 - n3) / 2;
        while (n3 < n4) {
            int n6 = comparator.compare(objectArray[n5], object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int find(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static final int find(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static final int find(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            if (nArray[n4] == n) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public static final int[] resize(int[] nArray, int n) {
        if (nArray.length >= n) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final float[] resize(float[] fArray, int n) {
        if (fArray.length >= n) {
            return fArray;
        }
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public static final double[] resize(double[] dArray, int n) {
        if (dArray.length >= n) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static final Object[] resize(Object[] objectArray, int n) {
        if (objectArray.length >= n) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static final int[] trim(int[] nArray, int n) {
        if (nArray.length == n) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static final float[] trim(float[] fArray, int n) {
        if (fArray.length == n) {
            return fArray;
        }
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, n);
        return fArray2;
    }

    public static final double[] trim(double[] dArray, int n) {
        if (dArray.length == n) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    public static final Object[] trim(Object[] objectArray, int n) {
        if (objectArray.length == n) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public static final void sort(int[] nArray, double[] dArray) {
        ArrayLib.mergesort(nArray, dArray, 0, nArray.length - 1);
    }

    public static final void sort(int[] nArray, double[] dArray, int n) {
        ArrayLib.mergesort(nArray, dArray, 0, n - 1);
    }

    public static final void sort(int[] nArray, double[] dArray, int n, int n2) {
        ArrayLib.mergesort(nArray, dArray, n, n2 - 1);
    }

    protected static final void insertionsort(int[] nArray, double[] dArray, int n, int n2) {
        int n3 = n + 1;
        while (n3 <= n2) {
            int n4 = nArray[n3];
            double d = dArray[n3];
            int n5 = n3 - 1;
            while (n5 >= n && nArray[n5] > n4) {
                nArray[n5 + 1] = nArray[n5];
                dArray[n5 + 1] = dArray[n5];
                --n5;
            }
            nArray[n5 + 1] = n4;
            dArray[n5 + 1] = d;
            ++n3;
        }
    }

    protected static final void mergesort(int[] nArray, double[] dArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n2 - n + 1 < 30) {
            ArrayLib.insertionsort(nArray, dArray, n, n2);
        } else {
            int n3 = (n + n2) / 2;
            ArrayLib.mergesort(nArray, dArray, n, n3);
            ArrayLib.mergesort(nArray, dArray, n3 + 1, n2);
            ArrayLib.merge(nArray, dArray, n, n3, n2);
        }
    }

    protected static final void merge(int[] nArray, double[] dArray, int n, int n2, int n3) {
        int[] nArray2 = new int[n3 - n + 1];
        double[] dArray2 = new double[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (nArray[n4] < nArray[n5]) {
                dArray2[n6] = dArray[n4];
                nArray2[n6] = nArray[n4++];
            } else {
                dArray2[n6] = dArray[n5];
                nArray2[n6] = nArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            dArray2[n6] = dArray[n4];
            nArray2[n6] = nArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            dArray2[n6] = dArray[n5];
            nArray2[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < nArray2.length) {
            dArray[n4] = dArray2[n6];
            nArray[n4] = nArray2[n6];
            ++n6;
            ++n4;
        }
    }

    public static final void sort(int[] nArray, int[] nArray2) {
        ArrayLib.mergesort(nArray, nArray2, 0, nArray.length - 1);
    }

    public static final void sort(int[] nArray, int[] nArray2, int n) {
        ArrayLib.mergesort(nArray, nArray2, 0, n - 1);
    }

    public static final void sort(int[] nArray, int[] nArray2, int n, int n2) {
        ArrayLib.mergesort(nArray, nArray2, n, n2 - 1);
    }

    protected static final void insertionsort(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n + 1;
        while (n3 <= n2) {
            int n4 = nArray[n3];
            int n5 = nArray2[n3];
            int n6 = n3 - 1;
            while (n6 >= n && nArray[n6] > n4) {
                nArray[n6 + 1] = nArray[n6];
                nArray2[n6 + 1] = nArray2[n6];
                --n6;
            }
            nArray[n6 + 1] = n4;
            nArray2[n6 + 1] = n5;
            ++n3;
        }
    }

    protected static final void mergesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n2 - n + 1 < 30) {
            ArrayLib.insertionsort(nArray, nArray2, n, n2);
        } else {
            int n3 = (n + n2) / 2;
            ArrayLib.mergesort(nArray, nArray2, n, n3);
            ArrayLib.mergesort(nArray, nArray2, n3 + 1, n2);
            ArrayLib.merge(nArray, nArray2, n, n3, n2);
        }
    }

    protected static final void merge(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int[] nArray3 = new int[n3 - n + 1];
        int[] nArray4 = new int[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (nArray[n4] < nArray[n5]) {
                nArray4[n6] = nArray2[n4];
                nArray3[n6] = nArray[n4++];
            } else {
                nArray4[n6] = nArray2[n5];
                nArray3[n6] = nArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            nArray4[n6] = nArray2[n4];
            nArray3[n6] = nArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            nArray4[n6] = nArray2[n5];
            nArray3[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < nArray3.length) {
            nArray2[n4] = nArray4[n6];
            nArray[n4] = nArray3[n6];
            ++n6;
            ++n4;
        }
    }

    public static final void sort(int[] nArray, Object[] objectArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 30) {
            ArrayLib.insertionsort(nArray, objectArray, n, n2 - 1);
            return;
        }
        int[] nArray2 = new int[n3];
        Object[] objectArray2 = new Object[n3];
        int n4 = 0;
        int n5 = n;
        while (n4 < n3) {
            nArray2[n4] = nArray[n5];
            objectArray2[n4] = objectArray[n5];
            ++n4;
            ++n5;
        }
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n, n2, -n);
    }

    public static final void sort(int[] nArray, Object[] objectArray, int[] nArray2, Object[] objectArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 30) {
            ArrayLib.insertionsort(nArray, objectArray, n, n2 - 1);
            return;
        }
        int n4 = 0;
        int n5 = n;
        while (n4 < n3) {
            nArray2[n4] = nArray[n5];
            objectArray2[n4] = objectArray[n5];
            ++n4;
            ++n5;
        }
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n, n2, -n);
    }

    protected static final void insertionsort(int[] nArray, Object[] objectArray, int n, int n2) {
        int n3 = n + 1;
        while (n3 <= n2) {
            int n4 = nArray[n3];
            Object object = objectArray[n3];
            int n5 = n3 - 1;
            while (n5 >= n && nArray[n5] > n4) {
                nArray[n5 + 1] = nArray[n5];
                objectArray[n5 + 1] = objectArray[n5];
                --n5;
            }
            nArray[n5 + 1] = n4;
            objectArray[n5 + 1] = object;
            ++n3;
        }
    }

    protected static void mergesort(int[] nArray, int[] nArray2, Object[] objectArray, Object[] objectArray2, int n, int n2, int n3) {
        int n4 = n2 - n;
        if (n4 < 30) {
            ArrayLib.insertionsort(nArray2, objectArray2, n, n2 - 1);
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = (n += n3) + (n2 += n3) >> 1;
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n, n7, -n3);
        ArrayLib.mergesort(nArray2, nArray, objectArray2, objectArray, n7, n2, -n3);
        if (nArray[n7 - 1] <= nArray[n7]) {
            System.arraycopy(nArray, n, nArray2, n5, n4);
            System.arraycopy(objectArray, n, objectArray2, n5, n4);
            return;
        }
        int n8 = n5;
        int n9 = n;
        int n10 = n7;
        while (n8 < n6) {
            if (n10 >= n2 || n9 < n7 && nArray[n9] <= nArray[n10]) {
                objectArray2[n8] = objectArray[n9];
                nArray2[n8] = nArray[n9++];
            } else {
                objectArray2[n8] = objectArray[n10];
                nArray2[n8] = nArray[n10++];
            }
            ++n8;
        }
    }

    protected static final void merge(int[] nArray, Object[] objectArray, int n, int n2, int n3) {
        int[] nArray2 = new int[n3 - n + 1];
        Object[] objectArray2 = new Object[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (nArray[n4] < nArray[n5]) {
                objectArray2[n6] = objectArray[n4];
                nArray2[n6] = nArray[n4++];
            } else {
                objectArray2[n6] = objectArray[n5];
                nArray2[n6] = nArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            objectArray2[n6] = objectArray[n4];
            nArray2[n6] = nArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            objectArray2[n6] = objectArray[n5];
            nArray2[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < nArray2.length) {
            objectArray[n4] = objectArray2[n6];
            nArray[n4] = nArray2[n6];
            ++n6;
            ++n4;
        }
    }

    public static final void sort(double[] dArray, int[] nArray) {
        ArrayLib.mergesort(dArray, nArray, 0, dArray.length - 1);
    }

    public static final void sort(double[] dArray, int[] nArray, int n) {
        ArrayLib.mergesort(dArray, nArray, 0, n - 1);
    }

    public static final void sort(double[] dArray, int[] nArray, int n, int n2) {
        ArrayLib.mergesort(dArray, nArray, n, n2 - 1);
    }

    protected static final void insertionsort(double[] dArray, int[] nArray, int n, int n2) {
        int n3 = n + 1;
        while (n3 <= n2) {
            double d = dArray[n3];
            int n4 = nArray[n3];
            int n5 = n3 - 1;
            while (n5 >= n && dArray[n5] > d) {
                dArray[n5 + 1] = dArray[n5];
                nArray[n5 + 1] = nArray[n5];
                --n5;
            }
            dArray[n5 + 1] = d;
            nArray[n5 + 1] = n4;
            ++n3;
        }
    }

    protected static final void mergesort(double[] dArray, int[] nArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n2 - n + 1 < 30) {
            ArrayLib.insertionsort(dArray, nArray, n, n2);
        } else {
            int n3 = (n + n2) / 2;
            ArrayLib.mergesort(dArray, nArray, n, n3);
            ArrayLib.mergesort(dArray, nArray, n3 + 1, n2);
            ArrayLib.merge(dArray, nArray, n, n3, n2);
        }
    }

    protected static final void merge(double[] dArray, int[] nArray, int n, int n2, int n3) {
        double[] dArray2 = new double[n3 - n + 1];
        int[] nArray2 = new int[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (dArray[n4] < dArray[n5]) {
                nArray2[n6] = nArray[n4];
                dArray2[n6] = dArray[n4++];
            } else {
                nArray2[n6] = nArray[n5];
                dArray2[n6] = dArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            nArray2[n6] = nArray[n4];
            dArray2[n6] = dArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            nArray2[n6] = nArray[n5];
            dArray2[n6] = dArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < dArray2.length) {
            nArray[n4] = nArray2[n6];
            dArray[n4] = dArray2[n6];
            ++n6;
            ++n4;
        }
    }

    public static final void sort(float[] fArray, int[] nArray) {
        ArrayLib.mergesort(fArray, nArray, 0, fArray.length - 1);
    }

    public static final void sort(float[] fArray, int[] nArray, int n) {
        ArrayLib.mergesort(fArray, nArray, 0, n - 1);
    }

    public static final void sort(float[] fArray, int[] nArray, int n, int n2) {
        ArrayLib.mergesort(fArray, nArray, n, n2 - 1);
    }

    protected static final void insertionsort(float[] fArray, int[] nArray, int n, int n2) {
        int n3 = n + 1;
        while (n3 <= n2) {
            float f = fArray[n3];
            int n4 = nArray[n3];
            int n5 = n3 - 1;
            while (n5 >= n && fArray[n5] > f) {
                fArray[n5 + 1] = fArray[n5];
                nArray[n5 + 1] = nArray[n5];
                --n5;
            }
            fArray[n5 + 1] = f;
            nArray[n5 + 1] = n4;
            ++n3;
        }
    }

    protected static final void mergesort(float[] fArray, int[] nArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n2 - n + 1 < 30) {
            ArrayLib.insertionsort(fArray, nArray, n, n2);
        } else {
            int n3 = (n + n2) / 2;
            ArrayLib.mergesort(fArray, nArray, n, n3);
            ArrayLib.mergesort(fArray, nArray, n3 + 1, n2);
            ArrayLib.merge(fArray, nArray, n, n3, n2);
        }
    }

    protected static final void merge(float[] fArray, int[] nArray, int n, int n2, int n3) {
        float[] fArray2 = new float[n3 - n + 1];
        int[] nArray2 = new int[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (fArray[n4] < fArray[n5]) {
                nArray2[n6] = nArray[n4];
                fArray2[n6] = fArray[n4++];
            } else {
                nArray2[n6] = nArray[n5];
                fArray2[n6] = fArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            nArray2[n6] = nArray[n4];
            fArray2[n6] = fArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            nArray2[n6] = nArray[n5];
            fArray2[n6] = fArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < fArray2.length) {
            nArray[n4] = nArray2[n6];
            fArray[n4] = fArray2[n6];
            ++n6;
            ++n4;
        }
    }

    public static final void sort(Object[] objectArray, int[] nArray, Comparator<Object> comparator) {
        ArrayLib.mergesort(objectArray, nArray, 0, objectArray.length - 1, comparator);
    }

    public static final void sort(Object[] objectArray, int[] nArray, int n, Comparator<Object> comparator) {
        ArrayLib.mergesort(objectArray, nArray, 0, n - 1, comparator);
    }

    public static final void sort(Object[] objectArray, int[] nArray, int n, int n2, Comparator<Object> comparator) {
        ArrayLib.mergesort(objectArray, nArray, n, n2 - 1, comparator);
    }

    protected static final void insertionsort(Object[] objectArray, int[] nArray, int n, int n2, Comparator<Object> comparator) {
        int n3 = n + 1;
        while (n3 <= n2) {
            Object object = objectArray[n3];
            int n4 = nArray[n3];
            int n5 = n3 - 1;
            while (n5 >= n && comparator.compare(objectArray[n5], object) > 0) {
                objectArray[n5 + 1] = objectArray[n5];
                nArray[n5 + 1] = nArray[n5];
                --n5;
            }
            objectArray[n5 + 1] = object;
            nArray[n5 + 1] = n4;
            ++n3;
        }
    }

    protected static final void mergesort(Object[] objectArray, int[] nArray, int n, int n2, Comparator<Object> comparator) {
        if (n >= n2) {
            return;
        }
        if (n2 - n + 1 < 30) {
            ArrayLib.insertionsort(objectArray, nArray, n, n2, comparator);
        } else {
            int n3 = (n + n2) / 2;
            ArrayLib.mergesort(objectArray, nArray, n, n3, comparator);
            ArrayLib.mergesort(objectArray, nArray, n3 + 1, n2, comparator);
            ArrayLib.merge(objectArray, nArray, n, n3, n2, comparator);
        }
    }

    protected static final void merge(Object[] objectArray, int[] nArray, int n, int n2, int n3, Comparator<Object> comparator) {
        Object[] objectArray2 = new Object[n3 - n + 1];
        int[] nArray2 = new int[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (comparator.compare(objectArray[n4], objectArray[n5]) < 0) {
                nArray2[n6] = nArray[n4];
                objectArray2[n6] = objectArray[n4++];
            } else {
                nArray2[n6] = nArray[n5];
                objectArray2[n6] = objectArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            nArray2[n6] = nArray[n4];
            objectArray2[n6] = objectArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            nArray2[n6] = nArray[n5];
            objectArray2[n6] = objectArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < objectArray2.length) {
            nArray[n4] = nArray2[n6];
            objectArray[n4] = objectArray2[n6];
            ++n6;
            ++n4;
        }
    }

    public static int[] getIntArray(String string) {
        int[] nArray = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            nArray = new int[n];
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("#")) continue;
                nArray[n2++] = Integer.parseInt(string3);
            }
            if (n2 != n) {
                nArray = ArrayLib.trim(nArray, n2);
            }
            return nArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

