/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoClipControl;
import org.opensourcephysics.media.core.VideoPanel;

public class VideoPlayer
extends JComponent
implements PropertyChangeListener {
    protected VideoPanel vidPanel;
    protected ClipControl clipControl;
    private String[] readoutTypes;
    private String readoutType;
    private boolean inspectorButtonVisible = false;
    protected int height = 54;
    private JToolBar toolbar;
    private JButton playButton;
    private JButton stepButton;
    private JButton backButton;
    private JButton loopButton;
    private JButton inspectorButton;
    private JSlider slider;
    JLabel readout;
    private Icon playIcon;
    private Icon grayPlayIcon;
    private Icon pauseIcon;
    private Icon resetIcon;
    private Icon loopIcon;
    private Icon noloopIcon;
    private NumberFormat timeFormat = NumberFormat.getNumberInstance();

    public VideoPlayer(VideoPanel videoPanel, VideoClip videoClip) {
        this(videoPanel);
        this.setVideoClip(videoClip);
    }

    public VideoPlayer(VideoPanel videoPanel) {
        this.vidPanel = videoPanel;
        this.vidPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (VideoPlayer.this.vidPanel.isPlayerVisible()) {
                    VideoPlayer.this.setBounds();
                    VideoPlayer.this.vidPanel.repaint();
                }
            }
        });
        this.createGUI();
        this.timeFormat.setMinimumIntegerDigits(1);
        this.timeFormat.setMaximumFractionDigits(3);
        this.timeFormat.setMinimumFractionDigits(3);
        this.clipControl = ClipControl.getControl(new VideoClip(null));
        this.clipControl.addPropertyChangeListener(this);
        this.getVideoClip().addPropertyChangeListener(this);
        this.updatePlayButton(false);
        this.slider.setMaximum(this.getVideoClip().getStepCount() - 1);
        this.setReadoutTypes("frame time step");
        this.refresh();
    }

    public void setVideoClip(VideoClip videoClip) {
        boolean bl = this.clipControl.isPlaying();
        this.stop();
        if (this.getVideoClip() == videoClip) {
            ClipInspector clipInspector;
            boolean bl2 = this.clipControl.isLooping();
            double d = this.clipControl.getRate();
            double d2 = this.clipControl.getMeanFrameDuration();
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(videoClip);
            this.clipControl.addPropertyChangeListener(this);
            this.clipControl.setLooping(bl2);
            this.clipControl.setRate(d);
            this.clipControl.setFrameDuration(d2);
            if (bl) {
                this.clipControl.play();
            }
            if ((clipInspector = this.getVideoClip().inspector) != null) {
                clipInspector.clipControl = this.clipControl;
            }
        } else {
            VideoClip videoClip2 = this.getVideoClip();
            videoClip2.removePropertyChangeListener(this);
            videoClip2.hideClipInspector();
            Video video = videoClip2.getVideo();
            if (video != null) {
                video.dispose();
            }
            videoClip2.video = null;
            if (videoClip == null) {
                videoClip = new VideoClip(null);
            }
            videoClip.addPropertyChangeListener(this);
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(videoClip);
            this.clipControl.addPropertyChangeListener(this);
            this.setReadoutTypes("frame time step");
            this.updatePlayButton(this.clipControl.isPlaying());
            this.updateLoopButton(this.clipControl.isLooping());
            this.slider.setMaximum(videoClip.getStepCount() - 1);
            this.updateReadout();
            this.firePropertyChange("videoclip", videoClip2, videoClip);
            System.gc();
        }
    }

    public VideoClip getVideoClip() {
        return this.clipControl.getVideoClip();
    }

    public ClipControl getClipControl() {
        return this.clipControl;
    }

    public void setReadoutTypes(String string) {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        String string2 = string.toLowerCase();
        int n = string2.indexOf("time");
        if (n >= 0) {
            treeMap.put(new Integer(n), "time");
        }
        if ((n = string2.indexOf("step")) >= 0) {
            treeMap.put(new Integer(n), "step");
        }
        if ((n = string2.indexOf("frame")) >= 0) {
            treeMap.put(new Integer(n), "frame");
        }
        if (treeMap.isEmpty()) {
            return;
        }
        this.readoutTypes = treeMap.values().toArray(new String[0]);
        this.setReadoutType(this.readoutTypes[0]);
    }

    public void setReadoutType(String string) {
        String string2 = string.toLowerCase();
        if (string2.indexOf("time") >= 0) {
            this.readoutType = "time";
            this.readout.setToolTipText(MediaRes.getString("VideoPlayer.Readout.ToolTip.Time"));
        } else if (string2.indexOf("step") >= 0) {
            this.readoutType = "step";
            this.readout.setToolTipText(MediaRes.getString("VideoPlayer.Readout.ToolTip.Step"));
        } else if (string2.indexOf("frame") >= 0) {
            this.readoutType = "frame";
            this.readout.setToolTipText(MediaRes.getString("VideoPlayer.Readout.ToolTip.Frame"));
        }
        boolean bl = false;
        int n = 0;
        while (n < this.readoutTypes.length) {
            bl = bl || this.readoutTypes[n] == this.readoutType;
            ++n;
        }
        if (!bl) {
            String[] stringArray = new String[this.readoutTypes.length + 1];
            stringArray[0] = this.readoutType;
            int n2 = 0;
            while (n2 < this.readoutTypes.length) {
                stringArray[n2 + 1] = this.readoutTypes[n2];
                ++n2;
            }
            this.readoutTypes = stringArray;
        }
        this.updateReadout();
    }

    public void play() {
        this.clipControl.play();
    }

    public void stop() {
        this.clipControl.stop();
    }

    public void step() {
        this.clipControl.step();
        this.updatePlayButton(false);
    }

    public void back() {
        this.clipControl.back();
        this.updatePlayButton(false);
    }

    public void setRate(double d) {
        this.clipControl.setRate(d);
    }

    public double getRate() {
        return this.clipControl.getRate();
    }

    public void setLooping(boolean bl) {
        this.clipControl.setLooping(bl);
    }

    public boolean isLooping() {
        return this.clipControl.isLooping();
    }

    public void setStepNumber(int n) {
        this.clipControl.setStepNumber(n);
    }

    public int getStepNumber() {
        return this.clipControl.getStepNumber();
    }

    public int getFrameNumber() {
        return this.clipControl.getFrameNumber();
    }

    public double getTime() {
        return this.clipControl.getTime() + this.clipControl.clip.getStartTime();
    }

    public double getStepTime(int n) {
        return this.clipControl.getStepTime(n) + this.clipControl.clip.getStartTime();
    }

    public double getFrameTime(int n) {
        return this.clipControl.clip.getStartTime() - (double)(this.clipControl.clip.getStartFrameNumber() - n) * this.clipControl.getMeanFrameDuration();
    }

    public double getMeanStepDuration() {
        return this.getClipControl().getMeanFrameDuration() * (double)this.getVideoClip().getStepSize();
    }

    public void setInspectorButtonVisible(final boolean bl) {
        if (bl == this.inspectorButtonVisible) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                VideoPlayer.this.inspectorButtonVisible = bl;
                if (bl) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.inspectorButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.inspectorButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void setLoopingButtonVisible(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.loopButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.loopButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("stepnumber")) {
            this.updateReadout();
            if (this.playButton.getIcon() == this.resetIcon) {
                this.updatePlayButton(this.clipControl.isPlaying());
            }
            this.firePropertyChange("stepnumber", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("frameduration")) {
            this.updateReadout();
            this.firePropertyChange("frameduration", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("playing")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.updatePlayButton(bl);
        } else if (string.equals("looping")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.updateLoopButton(bl);
        } else if (string.equals("stepcount")) {
            this.slider.setMaximum(this.getVideoClip().getStepCount() - 1);
            this.updatePlayButton(this.clipControl.isPlaying());
        } else if (string.equals("stepsize")) {
            this.updateReadout();
        } else if (string.equals("startframe")) {
            this.updateReadout();
        } else if (string.equals("starttime")) {
            this.updateReadout();
        }
    }

    public void refresh() {
        this.stepButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepForward.ToolTip"));
        this.backButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepBack.ToolTip"));
        this.inspectorButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.ClipSettings.ToolTip"));
        this.loopButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Looping.ToolTip"));
        this.setReadoutType(this.readoutType);
        this.updatePlayButton(this.clipControl.isPlaying());
        this.updateLoopButton(this.clipControl.isLooping());
        if (this.getVideoClip().inspector != null) {
            this.getVideoClip().inspector.refresh();
        }
    }

    private void setBounds() {
        this.toolbar.revalidate();
        this.height = this.playButton.getPreferredSize().height + 8;
        int n = this.vidPanel.getHeight() - this.height;
        int n2 = this.vidPanel.getWidth();
        this.setBounds(0, n, n2, this.height);
        this.toolbar.revalidate();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "South");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.playIcon = new VideoPlayerIcon("play");
        this.grayPlayIcon = new VideoPlayerIcon("grayplay");
        this.pauseIcon = new VideoPlayerIcon("pause");
        this.resetIcon = new VideoPlayerIcon("reset");
        this.playButton = new JButton(this.playIcon);
        this.playButton.setDisabledIcon(this.grayPlayIcon);
        this.playButton.setSelectedIcon(this.pauseIcon);
        this.playButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (VideoPlayer.this.playButton.isSelected()) {
                    VideoPlayer.this.stop();
                } else if (VideoPlayer.this.getVideoClip().getStepCount() == VideoPlayer.this.clipControl.getStepNumber() + 1) {
                    VideoPlayer.this.clipControl.setStepNumber(0);
                    VideoPlayer.this.updatePlayButton(false);
                } else {
                    VideoPlayer.this.play();
                }
            }
        });
        this.playButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    if (VideoPlayer.this.playButton.isSelected()) {
                        VideoPlayer.this.stop();
                    } else if (VideoPlayer.this.getVideoClip().getStepCount() == VideoPlayer.this.clipControl.getStepNumber() + 1) {
                        VideoPlayer.this.clipControl.setStepNumber(0);
                        VideoPlayer.this.updatePlayButton(false);
                    } else {
                        VideoPlayer.this.play();
                    }
                }
            }
        });
        this.stepButton = new JButton(new VideoPlayerIcon("step"));
        this.stepButton.setDisabledIcon(new VideoPlayerIcon("graystep"));
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VideoPlayer.this.step();
            }
        });
        this.backButton = new JButton(new VideoPlayerIcon("back"));
        this.backButton.setDisabledIcon(new VideoPlayerIcon("grayback"));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VideoPlayer.this.back();
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == VideoPlayer.this.stepButton) {
                    VideoPlayer.this.firePropertyChange("stepbutton", null, new Boolean(true));
                } else {
                    VideoPlayer.this.firePropertyChange("backbutton", null, new Boolean(true));
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == VideoPlayer.this.stepButton) {
                    VideoPlayer.this.firePropertyChange("stepbutton", null, new Boolean(false));
                } else {
                    VideoPlayer.this.firePropertyChange("backbutton", null, new Boolean(false));
                }
            }
        };
        this.stepButton.addMouseListener(mouseAdapter);
        this.backButton.addMouseListener(mouseAdapter);
        this.slider = new JSlider(0, 0, 0);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = VideoPlayer.this.slider.getValue();
                if (n != VideoPlayer.this.getStepNumber()) {
                    VideoPlayer.this.setStepNumber(n);
                }
            }
        });
        InputMap inputMap = this.slider.getInputMap(0);
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.slider);
        actionMap.put(inputMap.get(KeyStroke.getKeyStroke(33, 0)), null);
        actionMap.put(inputMap.get(KeyStroke.getKeyStroke(34, 0)), null);
        this.slider.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 33: {
                        VideoPlayer.this.back();
                        break;
                    }
                    case 34: {
                        VideoPlayer.this.step();
                    }
                }
            }
        });
        this.readout = new JLabel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }
        };
        Border border = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        Border border2 = BorderFactory.createEtchedBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.readout.setBorder(compoundBorder);
        this.readout.setForeground(new Color(204, 51, 51));
        this.readout.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (VideoPlayer.this.readoutTypes.length < 2) {
                    return;
                }
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        VideoPlayer.this.setReadoutType(actionEvent.getActionCommand());
                    }
                };
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n = 0;
                while (n < VideoPlayer.this.readoutTypes.length) {
                    String string = VideoPlayer.this.readoutTypes[n];
                    JMenuItem jMenuItem = string.equals("step") ? new JMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Step")) : (string.equals("time") ? new JMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Time")) : new JMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Frame")));
                    jMenuItem.setFont(new Font("Dialog", 0, 12));
                    jMenuItem.setActionCommand(string);
                    jMenuItem.addActionListener(actionListener);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                }
                jPopupMenu.show(VideoPlayer.this.readout, 0, VideoPlayer.this.readout.getHeight());
            }
        });
        this.inspectorButton = new JButton(new VideoPlayerIcon("inspector"));
        this.inspectorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector clipInspector;
                Frame frame = null;
                Container container = VideoPlayer.this.vidPanel.getTopLevelAncestor();
                if (container instanceof Frame) {
                    frame = (Frame)container;
                }
                if ((clipInspector = VideoPlayer.this.getVideoClip().getClipInspector(VideoPlayer.this.clipControl, frame)).isVisible()) {
                    return;
                }
                Point point = clipInspector.getLocation();
                if (point.x == 0 && point.y == 0) {
                    Dimension dimension = VideoPlayer.this.vidPanel.getSize();
                    Point point2 = VideoPlayer.this.vidPanel.getLocationOnScreen();
                    int n = (point2.x + dimension.width - clipInspector.getBounds().width) / 2;
                    int n2 = (point2.y + dimension.height - clipInspector.getBounds().height) / 2;
                    clipInspector.setLocation(n, n2);
                }
                clipInspector.initialize();
                clipInspector.setVisible(true);
            }
        });
        this.loopIcon = new VideoPlayerIcon("loop");
        this.noloopIcon = new VideoPlayerIcon("noloop");
        this.loopButton = new JButton(this.noloopIcon);
        this.loopButton.setSelectedIcon(this.loopIcon);
        this.loopButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
            }
        });
        this.loopButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
                }
            }
        });
        this.toolbar.add(this.readout);
        this.toolbar.add(this.playButton);
        this.toolbar.add(this.slider);
        this.toolbar.add(this.backButton);
        this.toolbar.add(this.stepButton);
        this.toolbar.add(this.loopButton);
        if (this.inspectorButtonVisible) {
            this.toolbar.add(this.inspectorButton);
        }
    }

    private void updatePlayButton(boolean bl) {
        boolean bl2 = this.getVideoClip().getStepCount() > 1;
        this.playButton.setEnabled(bl2);
        this.stepButton.setEnabled(bl2);
        this.backButton.setEnabled(bl2);
        this.playButton.setSelected(bl);
        if (bl) {
            this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Pause.ToolTip"));
            this.playButton.setPressedIcon(this.pauseIcon);
            this.playButton.setIcon(this.pauseIcon);
        } else if (this.getVideoClip().getStepCount() <= this.clipControl.getStepNumber() + 1 && this.getVideoClip().getStepCount() > 1) {
            this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Reset.ToolTip"));
            this.playButton.setPressedIcon(this.resetIcon);
            this.playButton.setIcon(this.resetIcon);
        } else {
            this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Play.ToolTip"));
            this.playButton.setPressedIcon(this.playIcon);
            this.playButton.setIcon(this.playIcon);
        }
    }

    private void updateLoopButton(boolean bl) {
        if (bl == this.loopButton.isSelected()) {
            return;
        }
        this.loopButton.setSelected(bl);
        if (bl) {
            this.loopButton.setPressedIcon(this.loopIcon);
            this.loopButton.setIcon(this.loopIcon);
        } else {
            this.loopButton.setPressedIcon(this.noloopIcon);
            this.loopButton.setIcon(this.noloopIcon);
        }
    }

    private void updateReadout() {
        String string;
        int n = this.clipControl.getStepNumber();
        this.slider.setValue(n);
        this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Slider.ToolTip")) + n);
        if (this.readoutType.equals("step")) {
            string = n < 10 ? "00" + n : (n < 100 ? "0" + n : "" + n);
        } else if (this.readoutType.equals("frame")) {
            int n2 = this.clipControl.getFrameNumber();
            if (this.clipControl instanceof VideoClipControl) {
                n2 = this.getVideoClip().getVideo().getFrameNumber();
            }
            string = n2 < 10 ? "00" + n2 : (n2 < 100 ? "0" + n2 : "" + n2);
        } else {
            string = this.timeFormat.format(this.getTime() / 1000.0);
        }
        this.readout.setText(string);
    }

    private class VideoPlayerIcon
    implements Icon {
        private Color shapeColor;
        private Color shadowColor;
        private Color hiliteColor;
        private Shape shape;
        private Shape shadow;
        private Shape hilite;

        VideoPlayerIcon(String string) {
            if (string.equals("play")) {
                this.createPlayIcon();
            } else if (string.equals("grayplay")) {
                this.createPlayIcon();
                this.setToGray();
            } else if (string.equals("pause")) {
                this.createPauseIcon();
            } else if (string.equals("reset")) {
                this.createResetIcon();
            } else if (string.equals("step")) {
                this.createStepIcon();
            } else if (string.equals("graystep")) {
                this.createStepIcon();
                this.setToGray();
            } else if (string.equals("back")) {
                this.createBackIcon();
            } else if (string.equals("grayback")) {
                this.createBackIcon();
                this.setToGray();
            } else if (string.equals("inspector")) {
                this.createInspectorIcon();
            } else if (string.equals("loop")) {
                this.createLoopIcon();
            } else if (string.equals("noloop")) {
                this.createNoloopIcon();
            }
        }

        private void setToGray() {
            this.shapeColor = new Color(204, 204, 204);
            this.shadowColor = new Color(102, 102, 102);
        }

        public int getIconWidth() {
            return 14;
        }

        public int getIconHeight() {
            return 14;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.shape == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(n, n2);
            graphics2D.setPaint(this.shapeColor);
            graphics2D.fill(this.shape);
            if (this.shadow != null) {
                graphics2D.setPaint(this.shadowColor);
                graphics2D.fill(this.shadow);
            }
            if (this.hilite != null) {
                graphics2D.setPaint(this.hiliteColor);
                graphics2D.fill(this.hilite);
            }
            graphics2D.setPaint(paint);
            graphics2D.setTransform(affineTransform);
        }

        private void createPlayIcon() {
            this.shapeColor = new Color(51, 204, 51);
            this.shadowColor = new Color(51, 102, 51);
            this.hiliteColor = Color.white;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(4.5f, 4.5f);
            generalPath.lineTo(4.5f, 10.5f);
            generalPath.moveTo(5.5f, 5.5f);
            generalPath.lineTo(5.5f, 9.5f);
            generalPath.moveTo(6.5f, 5.5f);
            generalPath.lineTo(6.5f, 9.5f);
            generalPath.moveTo(7.5f, 6.5f);
            generalPath.lineTo(7.5f, 8.5f);
            generalPath.moveTo(8.5f, 6.5f);
            generalPath.lineTo(8.5f, 8.5f);
            generalPath.moveTo(9.5f, 7.5f);
            generalPath.lineTo(10.5f, 7.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(4.5f, 3.5f);
            generalPath.lineTo(3.5f, 3.5f);
            generalPath.lineTo(3.5f, 10.5f);
            generalPath.moveTo(5.5f, 4.5f);
            generalPath.lineTo(6.5f, 4.5f);
            generalPath.moveTo(7.5f, 5.5f);
            generalPath.lineTo(8.5f, 5.5f);
            generalPath.moveTo(9.5f, 6.5f);
            generalPath.lineTo(10.5f, 6.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(3.5f, 11.5f);
            generalPath.lineTo(4.5f, 11.5f);
            generalPath.moveTo(5.5f, 10.5f);
            generalPath.lineTo(6.5f, 10.5f);
            generalPath.moveTo(7.5f, 9.5f);
            generalPath.lineTo(8.5f, 9.5f);
            generalPath.moveTo(9.5f, 8.5f);
            generalPath.lineTo(10.5f, 8.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createResetIcon() {
            this.shapeColor = Color.black;
            this.shadowColor = new Color(51, 51, 51);
            this.hiliteColor = Color.white;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(4.5f, 4.5f);
            generalPath.lineTo(4.5f, 10.5f);
            generalPath.moveTo(9.5f, 4.5f);
            generalPath.lineTo(9.5f, 10.5f);
            generalPath.moveTo(8.5f, 5.5f);
            generalPath.lineTo(8.5f, 9.5f);
            generalPath.moveTo(7.5f, 6.5f);
            generalPath.lineTo(7.5f, 8.5f);
            generalPath.moveTo(6.5f, 7.5f);
            generalPath.lineTo(6.5f, 8.0f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(4.5f, 3.5f);
            generalPath.lineTo(5.5f, 3.5f);
            generalPath.lineTo(5.5f, 10.5f);
            generalPath.moveTo(6.5f, 6.5f);
            generalPath.lineTo(7.0f, 6.5f);
            generalPath.moveTo(7.5f, 5.5f);
            generalPath.lineTo(8.0f, 5.5f);
            generalPath.moveTo(8.5f, 4.5f);
            generalPath.lineTo(9.0f, 4.5f);
            generalPath.moveTo(9.5f, 3.5f);
            generalPath.lineTo(10.5f, 3.5f);
            generalPath.lineTo(10.5f, 10.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(5.5f, 11.5f);
            generalPath.lineTo(4.5f, 11.5f);
            generalPath.moveTo(10.5f, 11.5f);
            generalPath.lineTo(9.5f, 11.5f);
            generalPath.moveTo(8.5f, 10.5f);
            generalPath.lineTo(9.0f, 10.5f);
            generalPath.moveTo(7.5f, 9.5f);
            generalPath.lineTo(8.0f, 9.5f);
            generalPath.moveTo(6.5f, 8.5f);
            generalPath.lineTo(7.0f, 8.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createPauseIcon() {
            this.shapeColor = new Color(204, 51, 51);
            this.shadowColor = new Color(102, 51, 51);
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(5.5f, 4.5f);
            generalPath.lineTo(5.5f, 10.5f);
            generalPath.moveTo(9.5f, 4.5f);
            generalPath.lineTo(9.5f, 10.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(5.5f, 3.5f);
            generalPath.lineTo(4.5f, 3.5f);
            generalPath.lineTo(4.5f, 10.5f);
            generalPath.moveTo(9.5f, 3.5f);
            generalPath.lineTo(8.5f, 3.5f);
            generalPath.lineTo(8.5f, 10.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
        }

        private void createStepIcon() {
            this.shapeColor = new Color(51, 51, 204);
            this.shadowColor = new Color(51, 51, 102);
            this.hiliteColor = Color.white;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(4.5f, 4.5f);
            generalPath.lineTo(4.5f, 10.5f);
            generalPath.moveTo(7.5f, 4.5f);
            generalPath.lineTo(7.5f, 10.5f);
            generalPath.moveTo(8.5f, 5.5f);
            generalPath.lineTo(8.5f, 9.5f);
            generalPath.moveTo(9.5f, 6.5f);
            generalPath.lineTo(9.5f, 8.5f);
            generalPath.moveTo(10.5f, 7.5f);
            generalPath.lineTo(10.5f, 8.0f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(4.5f, 3.5f);
            generalPath.lineTo(3.5f, 3.5f);
            generalPath.lineTo(3.5f, 10.5f);
            generalPath.moveTo(10.5f, 6.5f);
            generalPath.lineTo(11.0f, 6.5f);
            generalPath.moveTo(9.5f, 5.5f);
            generalPath.lineTo(10.0f, 5.5f);
            generalPath.moveTo(8.5f, 4.5f);
            generalPath.lineTo(9.0f, 4.5f);
            generalPath.moveTo(7.5f, 3.5f);
            generalPath.lineTo(6.5f, 3.5f);
            generalPath.lineTo(6.5f, 10.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(3.5f, 11.5f);
            generalPath.lineTo(4.5f, 11.5f);
            generalPath.moveTo(6.5f, 11.5f);
            generalPath.lineTo(7.5f, 11.5f);
            generalPath.moveTo(8.5f, 10.5f);
            generalPath.lineTo(9.0f, 10.5f);
            generalPath.moveTo(9.5f, 9.5f);
            generalPath.lineTo(10.0f, 9.5f);
            generalPath.moveTo(10.5f, 8.5f);
            generalPath.lineTo(11.0f, 8.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createBackIcon() {
            this.shapeColor = new Color(51, 51, 204);
            this.shadowColor = new Color(51, 51, 102);
            this.hiliteColor = Color.white;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(9.5f, 4.5f);
            generalPath.lineTo(9.5f, 10.5f);
            generalPath.moveTo(6.5f, 4.5f);
            generalPath.lineTo(6.5f, 10.5f);
            generalPath.moveTo(5.5f, 5.5f);
            generalPath.lineTo(5.5f, 9.5f);
            generalPath.moveTo(4.5f, 6.5f);
            generalPath.lineTo(4.5f, 8.5f);
            generalPath.moveTo(3.5f, 7.5f);
            generalPath.lineTo(3.5f, 8.0f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(9.5f, 3.5f);
            generalPath.lineTo(10.5f, 3.5f);
            generalPath.lineTo(10.5f, 10.5f);
            generalPath.moveTo(3.5f, 6.5f);
            generalPath.lineTo(4.0f, 6.5f);
            generalPath.moveTo(4.5f, 5.5f);
            generalPath.lineTo(5.0f, 5.5f);
            generalPath.moveTo(5.5f, 4.5f);
            generalPath.lineTo(6.0f, 4.5f);
            generalPath.moveTo(6.5f, 3.5f);
            generalPath.lineTo(7.5f, 3.5f);
            generalPath.lineTo(7.5f, 10.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(10.5f, 11.5f);
            generalPath.lineTo(9.5f, 11.5f);
            generalPath.moveTo(7.5f, 11.5f);
            generalPath.lineTo(6.5f, 11.5f);
            generalPath.moveTo(5.5f, 10.5f);
            generalPath.lineTo(6.0f, 10.5f);
            generalPath.moveTo(4.5f, 9.5f);
            generalPath.lineTo(5.0f, 9.5f);
            generalPath.moveTo(3.5f, 8.5f);
            generalPath.lineTo(4.0f, 8.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createInspectorIcon() {
            this.shapeColor = new Color(51, 51, 51);
            this.shadowColor = Color.black;
            this.hiliteColor = new Color(153, 153, 255);
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(8.5f, 12.5f);
            generalPath.lineTo(2.5f, 12.5f);
            generalPath.lineTo(2.5f, 2.5f);
            generalPath.lineTo(4.5f, 2.5f);
            generalPath.lineTo(4.5f, 11.5f);
            generalPath.moveTo(3.5f, 8.5f);
            generalPath.lineTo(12.5f, 8.5f);
            generalPath.lineTo(12.5f, 2.5f);
            generalPath.lineTo(10.5f, 2.5f);
            generalPath.lineTo(10.5f, 7.5f);
            generalPath.moveTo(3.5f, 4.5f);
            generalPath.lineTo(11.5f, 4.5f);
            generalPath.moveTo(3.5f, 6.5f);
            generalPath.lineTo(3.5f, 6.5f);
            generalPath.moveTo(3.5f, 10.5f);
            generalPath.lineTo(3.5f, 10.5f);
            generalPath.moveTo(11.5f, 6.5f);
            generalPath.lineTo(11.5f, 6.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(9.5f, 10.5f);
            generalPath.lineTo(13.5f, 10.5f);
            generalPath.moveTo(10.5f, 11.5f);
            generalPath.lineTo(12.5f, 11.5f);
            generalPath.moveTo(11.5f, 12.5f);
            generalPath.lineTo(12.0f, 12.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(5.5f, 2.5f);
            generalPath.lineTo(9.5f, 2.5f);
            generalPath.moveTo(5.5f, 3.5f);
            generalPath.lineTo(9.5f, 3.5f);
            generalPath.moveTo(5.5f, 5.5f);
            generalPath.lineTo(9.5f, 5.5f);
            generalPath.moveTo(5.5f, 6.5f);
            generalPath.lineTo(9.5f, 6.5f);
            generalPath.moveTo(5.5f, 7.5f);
            generalPath.lineTo(9.5f, 7.5f);
            generalPath.moveTo(5.5f, 9.5f);
            generalPath.lineTo(7.5f, 9.5f);
            generalPath.moveTo(5.5f, 10.5f);
            generalPath.lineTo(6.5f, 10.5f);
            generalPath.moveTo(5.5f, 11.5f);
            generalPath.lineTo(7.5f, 11.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createLoopIcon() {
            this.shapeColor = new Color(0, 153, 0);
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(3.5f, 4.5f);
            generalPath.lineTo(3.5f, 2.5f);
            generalPath.lineTo(10.5f, 2.5f);
            generalPath.lineTo(10.5f, 7.5f);
            generalPath.moveTo(7.5f, 4.5f);
            generalPath.lineTo(13.5f, 4.5f);
            generalPath.moveTo(8.5f, 5.5f);
            generalPath.lineTo(12.5f, 5.5f);
            generalPath.moveTo(9.5f, 6.5f);
            generalPath.lineTo(11.5f, 6.5f);
            generalPath.moveTo(10.5f, 9.5f);
            generalPath.lineTo(10.5f, 11.5f);
            generalPath.lineTo(3.5f, 11.5f);
            generalPath.lineTo(3.5f, 6.5f);
            generalPath.moveTo(0.5f, 9.5f);
            generalPath.lineTo(6.5f, 9.5f);
            generalPath.moveTo(1.5f, 8.5f);
            generalPath.lineTo(5.5f, 8.5f);
            generalPath.moveTo(2.5f, 7.5f);
            generalPath.lineTo(4.5f, 7.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
        }

        private void createNoloopIcon() {
            this.shapeColor = new Color(0, 153, 0);
            this.shadowColor = Color.black;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(3.5f, 4.5f);
            generalPath.lineTo(3.5f, 2.5f);
            generalPath.lineTo(10.5f, 2.5f);
            generalPath.lineTo(10.5f, 7.5f);
            generalPath.moveTo(7.5f, 4.5f);
            generalPath.lineTo(13.5f, 4.5f);
            generalPath.moveTo(8.5f, 5.5f);
            generalPath.lineTo(12.5f, 5.5f);
            generalPath.moveTo(9.5f, 6.5f);
            generalPath.lineTo(11.5f, 6.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            basicStroke = new BasicStroke(2.0f);
            generalPath.reset();
            generalPath.moveTo(9.0f, 9.0f);
            generalPath.lineTo(12.5f, 9.0f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
        }
    }
}

