/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceSet
extends ElementSet
implements Data {
    protected int datasetID = this.hashCode();

    public TraceSet(int n) {
        super(n, InteractiveTrace.class);
    }

    public InteractiveTrace traceAt(int n) {
        return (InteractiveTrace)this.elements[n];
    }

    public void clear() {
        int n = 0;
        while (n < this.numElements) {
            ((InteractiveTrace)this.elements[n]).clear();
            ++n;
        }
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        int n = 0;
        while (n < this.numElements) {
            ((InteractiveTrace)this.elements[n]).setName(String.valueOf(string) + "_" + n);
            ++n;
        }
    }

    public void addPoints(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = this.numElements;
        if (n > dArray.length) {
            n = dArray.length;
        }
        if (n > dArray2.length) {
            n = dArray2.length;
        }
        if (dArray3 == null) {
            int n2 = 0;
            while (n2 < n) {
                ((InteractiveTrace)this.elements[n2]).addPoint(dArray[n2], dArray2[n2], 0.0);
                ++n2;
            }
        } else {
            if (n > dArray3.length) {
                n = dArray3.length;
            }
            int n3 = 0;
            while (n3 < n) {
                ((InteractiveTrace)this.elements[n3]).addPoint(dArray[n3], dArray2[n3], dArray3[n3]);
                ++n3;
            }
        }
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return null;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, Color.BLUE};
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{Color.BLACK, Color.RED};
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> arrayList = new ArrayList<Data>();
        int n = 0;
        while (n < this.numElements) {
            arrayList.add((InteractiveTrace)this.elements[n]);
            ++n;
        }
        return arrayList;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }
}

