/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;

public class PolarCoordinateStringBuilder
extends CoordinateStringBuilder {
    protected String rLabel = "r=";
    protected String phiLabel = " phi=";
    protected double sin = 0.0;
    protected double cos = 1.0;

    public PolarCoordinateStringBuilder() {
        this("r=", "  phi=");
    }

    public PolarCoordinateStringBuilder(String string, String string2, double d) {
        this(string, string2);
        this.sin = -Math.sin(d);
        this.cos = Math.cos(d);
    }

    public PolarCoordinateStringBuilder(String string, String string2) {
        this.rLabel = string;
        this.phiLabel = string2;
    }

    public void setCoordinateLabels(String string, String string2) {
        this.rLabel = string;
        this.phiLabel = string2;
    }

    public String getCoordinateString(DrawingPanel drawingPanel, MouseEvent mouseEvent) {
        double d;
        double d2 = drawingPanel.pixToX(mouseEvent.getPoint().x);
        double d3 = drawingPanel.pixToY(mouseEvent.getPoint().y);
        if (drawingPanel instanceof InteractivePanel && ((InteractivePanel)drawingPanel).getCurrentDraggable() != null) {
            d2 = ((InteractivePanel)drawingPanel).getCurrentDraggable().getX();
            d3 = ((InteractivePanel)drawingPanel).getCurrentDraggable().getY();
        }
        String string = (d = Math.sqrt(d2 * d2 + d3 * d3)) > 100.0 || d < 0.01 ? String.valueOf(this.rLabel) + this.scientificFormat.format((float)d) : String.valueOf(this.rLabel) + this.decimalFormat.format((float)d);
        string = String.valueOf(string) + this.phiLabel + this.decimalFormat.format((double)(180.0f * (float)Math.atan2(d2 * this.sin + d3 * this.cos, d2 * this.cos - d3 * this.sin)) / Math.PI);
        return string;
    }
}

