/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.TransformArray;

public class ImageCoordSystem {
    protected static NumberFormat decimal = NumberFormat.getNumberInstance(Locale.US);
    protected static NumberFormat sci = NumberFormat.getNumberInstance(Locale.US);
    private int length;
    protected PropertyChangeSupport support;
    private Point2D point = new Point2D.Double();
    private TransformArray toImage;
    private TransformArray toWorld;
    private DoubleArray scaleX;
    private DoubleArray scaleY;
    private DoubleArray originX;
    private DoubleArray originY;
    private DoubleArray cosine;
    private DoubleArray sine;
    TreeSet<Integer> keyFrames = new TreeSet();
    protected boolean firePropChange = true;
    private boolean isAdjusting = false;
    private boolean fixedOrigin = true;
    private boolean fixedAngle = true;
    private boolean fixedScale = true;
    private boolean locked = false;
    private boolean updateToKeyFrames = true;

    static {
        ((DecimalFormat)decimal).applyPattern("0.00");
        ((DecimalFormat)sci).applyPattern("0.###E0");
    }

    public ImageCoordSystem() {
        this(10);
    }

    public ImageCoordSystem(int n) {
        this.length = n;
        this.toImage = new TransformArray(n);
        this.toWorld = new TransformArray(n);
        this.scaleX = new DoubleArray(n, 1.0);
        this.scaleY = new DoubleArray(n, 1.0);
        this.originX = new DoubleArray(n, 0.0);
        this.originY = new DoubleArray(n, 0.0);
        this.cosine = new DoubleArray(n, 1.0);
        this.sine = new DoubleArray(n, 0.0);
        this.support = new SwingPropertyChangeSupport(this);
        this.updateAllTransforms();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
        this.support.firePropertyChange("locked", null, new Boolean(bl));
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setAllValuesToFrame(int n) {
        this.setAllOriginsXY(this.getOriginX(n), this.getOriginY(n));
        this.setAllCosineSines(this.getCosine(n), this.getSine(n));
        this.setAllScalesXY(this.getScaleX(n), this.getScaleY(n));
        this.keyFrames.clear();
    }

    public void setFixedOrigin(boolean bl) {
        this.setFixedOrigin(bl, 0);
    }

    public void setFixedOrigin(boolean bl, int n) {
        if (bl && this.fixedAngle && this.fixedScale) {
            this.keyFrames.clear();
        }
        if (this.fixedOrigin == bl) {
            return;
        }
        this.fixedOrigin = bl;
        if (bl) {
            this.setAllOriginsXY(this.getOriginX(n), this.getOriginY(n));
        }
        this.support.firePropertyChange("fixed_origin", !bl, bl);
    }

    public boolean isFixedOrigin() {
        return this.fixedOrigin;
    }

    public void setFixedAngle(boolean bl) {
        this.setFixedAngle(bl, 0);
    }

    public void setFixedAngle(boolean bl, int n) {
        if (bl && this.fixedOrigin && this.fixedScale) {
            this.keyFrames.clear();
        }
        if (this.fixedAngle == bl) {
            return;
        }
        this.fixedAngle = bl;
        if (bl) {
            this.setAllCosineSines(this.getCosine(n), this.getSine(n));
        }
        this.support.firePropertyChange("fixed_angle", !bl, bl);
    }

    public boolean isFixedAngle() {
        return this.fixedAngle;
    }

    public void setFixedScale(boolean bl) {
        this.fixedScale = bl;
    }

    public void setFixedScale(boolean bl, int n) {
        if (bl && this.fixedOrigin && this.fixedAngle) {
            this.keyFrames.clear();
        }
        if (this.fixedScale == bl) {
            return;
        }
        this.fixedScale = bl;
        if (bl) {
            this.setAllScalesXY(this.getScaleX(n), this.getScaleY(n));
        }
        this.support.firePropertyChange("fixed_scale", !bl, bl);
    }

    public boolean isFixedScale() {
        return this.fixedScale;
    }

    public double getScaleX(int n) {
        return this.scaleX.get(n);
    }

    public double getScaleY(int n) {
        return this.scaleY.get(n);
    }

    public void setScaleX(int n, double d) {
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedScale()) {
            this.setAllScalesX(d);
            return;
        }
        if (this.updateToKeyFrames) {
            int n2 = this.length - 1;
            for (int n3 : this.keyFrames) {
                if (n3 <= n) continue;
                n2 = n3 - 1;
                break;
            }
            this.setScalesX(n, n2, d);
            this.keyFrames.add(n);
            return;
        }
        if (this.scaleX.set(n, d)) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
    }

    public void setAllScalesX(double d) {
        if (this.isLocked()) {
            return;
        }
        if (this.scaleX.fill(d)) {
            this.updateAllTransforms();
        }
    }

    public void setScalesX(int n, int n2, double d) {
        if (this.isLocked()) {
            return;
        }
        if (this.scaleX.fill(d, n, n2)) {
            this.updateTransforms(n, n2);
        }
    }

    public void setScaleY(int n, double d) {
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedScale()) {
            this.setAllScalesY(d);
            return;
        }
        if (this.updateToKeyFrames) {
            int n2 = this.length - 1;
            for (int n3 : this.keyFrames) {
                if (n3 <= n) continue;
                n2 = n3 - 1;
                break;
            }
            this.setScalesY(n, n2, d);
            this.keyFrames.add(n);
            return;
        }
        if (this.scaleY.set(n, d)) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
    }

    public void setAllScalesY(double d) {
        if (this.isLocked()) {
            return;
        }
        if (this.scaleY.fill(d)) {
            this.updateAllTransforms();
        }
    }

    public void setScalesY(int n, int n2, double d) {
        if (this.isLocked()) {
            return;
        }
        if (this.scaleY.fill(d, n, n2)) {
            this.updateTransforms(n, n2);
        }
    }

    public void setScaleXY(int n, double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedScale()) {
            this.setAllScalesXY(d, d2);
            return;
        }
        if (this.updateToKeyFrames) {
            int n2 = this.length - 1;
            for (int n3 : this.keyFrames) {
                if (n3 <= n) continue;
                n2 = n3 - 1;
                break;
            }
            this.setScalesXY(n, n2, d, d2);
            this.keyFrames.add(n);
            return;
        }
        boolean bl = this.scaleX.set(n, d);
        boolean bl2 = bl = this.scaleY.set(n, d2) || bl;
        if (bl) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
    }

    public void setAllScalesXY(double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        boolean bl = this.scaleX.fill(d);
        boolean bl2 = bl = this.scaleY.fill(d2) || bl;
        if (bl) {
            this.updateAllTransforms();
        }
    }

    public void setScalesXY(int n, int n2, double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        boolean bl = this.scaleX.fill(d, n, n2);
        boolean bl2 = bl = this.scaleY.fill(d2, n, n2) || bl;
        if (bl) {
            this.updateTransforms(n, n2);
        }
    }

    public double getOriginX(int n) {
        return this.originX.get(n);
    }

    public double getOriginY(int n) {
        return this.originY.get(n);
    }

    public void setOriginXY(int n, double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedOrigin()) {
            this.setAllOriginsXY(d, d2);
            return;
        }
        if (this.updateToKeyFrames) {
            int n2 = this.length - 1;
            for (int n3 : this.keyFrames) {
                if (n3 <= n) continue;
                n2 = n3 - 1;
                break;
            }
            this.setOriginsXY(n, n2, d, d2);
            this.keyFrames.add(n);
            return;
        }
        boolean bl = this.originX.set(n, d);
        boolean bl2 = bl = this.originY.set(n, d2) || bl;
        if (bl) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
    }

    public void setAllOriginsXY(double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        boolean bl = this.originX.fill(d);
        boolean bl2 = bl = this.originY.fill(d2) || bl;
        if (bl) {
            this.updateAllTransforms();
        }
    }

    public void setOriginsXY(int n, int n2, double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        boolean bl = this.originX.fill(d, n, n2);
        boolean bl2 = bl = this.originY.fill(d2, n, n2) || bl;
        if (bl) {
            this.updateTransforms(n, n2);
        }
    }

    public double getCosine(int n) {
        return this.cosine.get(n);
    }

    public double getSine(int n) {
        return this.sine.get(n);
    }

    public void setCosineSine(int n, double d, double d2) {
        boolean bl;
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedAngle()) {
            this.setAllCosineSines(d, d2);
            return;
        }
        if (this.updateToKeyFrames) {
            int n2 = this.length - 1;
            for (int n3 : this.keyFrames) {
                if (n3 <= n) continue;
                n2 = n3 - 1;
                break;
            }
            this.setCosineSines(n, n2, d, d2);
            this.keyFrames.add(n);
            return;
        }
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            bl = this.cosine.set(n, 1.0);
            bl = this.sine.set(n, 0.0) || bl;
        } else {
            bl = this.cosine.set(n, d / d3);
            boolean bl2 = bl = this.sine.set(n, d2 / d3) || bl;
        }
        if (bl) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
    }

    public void setAllCosineSines(double d, double d2) {
        boolean bl;
        if (this.isLocked()) {
            return;
        }
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            bl = this.cosine.fill(1.0);
            bl = this.sine.fill(0.0) || bl;
        } else {
            bl = this.cosine.fill(d / d3);
            boolean bl2 = bl = this.sine.fill(d2 / d3) || bl;
        }
        if (bl) {
            this.updateAllTransforms();
        }
    }

    public void setCosineSines(int n, int n2, double d, double d2) {
        boolean bl;
        if (this.isLocked()) {
            return;
        }
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            bl = this.cosine.fill(1.0, n, n2);
            bl = this.sine.fill(0.0, n, n2) || bl;
        } else {
            bl = this.cosine.fill(d / d3, n, n2);
            boolean bl2 = bl = this.sine.fill(d2 / d3, n, n2) || bl;
        }
        if (bl) {
            this.updateTransforms(n, n2);
        }
    }

    public double getAngle(int n) {
        return Math.atan2(this.getSine(n), this.getCosine(n));
    }

    public void setAngle(int n, double d) {
        if (this.isLocked()) {
            return;
        }
        this.setCosineSine(n, Math.cos(d), Math.sin(d));
    }

    public void setAllAngles(double d) {
        if (this.isLocked()) {
            return;
        }
        this.setAllCosineSines(Math.cos(d), Math.sin(d));
    }

    public void setLength(int n) {
        if (this.isLocked()) {
            return;
        }
        this.length = n;
        this.toImage.setLength(this.length);
        this.toWorld.setLength(this.length);
        this.scaleX.setLength(this.length);
        this.scaleY.setLength(this.length);
        this.originX.setLength(this.length);
        this.originY.setLength(this.length);
        this.cosine.setLength(this.length);
        this.sine.setLength(this.length);
    }

    public int getLength() {
        return this.length;
    }

    public double imageToWorldX(int n, double d, double d2) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(d, d2);
        this.toWorld.get(n).transform(this.point, this.point);
        return this.point.getX();
    }

    public double imageToWorldY(int n, double d, double d2) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(d, d2);
        this.toWorld.get(n).transform(this.point, this.point);
        return this.point.getY();
    }

    public double worldToImageX(int n, double d, double d2) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(d, d2);
        this.toImage.get(n).transform(this.point, this.point);
        return this.point.getX();
    }

    public double worldToImageY(int n, double d, double d2) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(d, d2);
        this.toImage.get(n).transform(this.point, this.point);
        return this.point.getY();
    }

    public double imageToWorldXComponent(int n, double d, double d2) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(d, d2);
        this.toWorld.get(n).deltaTransform(this.point, this.point);
        return this.point.getX();
    }

    public double imageToWorldYComponent(int n, double d, double d2) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(d, d2);
        this.toWorld.get(n).deltaTransform(this.point, this.point);
        return this.point.getY();
    }

    public double worldToImageXComponent(int n, double d, double d2) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(d, d2);
        this.toImage.get(n).deltaTransform(this.point, this.point);
        return this.point.getX();
    }

    public double worldToImageYComponent(int n, double d, double d2) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(d, d2);
        this.toImage.get(n).deltaTransform(this.point, this.point);
        return this.point.getY();
    }

    public AffineTransform getToImageTransform(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return (AffineTransform)this.toImage.get(n).clone();
    }

    public AffineTransform getToWorldTransform(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return (AffineTransform)this.toWorld.get(n).clone();
    }

    public void setAdjusting(boolean bl) {
        if (this.isAdjusting == bl) {
            return;
        }
        this.isAdjusting = bl;
        this.support.firePropertyChange("adjusting", null, (Object)bl);
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public String getDataString(int n) {
        String string = decimal.format(this.getOriginX(n));
        String string2 = decimal.format(this.getOriginY(n));
        String string3 = decimal.format(this.getAngle(n));
        String string4 = sci.format(this.getScaleX(n));
        String string5 = sci.format(this.getScaleY(n));
        return String.valueOf(n) + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4 + "\t" + string5;
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private void updateAllTransforms() {
        try {
            this.firePropChange = false;
            int n = 0;
            while (n < this.length) {
                this.updateTransforms(n);
                ++n;
            }
            this.firePropChange = true;
            this.support.firePropertyChange("transform", null, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
    }

    private void updateTransforms(int n) throws NoninvertibleTransformException {
        AffineTransform affineTransform = this.toImage.get(n);
        double d = this.originX.get(n);
        double d2 = this.originY.get(n);
        double d3 = this.scaleX.get(n);
        double d4 = this.scaleY.get(n);
        double d5 = this.cosine.get(n);
        double d6 = this.sine.get(n);
        affineTransform.setTransform(d3 * d5, -d4 * d6, -d3 * d6, -d4 * d5, d, d2);
        this.toWorld.get(n).setTransform(affineTransform.createInverse());
        if (this.firePropChange) {
            this.support.firePropertyChange("transform", null, new Integer(n));
        }
    }

    private void updateTransforms(int n, int n2) {
        try {
            this.firePropChange = false;
            int n3 = n;
            while (n3 < this.length) {
                this.updateTransforms(n3);
                ++n3;
            }
            this.firePropChange = true;
            this.support.firePropertyChange("transform", null, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
    }

    private static class FrameData {
        double xo;
        double yo;
        double an;
        double xs;
        double ys;

        FrameData() {
        }

        FrameData(ImageCoordSystem imageCoordSystem, int n) {
            this.xo = imageCoordSystem.getOriginX(n);
            this.yo = imageCoordSystem.getOriginY(n);
            this.an = imageCoordSystem.getAngle(n) * 180.0 / Math.PI;
            this.xs = imageCoordSystem.getScaleX(n);
            this.ys = imageCoordSystem.getScaleY(n);
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            xMLControl.setValue("xorigin", frameData.xo);
            xMLControl.setValue("yorigin", frameData.yo);
            xMLControl.setValue("angle", frameData.an);
            xMLControl.setValue("xscale", frameData.xs);
            xMLControl.setValue("yscale", frameData.ys);
        }

        public Object createObject(XMLControl xMLControl) {
            return new FrameData();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            frameData.xo = xMLControl.getDouble("xorigin");
            frameData.yo = xMLControl.getDouble("yorigin");
            frameData.an = xMLControl.getDouble("angle") * Math.PI / 180.0;
            frameData.xs = xMLControl.getDouble("xscale");
            frameData.ys = xMLControl.getDouble("yscale");
            return object;
        }
    }

    public static class Loader
    implements XML.ObjectLoader {
        public void saveObject(XMLControl xMLControl, Object object) {
            ImageCoordSystem imageCoordSystem = (ImageCoordSystem)object;
            xMLControl.setValue("fixedorigin", imageCoordSystem.isFixedOrigin());
            xMLControl.setValue("fixedangle", imageCoordSystem.isFixedAngle());
            xMLControl.setValue("fixedscale", imageCoordSystem.isFixedScale());
            xMLControl.setValue("locked", imageCoordSystem.isLocked());
            int n = imageCoordSystem.getLength();
            if (imageCoordSystem.isFixedAngle() && imageCoordSystem.isFixedOrigin() && imageCoordSystem.isFixedScale()) {
                n = 1;
            }
            FrameData[] frameDataArray = new FrameData[n];
            int n2 = 0;
            while (n2 < n) {
                frameDataArray[n2] = new FrameData(imageCoordSystem, n2);
                ++n2;
            }
            xMLControl.setValue("framedata", frameDataArray);
        }

        public Object createObject(XMLControl xMLControl) {
            return new ImageCoordSystem();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            ImageCoordSystem imageCoordSystem = (ImageCoordSystem)object;
            imageCoordSystem.setLocked(false);
            imageCoordSystem.setFixedOrigin(xMLControl.getBoolean("fixedorigin"));
            imageCoordSystem.setFixedAngle(xMLControl.getBoolean("fixedangle"));
            imageCoordSystem.setFixedScale(xMLControl.getBoolean("fixedscale"));
            FrameData[] frameDataArray = (FrameData[])xMLControl.getObject("framedata");
            int n = 0;
            while (n < frameDataArray.length) {
                imageCoordSystem.setOriginXY(n, frameDataArray[n].xo, frameDataArray[n].yo);
                imageCoordSystem.setAngle(n, frameDataArray[n].an);
                imageCoordSystem.setScaleXY(n, frameDataArray[n].xs, frameDataArray[n].ys);
                ++n;
            }
            imageCoordSystem.setLocked(xMLControl.getBoolean("locked"));
            return object;
        }
    }
}

