/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementPlane;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementPlane
extends SimpleAbstractTile {
    public static final int RECOMPUTE_PLANE = 28;

    public SimpleElementPlane(ElementPlane elementPlane) {
        super(elementPlane);
    }

    public void processChanges(int n, int n2) {
        if ((n2 & 0x1C) != 0) {
            this.computeVertex();
            this.computeCoordinates();
            this.projectPoints();
        } else if ((n2 & 0x136) != 0) {
            this.computeCoordinates();
            this.projectPoints();
        } else if ((n2 & 0x40) != 0) {
            this.projectPoints();
        }
    }

    protected double[][][] computeTile() {
        ElementPlane elementPlane = (ElementPlane)this.element;
        int n = 1;
        int n2 = 1;
        Resolution resolution = this.style.getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    break;
                }
                case 1: {
                    n = Math.max((int)Math.round(0.49 + Math.abs(elementPlane.getFirstSize()) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(elementPlane.getSecondSize()) / resolution.getMaxLength()), 1);
                }
            }
        }
        return ElementPlane.createPlane(elementPlane, n, n2);
    }
}

