/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;

public class ConstantParser
extends org.colos.ejs.library.control.ConstantParser {
    public static String toString(Point point) {
        return "\"" + point.x + "," + point.y + "\"";
    }

    public static String toString(Dimension dimension) {
        return "\"" + dimension.width + "," + dimension.height + "\"";
    }

    public static Value pointConstant(String string) {
        Object object;
        if ((string = string.trim().toLowerCase()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if ("center".equals(string)) {
            object = EjsControl.getDefaultScreenBounds();
            new ObjectValue(new Point(((Rectangle)object).x + ((Rectangle)object).width / 2, ((Rectangle)object).y + ((Rectangle)object).height / 2));
        }
        if (string.indexOf(44) < 0) {
            return null;
        }
        try {
            object = new StringTokenizer(string, ",");
            int n = Integer.parseInt(((StringTokenizer)object).nextToken());
            int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
            return new ObjectValue(new Point(n, n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Value dimensionConstant(String string) {
        if ((string = string.trim().toLowerCase()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if ("pack".equals(string)) {
            return new StringValue("pack");
        }
        if (string.indexOf(44) < 0) {
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            return new ObjectValue(new Dimension(n, n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Value placementConstant(String string) {
        if ((string = string.trim().toLowerCase()).equals("bottom")) {
            return new IntegerValue(3);
        }
        if (string.equals("left")) {
            return new IntegerValue(2);
        }
        if (string.equals("right")) {
            return new IntegerValue(4);
        }
        if (string.equals("top")) {
            return new IntegerValue(1);
        }
        return null;
    }

    public static Value layoutConstant(Container container, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim().toLowerCase(), ":, ");
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("flow")) {
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    String string3 = stringTokenizer.nextToken();
                    int n = string3.equals("left") ? 0 : (string3.equals("right") ? 2 : 1);
                    if (stringTokenizer.hasMoreTokens()) {
                        int n2 = Integer.parseInt(stringTokenizer.nextToken());
                        int n3 = Integer.parseInt(stringTokenizer.nextToken());
                        return new ObjectValue(new FlowLayout(n, n2, n3));
                    }
                    return new ObjectValue(new FlowLayout(n));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return new ObjectValue(new FlowLayout());
        }
        if (string2.equals("grid")) {
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        int n5 = Integer.parseInt(stringTokenizer.nextToken());
                        int n6 = Integer.parseInt(stringTokenizer.nextToken());
                        return new ObjectValue(new GridLayout(n, n4, n5, n6));
                    }
                    return new ObjectValue(new GridLayout(n, n4));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return new ObjectValue(new GridLayout());
        }
        if (string2.equals("border")) {
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    int n7 = Integer.parseInt(stringTokenizer.nextToken());
                    return new ObjectValue(new BorderLayout(n, n7));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return new ObjectValue(new BorderLayout());
        }
        if (string2.equals("hbox")) {
            return new ObjectValue(new BoxLayout(container, 0));
        }
        if (string2.equals("vbox")) {
            return new ObjectValue(new BoxLayout(container, 1));
        }
        return null;
    }

    public static Value constraintsConstant(String string) {
        if ((string = string.trim().toLowerCase()).equals("north")) {
            return new StringValue("North");
        }
        if (string.equals("south")) {
            return new StringValue("South");
        }
        if (string.equals("east")) {
            return new StringValue("East");
        }
        if (string.equals("west")) {
            return new StringValue("West");
        }
        if (string.equals("center")) {
            return new StringValue("Center");
        }
        return new StringValue("Center");
    }

    public static Value orientationConstant(String string) {
        if ((string = string.trim().toLowerCase()).equals("vertical")) {
            return new IntegerValue(1);
        }
        return new IntegerValue(0);
    }

    public static Value alignmentConstant(String string) {
        if ((string = string.trim().toLowerCase()).indexOf("top") != -1) {
            return new IntegerValue(1);
        }
        if (string.indexOf("center") != -1) {
            return new IntegerValue(0);
        }
        if (string.indexOf("bottom") != -1) {
            return new IntegerValue(3);
        }
        if (string.indexOf("left") != -1) {
            return new IntegerValue(2);
        }
        if (string.indexOf("right") != -1) {
            return new IntegerValue(4);
        }
        if (string.indexOf("leading") != -1) {
            return new IntegerValue(10);
        }
        if (string.indexOf("trailing") != -1) {
            return new IntegerValue(11);
        }
        return new IntegerValue(0);
    }
}

