/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlSet3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlShapeSet3D
extends ControlSet3D {
    private static final int SHAPESET_PROPERTIES_ADDED = 3;
    private static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 3;
    }

    @Override
    protected Element createAnElement() {
        return new ElementShape();
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementShape)element2).setRotationAngle(((ElementShape)element).getRotationAngle());
        ((ElementShape)element2).setShapeType(((ElementShape)element).getShapeType());
        ((ElementShape)element2).setPixelSize(((ElementShape)element).isPixelSize());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.add("pixelSize");
            infoList.add("rotationAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("style")) {
            return "MarkerShape|int|int[]";
        }
        if (string.equals("pixelSize")) {
            return "boolean|boolean[]";
        }
        if (string.equals("rotationAngle")) {
            return "int|double|int[]|double[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n2 = 0;
                    while (n2 < this.numElements) {
                        ((ElementShape)this.elements[n2]).setShapeType(nArray[n2]);
                        ++n2;
                    }
                } else {
                    int n3 = value.getInteger();
                    int n4 = 0;
                    while (n4 < this.numElements) {
                        ((ElementShape)this.elements[n4]).setShapeType(n3);
                        ++n4;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n5 = 0;
                    while (n5 < this.numElements) {
                        ((ElementShape)this.elements[n5]).setPixelSize(blArray[n5]);
                        ++n5;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n6 = 0;
                    while (n6 < this.numElements) {
                        ((ElementShape)this.elements[n6]).setPixelSize(bl);
                        ++n6;
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n7 = 0;
                    while (n7 < this.numElements) {
                        ((ElementShape)this.elements[n7]).setRotationAngle(dArray[n7]);
                        ++n7;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n8 = 0;
                    while (n8 < this.numElements) {
                        ((ElementShape)this.elements[n8]).setRotationAngle((double)nArray[n8] * (Math.PI / 180));
                        ++n8;
                    }
                } else if (value instanceof IntegerValue) {
                    double d = (double)value.getInteger() * (Math.PI / 180);
                    int n9 = 0;
                    while (n9 < this.numElements) {
                        ((ElementShape)this.elements[n9]).setRotationAngle(d);
                        ++n9;
                    }
                } else {
                    double d = value.getDouble();
                    int n10 = 0;
                    while (n10 < this.numElements) {
                        ((ElementShape)this.elements[n10]).setRotationAngle(d);
                        ++n10;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 3, value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numElements) {
                    ((ElementShape)this.elements[n2]).setShapeType(1);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.numElements) {
                    ((ElementShape)this.elements[n3]).setPixelSize(false);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.numElements) {
                    ((ElementShape)this.elements[n4]).setRotationAngle(0.0);
                    ++n4;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 3);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "ELLIPSE";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "0.0";
            }
        }
        return super.getDefaultValueString(n - 3);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(n - 3);
    }
}

