/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import org.opensourcephysics.controls.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private static String encoding = "UTF-8";
    private static Charset defaultCharset = Charset.forName(encoding);
    private URL url;
    private File file;
    private boolean isAnImage = true;
    private ImageIcon icon;
    private String string;
    private AudioClip clip;
    private BufferedImage image;
    private String zipContent;
    private URL contentURL;

    public static Charset getCharset() {
        return defaultCharset;
    }

    public Resource(URL uRL) {
        this.url = uRL;
    }

    public Resource(File file) {
        this.file = file;
    }

    protected Resource(URL uRL, String string) {
        this.url = uRL;
        this.zipContent = string;
        if (string != null) {
            try {
                String string2 = String.valueOf(uRL.toExternalForm()) + "!/" + string;
                this.contentURL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    public String getAbsolutePath() {
        if (this.getFile() != null) {
            try {
                return XML.forwardSlash(this.getFile().getCanonicalPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return this.getFile().getAbsolutePath();
            }
        }
        if (this.getURL() != null) {
            String string = this.getURL().toExternalForm();
            return string;
        }
        return null;
    }

    public URL getURL() {
        if (this.url == null && this.file != null) {
            String string = this.getAbsolutePath();
            try {
                this.url = string.startsWith("/") ? new URL("file:" + string) : new URL("file:/" + string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        if (this.contentURL != null) {
            return this.contentURL;
        }
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public Object getObject(Class<?> clazz) {
        if (ImageIcon.class.equals(clazz)) {
            return this.getIcon();
        }
        if (String.class.equals(clazz)) {
            return this.getString();
        }
        return null;
    }

    public InputStream openInputStream() {
        if (this.getFile() != null) {
            try {
                return new FileInputStream(this.getFile());
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        if (this.url != null) {
            try {
                if (this.zipContent != null) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.url.openStream());
                    ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
                    ZipEntry zipEntry = null;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        String string;
                        if (zipEntry.isDirectory() || !this.zipContent.contains(string = zipEntry.getName())) continue;
                        return zipInputStream;
                    }
                }
                return this.getURL().openStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public BufferedReader openReader() {
        return this.openReader(defaultCharset);
    }

    public BufferedReader openReader(Charset charset) {
        InputStream inputStream = this.openInputStream();
        if (inputStream == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(inputStream, charset));
    }

    public ImageIcon getIcon() {
        if (this.icon == null && this.isAnImage) {
            this.icon = new ImageIcon(this.getURL());
            if (this.icon.getIconWidth() < 1) {
                this.icon = null;
                this.isAnImage = false;
            }
        }
        return this.icon;
    }

    public Image getImage() {
        ImageIcon imageIcon = this.getIcon();
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }

    public BufferedImage getBufferedImage() {
        return this.getBufferedImage(1);
    }

    public BufferedImage getBufferedImage(int n) {
        if (this.isAnImage && (this.image == null || this.image.getType() != n)) {
            Image image = this.getImage();
            if (image == null) {
                this.isAnImage = false;
            } else {
                this.image = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
                Graphics2D graphics2D = this.image.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
            }
        }
        return this.image;
    }

    public String getString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                BufferedReader bufferedReader = new BufferedReader(this.openReader());
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuffer.append(String.valueOf(string) + XML.NEW_LINE);
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public String getString(String string) {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                Charset charset = Charset.forName(string);
                BufferedReader bufferedReader = new BufferedReader(this.openReader(charset));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuffer.append(String.valueOf(string2) + XML.NEW_LINE);
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public AudioClip getAudioClip() {
        if (this.clip == null && this.getURL() != null) {
            this.clip = Applet.newAudioClip(this.getURL());
        }
        return this.clip;
    }
}

