/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.numerics.PolynomialLeastSquareFit;
import org.opensourcephysics.tools.KnownFunction;

public class KnownPolynomial
extends PolynomialLeastSquareFit
implements KnownFunction {
    String[] paramNames = new String[]{"A", "B", "C", "D", "E", "F"};

    KnownPolynomial(double[] dArray, double[] dArray2, int n) {
        super(dArray, dArray2, n);
    }

    KnownPolynomial(double[] dArray) {
        super(dArray);
    }

    public int getParameterCount() {
        return this.coefficients.length;
    }

    public String getParameterName(int n) {
        return this.paramNames[n];
    }

    public double getParameterValue(int n) {
        return this.coefficients[this.coefficients.length - n - 1];
    }

    public void setParameterValue(int n, double d) {
        this.coefficients[this.coefficients.length - n - 1] = d;
    }

    public String getExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.coefficients.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(this.getParameterName(n2));
            if (n - n2 > 0) {
                stringBuffer.append("*");
                stringBuffer.append(string);
                if (n - n2 > 1) {
                    stringBuffer.append("^");
                    stringBuffer.append(n - n2);
                }
                stringBuffer.append(" + ");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return "Poly" + (this.getParameterCount() - 1);
    }
}

