/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractExplicitRKSolverInterpolator;

public class RK4
extends AbstractExplicitRKSolverInterpolator {
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;

    public RK4(ODE _ode) {
        this.ode = _ode;
    }

    @Override
    protected void allocateOtherArrays() {
        this.rate2 = new double[this.dimension];
        this.rate3 = new double[this.dimension];
        this.rate4 = new double[this.dimension];
    }

    @Override
    protected int getNumberOfEvaluations() {
        return 4;
    }

    @Override
    protected double[] computeIntermediateStep(double _step, double[] _state) {
        int i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * this.initialRate[i] / 2.0;
            ++i;
        }
        this.ode.getRate(_state, this.rate2);
        i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * this.rate2[i] / 2.0;
            ++i;
        }
        this.ode.getRate(_state, this.rate3);
        i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * this.rate3[i];
            ++i;
        }
        this.ode.getRate(_state, this.rate4);
        i = 0;
        while (i < this.dimension) {
            _state[i] = this.initialState[i] + _step * (this.initialRate[i] + 2.0 * this.rate2[i] + 2.0 * this.rate3[i] + this.rate4[i]) / 6.0;
            ++i;
        }
        return _state;
    }

    @Override
    public double[] interpolate(double _time, boolean useLeftApproximation, double[] _state) {
        return super.interpolateBootstrap1(_time, _state);
    }
}

