/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.numerics.GeneralStateEvent;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.numerics.ODEEventSolver;
import org.opensourcephysics.numerics.ODESolverException;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.numerics.ZenoEffectListener;

public class ODEInterpolatorEventSolver
implements ODEEventSolver,
ODEAdaptiveSolver {
    public static final int INTERNAL_SOLVER_ERROR = 101;
    public static final int EVENT_NOT_FOUND = 102;
    public static final int ILLEGAL_EVENT_STATE = 103;
    public static final int ZENO_EFFECT = 104;
    public static final int TOO_MANY_STEPS_ERROR = 105;
    private boolean enableExceptions = true;
    protected boolean useBestInterpolation = false;
    private double stepSize = 0.1;
    private double absoluteTolerance = Double.NaN;
    private double relativeTolerance = Double.NaN;
    private double maxEventStep = Double.POSITIVE_INFINITY;
    private int zenoMaximumAllowedTimes = 500;
    private double proximityThreshold = 9.9E-324;
    private boolean coalesceCloseEvents = true;
    private int maxInternalSteps = 10000;
    private boolean runsForwards = this.stepSize > 0.0;
    private int dimension;
    private int timeIndex;
    private int errorCode = 0;
    private String errorMessage = "No error";
    private int numberOfAttempts = 0;
    private double[] test_ode_state;
    private double[] intermediate_ode_state;
    protected ODESolverInterpolator interpolatorSolver;
    private List<EventData> eventList = new ArrayList<EventData>();
    private List<EventData> happened = new ArrayList<EventData>();
    private List<EventData> temp_list = new ArrayList<EventData>();
    private double lastEventDataTime = Double.NaN;
    private EventData lastEventData = null;
    private EventData currentEventData = null;
    private int zenoCounter = 0;
    private List<ZenoEffectListener> zenoList = new ArrayList<ZenoEffectListener>();

    public ODEInterpolatorEventSolver(ODESolverInterpolator solver) {
        this.interpolatorSolver = solver;
    }

    public ODESolverInterpolator getSolver() {
        return this.interpolatorSolver;
    }

    public void setEnableExceptions(boolean enable) {
        this.enableExceptions = enable;
    }

    public void setEstimateFirstStep(boolean _estimate) {
        this.interpolatorSolver.setEstimateFirstStep(_estimate);
    }

    public void setBestInterpolation(boolean _best) {
        this.useBestInterpolation = _best;
    }

    public void setMaximumInternalSteps(int _steps) {
        this.maxInternalSteps = _steps;
    }

    public void setInternalStepSize(double _stepSize) {
        this.interpolatorSolver.setStepSize(this.runsForwards ? Math.abs(_stepSize) : -Math.abs(_stepSize));
    }

    public void setMaximumInternalStepSize(double _stepSize) {
        this.interpolatorSolver.setMaximumStepSize(_stepSize);
    }

    public void setTolerances(double absTol, double relTol) {
        this.absoluteTolerance = absTol;
        this.relativeTolerance = relTol;
        this.interpolatorSolver.setTolerances(this.absoluteTolerance, this.relativeTolerance);
    }

    public int getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    public void userReinitialize() {
        this.currentEventData = null;
        this.reinitialize();
    }

    public void reinitialize() {
        double[] state = this.interpolatorSolver.getODE().getState();
        this.interpolatorSolver.reinitialize(state);
        this.errorCode = 0;
        this.errorMessage = "No error";
        for (EventData eventData : this.eventList) {
            eventData.reset(state);
        }
    }

    @Override
    public void setTolerance(double tol) {
        this.setTolerances(tol, 0.0);
    }

    @Override
    public double getTolerance() {
        return Math.max(this.absoluteTolerance, this.relativeTolerance);
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setMaximumEventStep(double _step) {
        this.maxEventStep = Math.abs(_step);
    }

    public double getMaximumEventStep() {
        return this.maxEventStep;
    }

    public void setCoalesceCloseEvents(boolean _coalesce) {
        this.coalesceCloseEvents = _coalesce;
    }

    public boolean isCoalesceCloseEvents() {
        return this.coalesceCloseEvents;
    }

    public void setEventProximityThreshold(double _threshold) {
        this.proximityThreshold = _threshold;
    }

    public double getEventProximityThreshold() {
        return this.proximityThreshold;
    }

    @Override
    public void addEvent(StateEvent event) {
        GeneralStateEvent generalEvent = event instanceof GeneralStateEvent ? (GeneralStateEvent)event : new GeneralStateEventAdapter(event);
        this.eventList.add(new EventData(generalEvent, this.interpolatorSolver.getODE().getState()));
    }

    @Override
    public void removeEvent(StateEvent event) {
        for (EventData data : this.eventList) {
            if (data.generalEvent instanceof GeneralStateEventAdapter) {
                if (((GeneralStateEventAdapter)data.generalEvent).getEvent() != event) continue;
                if (this.lastEventData == data) {
                    this.lastEventData = null;
                    this.zenoCounter = 0;
                }
                if (this.currentEventData == data) {
                    this.currentEventData = null;
                }
                this.eventList.remove(data);
                return;
            }
            if (data.generalEvent != event) continue;
            if (this.lastEventData == data) {
                this.lastEventData = null;
                this.zenoCounter = 0;
            }
            if (this.currentEventData == data) {
                this.currentEventData = null;
            }
            this.eventList.remove(data);
            return;
        }
    }

    public void removeAllEvents() {
        this.eventList.clear();
    }

    @Override
    public void initialize(double _stepSize) {
        this.stepSize = _stepSize;
        this.runsForwards = this.stepSize > 0.0;
        this.interpolatorSolver.initialize(this.stepSize);
        double[] state = this.interpolatorSolver.getODE().getState();
        this.dimension = state.length;
        this.timeIndex = this.dimension - 1;
        this.test_ode_state = new double[this.dimension];
        this.intermediate_ode_state = new double[this.dimension];
        this.errorCode = 0;
        this.errorMessage = "No error";
        this.zenoCounter = 0;
        this.lastEventData = null;
        this.currentEventData = null;
        for (EventData data : this.eventList) {
            data.reset(state);
        }
    }

    @Override
    public void setStepSize(double _stepSize) {
        if (this.stepSize == _stepSize) {
            return;
        }
        this.stepSize = _stepSize;
        this.runsForwards = this.stepSize > 0.0;
        this.setInternalStepSize(this.interpolatorSolver.getStepSize());
    }

    @Override
    public double getStepSize() {
        return this.stepSize;
    }

    @Override
    public double step() {
        if (this.eventList.isEmpty()) {
            return this.stepWithoutEvents();
        }
        return this.stepWithEvents();
    }

    public double maxStep() {
        if (this.eventList.isEmpty()) {
            return this.maxStepWithoutEvents();
        }
        return this.maxStepWithEvents();
    }

    public void setZenoEffectDetection(int _times) {
        this.zenoMaximumAllowedTimes = _times;
    }

    public int getZenoEffectDetection() {
        return this.zenoMaximumAllowedTimes;
    }

    public void addZenoEffectListener(ZenoEffectListener _listener) {
        this.zenoList.add(_listener);
    }

    public void removeZenoEffectListener(ZenoEffectListener _listener) {
        this.zenoList.remove(_listener);
    }

    public double getIndependentVariableValue() {
        return this.interpolatorSolver.getODE().getState()[this.timeIndex];
    }

    public void setZeroZenoCounter() {
        this.zenoCounter = 0;
    }

    protected final void doTheInterpolation(double _time, double[] _state) {
        if (this.useBestInterpolation) {
            this.interpolatorSolver.bestInterpolate(_time, _state);
        } else {
            this.interpolatorSolver.interpolate(_time, false, _state);
        }
    }

    private final double maxStepWithoutEvents() {
        double[] rate;
        double[] state = this.interpolatorSolver.getODE().getState();
        double tBegin = state[this.timeIndex];
        if (tBegin + (rate = this.interpolatorSolver.getCurrentRate())[this.timeIndex] == tBegin) {
            return 0.0;
        }
        double max_t = this.interpolatorSolver.getMaximumTime();
        if (Double.isNaN(max_t)) {
            return this.error(101, "Error when stepping the solver at " + state[this.timeIndex]);
        }
        if (tBegin == max_t && Double.isNaN(max_t = this.interpolatorSolver.internalStep())) {
            return this.error(101, "Error when stepping the solver at max step at " + state[this.timeIndex]);
        }
        this.doTheInterpolation(max_t, state);
        return max_t - tBegin;
    }

    /*
     * Unable to fully structure code
     */
    private double stepWithoutEvents() {
        block6: {
            state = this.interpolatorSolver.getODE().getState();
            tBegin = state[this.timeIndex];
            if (tBegin + (rate = this.interpolatorSolver.getCurrentRate())[this.timeIndex] == tBegin) {
                return 0.0;
            }
            tEnd = state[this.timeIndex] + this.stepSize;
            max_t = this.interpolatorSolver.getMaximumTime();
            if (Double.isNaN(max_t)) {
                return this.error(101, "Error when stepping the solver at " + state[this.timeIndex]);
            }
            counter = 0;
            if (!this.runsForwards) ** GOTO lbl25
            while (max_t < tEnd) {
                max_t = this.interpolatorSolver.internalStep();
                if (Double.isNaN(max_t)) {
                    return this.error(101, "Error when stepping the solver forwards at " + state[this.timeIndex]);
                }
                if (++counter <= this.maxInternalSteps) continue;
                initTime = state[this.timeIndex];
                currentTime = this.interpolatorSolver.bestInterpolate(tEnd, new double[this.dimension])[this.timeIndex];
                return this.error(105, "The solver exceeded the maximum of " + this.maxInternalSteps + " internal steps\nat " + currentTime + ", starting from " + initTime + " for an step of " + this.stepSize);
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                max_t = this.interpolatorSolver.internalStep();
                if (Double.isNaN(max_t)) {
                    return this.error(101, "Error when stepping the solver backwards at " + state[this.timeIndex]);
                }
                if (++counter <= this.maxInternalSteps) continue;
                return this.error(105, "The solver exceeded the number of internal steps at " + state[this.timeIndex]);
lbl25:
                // 2 sources

                ** while (max_t > tEnd)
            }
        }
        this.doTheInterpolation(tEnd, state);
        return this.stepSize;
    }

    private final double maxStepWithEvents() {
        EventData eventData;
        double[] state = this.interpolatorSolver.getODE().getState();
        if (this.zenoMaximumAllowedTimes > 0 && this.zenoCounter > this.zenoMaximumAllowedTimes && this.callZenoAction(state)) {
            return 0.0;
        }
        double tBegin = state[this.timeIndex];
        double[] rate = this.interpolatorSolver.getCurrentRate();
        if (tBegin + rate[this.timeIndex] == tBegin) {
            return 0.0;
        }
        double max_t = this.interpolatorSolver.getMaximumTime();
        if (Double.isNaN(max_t)) {
            return this.error(101, "Error when stepping the solver at " + state[this.timeIndex]);
        }
        if (tBegin == max_t && Double.isNaN(max_t = this.interpolatorSolver.internalStep())) {
            return this.error(101, "Error when stepping the solver forwards at " + state[this.timeIndex]);
        }
        if (this.lastEventData != null && !Double.isNaN(this.lastEventData.maxAdvance)) {
            max_t = this.runsForwards ? Math.min(max_t, this.lastEventData.maxAdvance) : Math.max(max_t, this.lastEventData.maxAdvance);
        }
        double tTest = this.runsForwards ? Math.min(tBegin + this.maxEventStep, max_t) : Math.max(tBegin - this.maxEventStep, max_t);
        while (true) {
            eventData = null;
            this.currentEventData = null;
            this.doTheInterpolation(tTest, this.test_ode_state);
            eventData = this.findFirstEvent(state, tTest, this.test_ode_state);
            if (eventData != null) break;
            if (tTest == max_t) {
                System.arraycopy(this.test_ode_state, 0, state, 0, this.dimension);
                for (EventData evtDat : this.eventList) {
                    evtDat.findPosition(state[this.timeIndex], evtDat.h);
                }
                return max_t - tBegin;
            }
            tTest = this.runsForwards ? Math.min(tTest + this.maxEventStep, max_t) : Math.max(tTest - this.maxEventStep, max_t);
        }
        this.currentEventData = eventData;
        if (this.useBestInterpolation) {
            this.interpolatorSolver.bestInterpolate(eventData.time, state);
        } else {
            System.arraycopy(this.test_ode_state, 0, state, 0, this.dimension);
        }
        double timeBefore = state[this.timeIndex];
        eventData.generalEvent.action();
        this.reinitialize();
        state = this.interpolatorSolver.getODE().getState();
        if (timeBefore != state[this.timeIndex]) {
            this.zenoCounter = 0;
            this.lastEventData = null;
            this.currentEventData = null;
            eventData.reset(state);
            return eventData.time - tBegin;
        }
        if (this.lastEventData != null) {
            this.zenoCounter = Math.abs(this.lastEventDataTime - eventData.time) < this.proximityThreshold ? ++this.zenoCounter : 0;
        }
        this.lastEventData = eventData;
        this.lastEventDataTime = eventData.time;
        return eventData.time - tBegin;
    }

    private double stepWithEvents() {
        double[] state = this.interpolatorSolver.getODE().getState();
        if (this.zenoMaximumAllowedTimes > 0 && this.zenoCounter > this.zenoMaximumAllowedTimes && this.callZenoAction(state)) {
            return 0.0;
        }
        double tBegin = state[this.timeIndex];
        double[] rate = this.interpolatorSolver.getCurrentRate();
        if (tBegin + rate[this.timeIndex] == tBegin) {
            return 0.0;
        }
        double tEnd = tBegin + this.stepSize;
        double max_t = this.interpolatorSolver.getMaximumTime();
        if (Double.isNaN(max_t)) {
            return this.error(101, "Error when stepping the solver at " + state[this.timeIndex]);
        }
        double tTest = this.runsForwards ? Math.min(tBegin + this.maxEventStep, tEnd) : Math.max(tBegin - this.maxEventStep, tEnd);
        int counter = 0;
        while (true) {
            boolean notYetThere;
            EventData eventData = null;
            this.currentEventData = null;
            boolean bl = this.runsForwards ? max_t < tTest : (notYetThere = max_t > tTest);
            if (notYetThere) {
                this.interpolatorSolver.bestInterpolate(max_t, this.test_ode_state);
                eventData = this.findFirstEvent(state, max_t, this.test_ode_state);
                if (eventData == null) {
                    System.arraycopy(this.test_ode_state, 0, state, 0, this.dimension);
                    for (EventData evtDat : this.eventList) {
                        evtDat.findPosition(state[this.timeIndex], evtDat.h);
                    }
                    max_t = this.interpolatorSolver.internalStep();
                    if (Double.isNaN(max_t)) {
                        return this.error(101, "Error when stepping the solver looking for an event at " + state[this.timeIndex]);
                    }
                    if (++counter <= this.maxInternalSteps) continue;
                    return this.error(105, "The solver exceeded the number of internal steps at " + state[this.timeIndex]);
                }
            } else {
                this.doTheInterpolation(tTest, this.test_ode_state);
                eventData = this.findFirstEvent(state, tTest, this.test_ode_state);
                if (eventData == null) {
                    if (tTest == tEnd) {
                        System.arraycopy(this.test_ode_state, 0, state, 0, this.dimension);
                        for (EventData evtDat : this.eventList) {
                            evtDat.findPosition(state[this.timeIndex], evtDat.h);
                        }
                        return tEnd - tBegin;
                    }
                    tTest = this.runsForwards ? Math.min(tTest + this.maxEventStep, tEnd) : Math.max(tTest - this.maxEventStep, tEnd);
                    continue;
                }
            }
            this.currentEventData = eventData;
            if (this.useBestInterpolation) {
                this.interpolatorSolver.bestInterpolate(eventData.time, state);
            } else {
                System.arraycopy(this.test_ode_state, 0, state, 0, this.dimension);
            }
            double timeBefore = state[this.timeIndex];
            boolean wantsToQuit = eventData.generalEvent.action();
            this.reinitialize();
            counter = 0;
            state = this.interpolatorSolver.getODE().getState();
            if (timeBefore != state[this.timeIndex]) {
                this.zenoCounter = 0;
                this.lastEventData = null;
                this.currentEventData = null;
                eventData.reset(state);
                return eventData.time - tBegin;
            }
            if (this.lastEventData != null) {
                if (Math.abs(this.lastEventDataTime - eventData.time) < this.proximityThreshold) {
                    ++this.zenoCounter;
                    if (this.coalesceCloseEvents) {
                        wantsToQuit = false;
                    }
                } else {
                    this.zenoCounter = 0;
                }
            }
            this.lastEventData = eventData;
            this.lastEventDataTime = eventData.time;
            if (wantsToQuit) {
                return eventData.time - tBegin;
            }
            if (this.zenoMaximumAllowedTimes > 0 && this.zenoCounter > this.zenoMaximumAllowedTimes && this.callZenoAction(state)) {
                return eventData.time - tBegin;
            }
            max_t = this.interpolatorSolver.getMaximumTime();
            if (!Double.isNaN(eventData.maxAdvance)) {
                double d = max_t = this.runsForwards ? Math.min(max_t, eventData.maxAdvance) : Math.max(max_t, eventData.maxAdvance);
            }
            if (Double.isNaN(max_t)) break;
        }
        return this.error(101, "Error when stepping the solver after an event at " + state[this.timeIndex]);
    }

    private boolean callZenoAction(double[] _state) {
        if (this.zenoList.isEmpty()) {
            this.error(104, "A Zeno-like effect has been detected.\nLast event was " + this.lastEventData.generalEvent + " which took place at " + this.lastEventDataTime);
            return true;
        }
        boolean returnAtZeno = false;
        for (ZenoEffectListener listener : this.zenoList) {
            if (!listener.zenoEffectAction(this.lastEventData.generalEvent, _state)) continue;
            returnAtZeno = true;
        }
        this.zenoCounter = 0;
        return returnAtZeno;
    }

    private EventData findFirstEvent(double[] current_state, double tFinal, double[] final_state) {
        this.numberOfAttempts = 0;
        EventData happensAtT1 = this.happensRightNow(current_state[this.timeIndex], final_state, this.happened, "at t1");
        if (happensAtT1 != null) {
            happensAtT1.time = current_state[this.timeIndex];
            happensAtT1.maxAdvance = tFinal;
            System.arraycopy(current_state, 0, final_state, 0, this.dimension);
            return happensAtT1;
        }
        if (this.happened.isEmpty()) {
            return null;
        }
        boolean doItAgain = true;
        for (EventData eventData : this.eventList) {
            eventData.hAfter = eventData.h;
        }
        block1: while (doItAgain) {
            ++this.numberOfAttempts;
            double tTest = this.nextPointToCheck(this.happened, current_state[this.timeIndex], tFinal);
            this.doTheInterpolation(tTest, this.intermediate_ode_state);
            EventData shortDurationEvent = this.happensRightNow(current_state[this.timeIndex], this.intermediate_ode_state, this.temp_list, "short");
            if (shortDurationEvent != null) {
                shortDurationEvent.time = current_state[this.timeIndex];
                shortDurationEvent.maxAdvance = tTest;
                System.arraycopy(current_state, 0, final_state, 0, this.dimension);
                return shortDurationEvent;
            }
            if (this.temp_list.isEmpty()) {
                EventData happensInTtest = null;
                for (EventData eventData : this.happened) {
                    if (eventData.currentPosition == 2) {
                        if (!(eventData.h < eventData.generalEvent.getTolerance())) continue;
                        happensInTtest = eventData;
                        break;
                    }
                    if (!(eventData.h > -eventData.generalEvent.getTolerance())) continue;
                    happensInTtest = eventData;
                    break;
                }
                if (happensInTtest != null) {
                    happensInTtest.time = tTest;
                    happensInTtest.maxAdvance = tFinal;
                    System.arraycopy(this.intermediate_ode_state, 0, final_state, 0, this.dimension);
                    return happensInTtest;
                }
                System.arraycopy(this.intermediate_ode_state, 0, current_state, 0, this.dimension);
                for (EventData eventData : this.eventList) {
                    eventData.findPosition(current_state[this.timeIndex], eventData.h);
                }
                EventData happensNowInTtest = this.happensRightNow(current_state[this.timeIndex], final_state, this.happened, "at tTest");
                if (happensNowInTtest != null) {
                    happensNowInTtest.time = current_state[this.timeIndex];
                    happensNowInTtest.maxAdvance = tFinal;
                    System.arraycopy(current_state, 0, final_state, 0, this.dimension);
                    return happensNowInTtest;
                }
            } else {
                boolean notPreviousFound = true;
                EventData happensInTtest = null;
                for (EventData data : this.temp_list) {
                    if (data.currentPosition == 2) {
                        if (data.h <= -data.generalEvent.getTolerance()) {
                            notPreviousFound = false;
                            break;
                        }
                        happensInTtest = data;
                        continue;
                    }
                    if (data.h >= data.generalEvent.getTolerance()) {
                        notPreviousFound = false;
                        break;
                    }
                    happensInTtest = data;
                }
                if (notPreviousFound && happensInTtest != null) {
                    happensInTtest.time = tTest;
                    happensInTtest.maxAdvance = tFinal;
                    System.arraycopy(this.intermediate_ode_state, 0, final_state, 0, this.dimension);
                    return happensInTtest;
                }
                tFinal = tTest;
                System.arraycopy(this.intermediate_ode_state, 0, final_state, 0, this.dimension);
                for (EventData eventData : this.eventList) {
                    eventData.hAfter = eventData.h;
                }
                this.happened.clear();
                this.happened.addAll(this.temp_list);
            }
            for (EventData data : this.happened) {
                if (this.numberOfAttempts <= data.generalEvent.getMaxIterations()) continue;
                doItAgain = false;
                continue block1;
            }
        }
        EventData remaining = this.happened.get(0);
        this.error(102, "Warning : Event not found after " + this.numberOfAttempts + " attempts at t=" + current_state[this.timeIndex] + " h = " + remaining.h + ".\nPlease check the code of your event, decrease the initial step size, the tolerance of the solver," + "\nor the event maximum step, or increase the maximum number of attempts." + "\nFirst event remaining in the queue: " + remaining.generalEvent);
        remaining.time = (current_state[this.timeIndex] + tFinal) / 2.0;
        remaining.maxAdvance = Double.NaN;
        this.interpolatorSolver.bestInterpolate(remaining.time, final_state);
        return remaining;
    }

    private EventData happensRightNow(double currentTime, double[] final_state, List<EventData> list, String id) {
        list.clear();
        block6: for (EventData eventData : this.eventList) {
            eventData.h = eventData.generalEvent.evaluate(final_state);
            switch (eventData.currentPosition) {
                default: {
                    if (!(eventData.h <= 0.0)) continue block6;
                    list.add(eventData);
                    break;
                }
                case 1: {
                    if (!(eventData.h <= 0.0) || !eventData.positiveFlag && eventData.eventType != 0) continue block6;
                    return eventData;
                }
                case 0: {
                    if (!(eventData.h < 0.0 ? eventData.positiveFlag || eventData.eventType == 0 : eventData.h > 0.0 && eventData.negativeFlag && eventData.eventType == 2)) continue block6;
                    return eventData;
                }
                case -1: {
                    if (!(eventData.eventType == 0 ? eventData.h <= -eventData.generalEvent.getTolerance() : eventData.eventType == 2 && eventData.negativeFlag && eventData.h >= 0.0)) continue block6;
                    return eventData;
                }
                case -2: {
                    if (eventData.eventType == 2) {
                        if (!(eventData.h >= 0.0)) continue block6;
                        list.add(eventData);
                        break;
                    }
                    if (eventData.eventType != 0) continue block6;
                    this.error(103, "The system started from an illegal state at " + currentTime + " for the state event " + eventData.generalEvent);
                    return eventData;
                }
            }
        }
        return null;
    }

    private double nextPointToCheck(List<EventData> list, double t1, double t2) {
        double tFirst = t2;
        double dt = t2 - t1;
        double tMiddle = (t1 + t2) / 2.0;
        if (this.runsForwards) {
            for (EventData eventData : list) {
                switch (eventData.generalEvent.getRootFindingMethod()) {
                    default: {
                        tFirst = Math.min(tFirst, tMiddle);
                        break;
                    }
                    case 1: {
                        tFirst = Math.min(tFirst, t1 - eventData.hBefore * dt / (eventData.hAfter - eventData.hBefore));
                    }
                }
            }
        } else {
            for (EventData eventData : list) {
                switch (eventData.generalEvent.getRootFindingMethod()) {
                    default: {
                        tFirst = Math.max(tFirst, tMiddle);
                        break;
                    }
                    case 1: {
                        tFirst = Math.max(tFirst, t1 - eventData.hBefore * dt / (eventData.hAfter - eventData.hBefore));
                    }
                }
            }
        }
        return tFirst;
    }

    private double error(int code, String msg) {
        this.errorCode = code;
        this.errorMessage = msg;
        if (this.enableExceptions) {
            throw new ODESolverException(this.interpolatorSolver + ":\n" + msg);
        }
        OSPLog.warning(msg);
        return Double.NaN;
    }

    private class EventData {
        protected static final int POSITIVE = 2;
        protected static final int SMALL_POSITIVE = 1;
        protected static final int ZERO = 0;
        protected static final int SMALL_NEGATIVE = -1;
        protected static final int NEGATIVE = -2;
        GeneralStateEvent generalEvent;
        boolean positiveFlag;
        boolean negativeFlag;
        final int eventType;
        int currentPosition;
        double hBefore;
        double hAfter;
        double h;
        double time;
        double maxAdvance;

        EventData(GeneralStateEvent _event, double[] state) {
            this.generalEvent = _event;
            this.eventType = this.generalEvent.getTypeOfEvent();
            this.reset(state);
        }

        void reset(double[] state) {
            this.negativeFlag = false;
            this.positiveFlag = false;
            double h = this.generalEvent.evaluate(state);
            this.findPosition(state[ODEInterpolatorEventSolver.this.timeIndex], h);
            if (ODEInterpolatorEventSolver.this.currentEventData != this) {
                if (this.eventType == 2) {
                    if (h > 0.0) {
                        this.positiveFlag = true;
                    } else if (h < 0.0) {
                        this.negativeFlag = true;
                    }
                } else if (this.eventType == 1 && h > 0.0) {
                    this.positiveFlag = true;
                }
            }
        }

        private void findPosition(double _time, double hValue) {
            this.hBefore = hValue;
            if (this.hBefore >= this.generalEvent.getTolerance()) {
                this.currentPosition = 2;
                this.positiveFlag = true;
            } else if (this.hBefore > 0.0) {
                this.currentPosition = 1;
            } else if (this.hBefore == 0.0) {
                this.currentPosition = 0;
            } else if (this.hBefore > -this.generalEvent.getTolerance()) {
                this.currentPosition = -1;
            } else {
                this.currentPosition = -2;
                this.negativeFlag = true;
            }
            if (this.eventType == 0 && this.currentPosition == -2) {
                String msg = "The state event " + this.generalEvent + " is in an illegal state: " + this.hBefore + " at " + _time;
                msg = ODEInterpolatorEventSolver.this.lastEventData == null ? String.valueOf(msg) + "\nThere was no previous event" : String.valueOf(msg) + "\nLast previous event was " + ((ODEInterpolatorEventSolver)ODEInterpolatorEventSolver.this).lastEventData.generalEvent + ", which took place at " + ODEInterpolatorEventSolver.this.lastEventDataTime;
                ODEInterpolatorEventSolver.this.error(103, msg);
            }
        }
    }

    private class GeneralStateEventAdapter
    implements GeneralStateEvent {
        private StateEvent event;

        public GeneralStateEventAdapter(StateEvent _event) {
            this.event = _event;
        }

        public StateEvent getEvent() {
            return this.event;
        }

        @Override
        public int getTypeOfEvent() {
            return 0;
        }

        @Override
        public int getMaxIterations() {
            return 100;
        }

        @Override
        public int getRootFindingMethod() {
            return 0;
        }

        @Override
        public double getTolerance() {
            return this.event.getTolerance();
        }

        @Override
        public double evaluate(double[] state) {
            return this.event.evaluate(state);
        }

        @Override
        public boolean action() {
            return this.event.action();
        }
    }
}

