/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.utils.mapping.Mapping;
import org.opensourcephysics.drawing3d.utils.mapping.MappingXYZ;
import org.opensourcephysics.drawing3d.utils.mapping.MappingXZY;
import org.opensourcephysics.drawing3d.utils.mapping.MappingYXZ;
import org.opensourcephysics.drawing3d.utils.mapping.MappingYZX;
import org.opensourcephysics.drawing3d.utils.mapping.MappingZXY;
import org.opensourcephysics.drawing3d.utils.mapping.MappingZYX;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.Transformation;
import org.opensourcephysics.numerics.VectorMath;

public class Camera {
    public static final int MODE_PLANAR_XY = 0;
    public static final int MODE_PLANAR_XZ = 1;
    public static final int MODE_PLANAR_YZ = 2;
    public static final int MODE_PERSPECTIVE_OFF = 3;
    public static final int MODE_PERSPECTIVE_ON = 4;
    public static final int MODE_NO_PERSPECTIVE = 10;
    public static final int MODE_PERSPECTIVE = 11;
    private static final double RATIO_TO_SCREEN = 2.5;
    private static final double RATIO_TO_FOCUS = 2.0;
    private static final double[] VERTICAL_AXIS = new double[]{0.0, 0.0, 1.0};
    public static final int CHANGE_ANY = 0;
    public static final int CHANGE_MODE = 1;
    public static final int CHANGE_POSITION = 2;
    public static final int CHANGE_FOCUS = 3;
    public static final int CHANGE_ROTATION = 4;
    public static final int CHANGE_SCREEN = 5;
    public static final int CHANGE_ANGLES = 6;
    public static final int CHANGE_MAPPING = 7;
    private int projectionMode = 4;
    private double posX = 4.0;
    private double posY = 0.0;
    private double posZ = 0.0;
    private double focusX = 0.0;
    private double focusY = 0.0;
    private double focusZ = 0.0;
    private double distanceToScreen;
    private double rotationAngle = 0.0;
    private double alpha = 0.0;
    private double beta = 0.0;
    private int mapType = 0;
    private double distanceToFocus;
    private double panelMaxSizeConstant;
    private double planarRatio;
    double cosAlpha = 1.0;
    double sinAlpha = 0.0;
    double cosBeta = 1.0;
    double sinBeta = 0.0;
    private double cosRot = 1.0;
    private double sinRot = 0.0;
    private double[] e1 = new double[]{-1.0, 0.0, 0.0};
    private double[] e2 = new double[]{0.0, 1.0, 0.0};
    private double[] e3 = new double[]{0.0, 0.0, 1.0};
    private Projection projection = new Projection();
    private Quaternion rotation = new Quaternion(1.0, 0.0, 0.0, 0.0);
    private Mapping mapping = new MappingXYZ();
    private DrawingPanel3D panel;

    public Camera(DrawingPanel3D aPanel) {
        this.panel = aPanel;
    }

    public void setProjectionMode(int mode) {
        this.projectionMode = mode;
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize() * 0.01;
        this.panel.cameraChanged(1);
    }

    public final int getProjectionMode() {
        return this.projectionMode;
    }

    public void reset() {
        double[] center = this.panel.getCenter();
        if (this.is3dMode()) {
            this.mapping.map(center);
        }
        this.focusX = center[0];
        this.focusY = center[1];
        this.focusZ = center[2];
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize();
        this.rotationAngle = 0.0;
        this.cosRot = 1.0;
        this.sinRot = 0.0;
        this.distanceToScreen = 2.5 * this.panelMaxSizeConstant;
        this.distanceToFocus = 2.0 * this.panelMaxSizeConstant;
        this.planarRatio = this.distanceToScreen / this.distanceToFocus;
        this.posX = center[0] + this.distanceToFocus;
        this.posY = center[1];
        this.posZ = center[2];
        this.alpha = 0.0;
        this.cosAlpha = 1.0;
        this.sinAlpha = 0.0;
        this.beta = 0.0;
        this.cosBeta = 1.0;
        this.sinBeta = 0.0;
        this.e1 = new double[]{-1.0, 0.0, 0.0};
        this.e2 = new double[]{0.0, 1.0, 0.0};
        this.e3 = new double[]{0.0, 0.0, 1.0};
        this.panelMaxSizeConstant *= 0.01;
        this.panel.cameraChanged(0);
    }

    public void adjust() {
        double[] center = this.panel.getCenter();
        if (this.is3dMode()) {
            this.mapping.map(center);
        }
        this.focusX = center[0];
        this.focusY = center[1];
        this.focusZ = center[2];
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize();
        this.distanceToScreen = 2.5 * this.panelMaxSizeConstant;
        this.distanceToFocus = 2.0 * this.panelMaxSizeConstant;
        this.planarRatio = this.distanceToScreen / this.distanceToFocus;
        this.panelMaxSizeConstant *= 0.01;
        this.updateCamera(6);
    }

    public void setMapping(int mappingType) {
        if (this.mapType == mappingType) {
            return;
        }
        this.mapType = mappingType;
        switch (mappingType) {
            default: {
                this.mapping = new MappingXYZ();
                break;
            }
            case 1: {
                this.mapping = new MappingXZY();
                break;
            }
            case 2: {
                this.mapping = new MappingYXZ();
                break;
            }
            case 3: {
                this.mapping = new MappingYZX();
                break;
            }
            case 4: {
                this.mapping = new MappingZXY();
                break;
            }
            case 5: {
                this.mapping = new MappingZYX();
            }
        }
        if (this.panel.getResetCameraOnChanges()) {
            this.adjust();
        }
        this.panel.cameraChanged(7);
    }

    public double[] map(double[] point) {
        return this.mapping.map(point);
    }

    public double[] inverseMapping(double[] point) {
        return this.mapping.inverse(point);
    }

    public double[] getQuatMapping() {
        return this.mapping.quatForPrimitives();
    }

    public void setXYZ(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.updateCamera(2);
    }

    public void setXYZ(double[] point) {
        this.setXYZ(point[0], point[1], point[2]);
    }

    public final double getX() {
        return this.posX;
    }

    public final double getY() {
        return this.posY;
    }

    public final double getZ() {
        return this.posZ;
    }

    public void setFocusXYZ(double x, double y, double z) {
        this.focusX = x;
        this.focusY = y;
        this.focusZ = z;
        this.updateCamera(3);
    }

    public void setFocusXYZ(double[] point) {
        this.setFocusXYZ(point[0], point[1], point[2]);
    }

    public final double getFocusX() {
        return this.focusX;
    }

    public final double getFocusY() {
        return this.focusY;
    }

    public final double getFocusZ() {
        return this.focusZ;
    }

    public final double getDistanceToFocus() {
        return this.distanceToFocus;
    }

    public void setRotation(double angle) {
        this.rotationAngle = angle;
        this.cosRot = Math.cos(this.rotationAngle / 2.0);
        this.sinRot = Math.sin(this.rotationAngle / 2.0);
        this.updateCamera(4);
    }

    public final double getRotation() {
        return this.rotationAngle;
    }

    public void setDistanceToScreen(double distance) {
        this.distanceToScreen = distance;
        this.planarRatio = this.distanceToScreen / this.distanceToFocus;
        this.panel.cameraChanged(5);
    }

    public final double getDistanceToScreen() {
        return this.distanceToScreen;
    }

    public void setAzimuth(double angle) {
        this.alpha = angle;
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.updateCamera(6);
    }

    public final double getAzimuth() {
        return this.alpha;
    }

    public void setAltitude(double angle) {
        this.beta = angle;
        if (this.beta < -1.5707963267948966) {
            this.beta = -1.5707963267948966;
        } else if (this.beta > 1.5707963267948966) {
            this.beta = 1.5707963267948966;
        }
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.updateCamera(6);
    }

    public final double getAltitude() {
        return this.beta;
    }

    public void setAzimuthAndAltitude(double azimuth, double altitude) {
        this.alpha = azimuth;
        this.beta = altitude;
        if (this.beta < -1.5707963267948966) {
            this.beta = -1.5707963267948966;
        } else if (this.beta > 1.5707963267948966) {
            this.beta = 1.5707963267948966;
        }
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.updateCamera(6);
    }

    public void copyFrom(Camera camera) {
        this.projectionMode = camera.getProjectionMode();
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize() * 0.01;
        this.posX = camera.getX();
        this.posY = camera.getY();
        this.posZ = camera.getZ();
        this.focusX = camera.getFocusX();
        this.focusY = camera.getFocusY();
        this.focusZ = camera.getFocusZ();
        this.rotationAngle = camera.getRotation();
        this.cosRot = Math.cos(this.rotationAngle / 2.0);
        this.sinRot = Math.sin(this.rotationAngle / 2.0);
        this.distanceToScreen = camera.getDistanceToScreen();
        this.planarRatio = this.distanceToScreen / this.distanceToFocus;
        this.updateCamera(0);
    }

    public final double getCosAlpha() {
        return this.cosAlpha;
    }

    public final double getSinAlpha() {
        return this.sinAlpha;
    }

    public final double getCosBeta() {
        return this.cosBeta;
    }

    public final double getSinBeta() {
        return this.sinBeta;
    }

    private void updateCamera(int change) {
        switch (change) {
            case 2: 
            case 3: {
                this.distanceToFocus = this.computeCameraVectors();
                this.planarRatio = this.distanceToScreen / this.distanceToFocus;
                this.alpha = Math.atan2(-this.e1[1], -this.e1[0]);
                this.beta = Math.atan2(-this.e1[2], Math.abs(this.e1[0]));
                this.cosAlpha = Math.cos(this.alpha);
                this.sinAlpha = Math.sin(this.alpha);
                this.cosBeta = Math.cos(this.beta);
                this.sinBeta = Math.sin(this.beta);
                break;
            }
            case 4: {
                this.computeCameraVectors();
                break;
            }
            case 6: {
                this.posX = this.focusX + this.distanceToFocus * this.cosBeta * this.cosAlpha;
                this.posY = this.focusY + this.distanceToFocus * this.cosBeta * this.sinAlpha;
                this.posZ = this.focusZ + this.distanceToFocus * this.sinBeta;
                this.computeCameraVectors();
                break;
            }
            case 0: {
                this.distanceToFocus = this.computeCameraVectors();
                this.planarRatio = this.distanceToScreen / this.distanceToFocus;
                this.alpha = Math.atan2(-this.e1[1], -this.e1[0]);
                this.beta = Math.atan2(-this.e1[2], Math.abs(this.e1[0]));
                this.cosAlpha = Math.cos(this.alpha);
                this.sinAlpha = Math.sin(this.alpha);
                this.cosBeta = Math.cos(this.beta);
                this.sinBeta = Math.sin(this.beta);
                this.computeCameraVectors();
            }
        }
        this.panel.cameraChanged(change);
    }

    private double computeCameraVectors() {
        this.e1 = new double[]{this.focusX - this.posX, this.focusY - this.posY, this.focusZ - this.posZ};
        double magnitudeE1 = VectorMath.magnitude(this.e1);
        int i = 0;
        while (i < this.e1.length) {
            int n = i++;
            this.e1[n] = this.e1[n] / magnitudeE1;
        }
        this.e2 = VectorMath.cross3D(this.e1, VERTICAL_AXIS);
        double magnitude = VectorMath.magnitude(this.e2);
        int i2 = 0;
        while (i2 < this.e2.length) {
            int n = i2++;
            this.e2[n] = this.e2[n] / magnitude;
        }
        this.e3 = VectorMath.cross3D(this.e2, this.e1);
        magnitude = VectorMath.magnitude(this.e3);
        i2 = 0;
        while (i2 < this.e3.length) {
            int n = i2++;
            this.e3[n] = this.e3[n] / magnitude;
        }
        this.rotation.setCoordinates(this.cosRot, this.e1[0] * this.sinRot, this.e1[1] * this.sinRot, this.e1[2] * this.sinRot);
        this.rotation.direct(this.e2);
        this.rotation.direct(this.e3);
        return magnitudeE1;
    }

    public boolean is3dMode() {
        switch (this.projectionMode) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    public double[] projectPosition(double[] p) {
        return this.projection.direct(p);
    }

    public double[] projectSize(double[] p, double[] size) {
        switch (this.projectionMode) {
            case 0: {
                size[0] = size[0] * this.planarRatio;
                return size;
            }
            case 1: {
                size[0] = size[0] * this.planarRatio;
                size[1] = size[2] * this.planarRatio;
                return size;
            }
            case 2: {
                size[0] = size[1] * this.planarRatio;
                size[1] = size[2] * this.planarRatio;
                return size;
            }
            case 3: 
            case 10: {
                this.mapping.map(size);
                size[0] = Math.max(size[0], size[1]);
                size[1] = size[2];
                return size;
            }
        }
        this.mapping.map(p);
        this.mapping.map(size);
        double factor = (p[0] - this.posX) * this.e1[0] + (p[1] - this.posY) * this.e1[1] + (p[2] - this.posZ) * this.e1[2];
        if (Math.abs(factor) < this.panelMaxSizeConstant) {
            factor = this.panelMaxSizeConstant;
        }
        factor = this.distanceToScreen / factor;
        size[0] = Math.max(size[0], size[1]) * factor;
        size[1] = size[2] * factor;
        return size;
    }

    private class Projection
    implements Transformation {
        private Projection() {
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException exc) {
                exc.printStackTrace();
                return null;
            }
        }

        @Override
        public double[] direct(double[] p) {
            double factor;
            switch (Camera.this.projectionMode) {
                case 0: {
                    p[0] = (p[0] - Camera.this.focusX) * Camera.this.planarRatio;
                    p[1] = (p[1] - Camera.this.focusY) * Camera.this.planarRatio;
                    p[2] = 1.0 - (p[2] - Camera.this.focusZ) / Camera.this.distanceToFocus;
                    return p;
                }
                case 1: {
                    double aux = p[1];
                    p[0] = (p[0] - Camera.this.focusX) * Camera.this.planarRatio;
                    p[1] = (p[2] - Camera.this.focusZ) * Camera.this.planarRatio;
                    p[2] = 1.0 - (aux - Camera.this.focusY) / Camera.this.distanceToFocus;
                    return p;
                }
                case 2: {
                    double aux = p[0];
                    p[0] = (p[1] - Camera.this.focusY) * Camera.this.planarRatio;
                    p[1] = (p[2] - Camera.this.focusZ) * Camera.this.planarRatio;
                    p[2] = 1.0 - (aux - Camera.this.focusX) / Camera.this.distanceToFocus;
                    return p;
                }
                case 3: 
                case 10: {
                    Camera.this.mapping.map(p);
                    p[0] = p[0] - Camera.this.posX;
                    p[1] = p[1] - Camera.this.posY;
                    p[2] = p[2] - Camera.this.posZ;
                    double aux1 = VectorMath.dot(p, Camera.this.e1);
                    double aux2 = VectorMath.dot(p, Camera.this.e2);
                    p[1] = VectorMath.dot(p, Camera.this.e3);
                    p[0] = aux2;
                    p[2] = aux1 / Camera.this.distanceToFocus;
                    return p;
                }
            }
            Camera.this.mapping.map(p);
            p[0] = p[0] - Camera.this.posX;
            p[1] = p[1] - Camera.this.posY;
            p[2] = p[2] - Camera.this.posZ;
            double aux1 = factor = VectorMath.dot(p, Camera.this.e1);
            if (Math.abs(factor) < Camera.this.panelMaxSizeConstant) {
                factor = Camera.this.panelMaxSizeConstant;
            }
            factor = Camera.this.distanceToScreen / factor;
            double aux2 = VectorMath.dot(p, Camera.this.e2) * factor;
            p[1] = VectorMath.dot(p, Camera.this.e3) * factor;
            p[0] = aux2;
            p[2] = aux1 / Camera.this.distanceToFocus;
            return p;
        }

        @Override
        public double[] inverse(double[] point) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

