/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementShape;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementShape
extends SimpleElement {
    private double[] coordinates = new double[3];
    private double[] size = new double[3];
    private double[] pixel = new double[3];
    private RectangularShape shape;
    private Line2D line1;
    private Line2D line2;
    private Shape trShape;
    private Shape trLine1;
    private Shape trLine2;
    private AffineTransform transform = new AffineTransform();

    public SimpleElementShape(ElementShape _element) {
        super(_element);
        this.objects = new Object3D[]{new Object3D(this, 0)};
        this.recreateShape();
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        if ((_cummulativeChange & 8) != 0) {
            this.recreateShape();
            this.projectPointAndSize();
        } else if ((_cummulativeChange & 0x136) != 0 || (_cummulativeChange & 0x40) != 0) {
            this.projectPointAndSize();
        }
    }

    @Override
    public void styleChanged(int _change) {
        if (_change == 5) {
            this.element.addChange(8);
        } else {
            super.styleChanged(_change);
        }
    }

    @Override
    void draw(Graphics2D _g2, int _index) {
        DrawingPanel3D panel = this.element.getPanel();
        double d = this.objects[0].getDistance();
        this.drawIt(_g2, panel.projectColor(this.style.getLineColor(), d), panel.projectPaint(this.style.getFillColor(), d));
    }

    @Override
    void drawQuickly(Graphics2D _g2) {
        this.drawIt(_g2, this.style.getLineColor(), this.style.getFillColor());
    }

    private void projectPointAndSize() {
        ElementShape elementShape = (ElementShape)this.element;
        System.arraycopy(Element.STD_ORIGIN, 0, this.coordinates, 0, 3);
        this.element.sizeAndToSpaceFrame(this.coordinates);
        System.arraycopy(this.coordinates, 0, this.pixel, 0, 3);
        this.element.getPanel().projectPosition(this.pixel);
        this.objects[0].setDistance(this.pixel[2] * this.style.getDepthFactor());
        this.size[0] = this.element.getSizeX();
        this.size[1] = this.element.getSizeY();
        this.size[2] = this.element.getSizeZ();
        if (!elementShape.isPixelSize()) {
            this.element.getPanel().projectSize(this.coordinates, this.size);
        }
        this.transform.setToTranslation(this.pixel[0], this.pixel[1]);
        double angle = elementShape.getRotationAngle();
        if (angle != 0.0) {
            this.transform.rotate(-angle);
        }
        this.transform.scale(this.size[0], this.size[1]);
        this.trShape = this.transform.createTransformedShape(this.shape);
        this.trLine1 = this.transform.createTransformedShape(this.line1);
        this.trLine2 = this.transform.createTransformedShape(this.line2);
    }

    private void drawIt(Graphics2D _g2, Color _color, Paint _fill) {
        _g2.setStroke(this.style.getLineStroke());
        if (this.shape == null) {
            _g2.setColor(_color);
            _g2.drawOval((int)this.pixel[0], (int)this.pixel[1], 1, 1);
            return;
        }
        ElementShape elementShape = (ElementShape)this.element;
        if (this.style.isDrawingFill()) {
            _g2.setPaint(_fill);
            _g2.fill(this.trShape);
        }
        if (this.style.isDrawingLines()) {
            _g2.setColor(_color);
            if (elementShape.getShapeType() == 4) {
                _g2.draw(this.trLine1);
                _g2.draw(this.trLine2);
            }
            _g2.draw(this.trShape);
        }
    }

    private void recreateShape() {
        double y1;
        double x1;
        ElementShape elementShape = (ElementShape)this.element;
        int shapeType = elementShape.getShapeType();
        if (shapeType == 0) {
            this.shape = null;
            return;
        }
        switch (this.style.getRelativePosition()) {
            default: {
                x1 = -0.5;
                y1 = -0.5;
                break;
            }
            case 1: {
                x1 = -0.5;
                y1 = 0.0;
                break;
            }
            case 2: {
                x1 = -0.5;
                y1 = -1.0;
                break;
            }
            case 3: {
                x1 = -1.0;
                y1 = -0.5;
                break;
            }
            case 4: {
                x1 = 0.0;
                y1 = -0.5;
                break;
            }
            case 5: {
                x1 = -1.0;
                y1 = 0.0;
                break;
            }
            case 6: {
                x1 = 0.0;
                y1 = 0.0;
                break;
            }
            case 7: {
                x1 = -1.0;
                y1 = -1.0;
                break;
            }
            case 8: {
                x1 = 0.0;
                y1 = -1.0;
            }
        }
        double x2 = x1 + 1.0;
        double y2 = y1 + 1.0;
        switch (shapeType) {
            case 4: {
                this.line1 = new Line2D.Double(x1 + 0.5, y1, x1 + 0.5, y2);
                this.line2 = new Line2D.Double(x1, y1 + 0.5, x2, y1 + 0.5);
                this.shape = new Ellipse2D.Double(x1, y1, 1.0, 1.0);
                break;
            }
            default: {
                this.shape = new Ellipse2D.Double(x1, y1, 1.0, 1.0);
                break;
            }
            case 2: {
                this.shape = new Rectangle2D.Double(x1, y1, 1.0, 1.0);
                break;
            }
            case 3: {
                this.shape = new RoundRectangle2D.Double(x1, y1, 1.0, 1.0, 0.3, 0.3);
            }
        }
    }
}

