/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.ElementSegment;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementSegment
extends SimpleElement {
    protected int div = -1;
    protected int[] aCoord = null;
    protected int[] bCoord = null;
    protected double[][] points = null;
    private double[] pixel = new double[3];

    public SimpleElementSegment(ElementSegment _element) {
        super(_element);
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        if ((_cummulativeChange & 0x136) != 0) {
            this.computeDivisions();
            this.projectPoints();
        } else if ((_cummulativeChange & 0x40) != 0) {
            this.projectPoints();
        }
    }

    @Override
    public void draw(Graphics2D _g2, int _index) {
        _g2.setStroke(this.style.getLineStroke());
        _g2.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[_index].getDistance()));
        _g2.drawLine(this.aCoord[_index], this.bCoord[_index], this.aCoord[_index + 1], this.bCoord[_index + 1]);
    }

    @Override
    public void drawQuickly(Graphics2D _g2) {
        _g2.setStroke(this.style.getLineStroke());
        _g2.setColor(this.style.getLineColor());
        _g2.drawLine(this.aCoord[0], this.bCoord[0], this.aCoord[this.div], this.bCoord[this.div]);
    }

    private final void computeDivisions() {
        int theDiv = 1;
        Resolution res = this.style.getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 1: {
                    theDiv = Math.max((int)Math.round(0.49 + this.element.getDiagonalSize() / res.getMaxLength()), 1);
                    break;
                }
                case 0: {
                    theDiv = Math.max(res.getN1(), 1);
                }
            }
        }
        if (this.div != theDiv) {
            this.div = theDiv;
            this.points = new double[this.div + 1][3];
            this.aCoord = new int[this.div + 1];
            this.bCoord = new int[this.div + 1];
            this.objects = new Object3D[this.div];
            int i = 0;
            while (i < this.div) {
                this.objects[i] = new Object3D(this, i);
                ++i;
            }
        }
        double first = 0.0;
        double last = 1.0;
        switch (this.style.getRelativePosition()) {
            case 5: {
                first = 0.0;
                last = 1.0;
                break;
            }
            default: {
                first = -0.5;
                last = 0.5;
                break;
            }
            case 8: {
                first = 1.0;
                last = 0.0;
            }
        }
        double d = first;
        this.points[0][2] = d;
        this.points[0][1] = d;
        this.points[0][0] = d;
        double d2 = last;
        this.points[this.div][2] = d2;
        this.points[this.div][1] = d2;
        this.points[this.div][0] = d2;
        double delta = (last - first) / (double)this.div;
        int i = 1;
        while (i < this.div) {
            double d3 = first + (double)i * delta;
            this.points[i][2] = d3;
            this.points[i][1] = d3;
            this.points[i][0] = d3;
            ++i;
        }
        i = 0;
        while (i <= this.div) {
            this.element.sizeAndToSpaceFrame(this.points[i]);
            ++i;
        }
    }

    protected void projectPoints() {
        DrawingPanel3D panel = this.element.getPanel();
        int i = 0;
        while (i < this.div) {
            System.arraycopy(this.points[i], 0, this.pixel, 0, 3);
            panel.projectPosition(this.pixel);
            this.aCoord[i] = (int)this.pixel[0];
            this.bCoord[i] = (int)this.pixel[1];
            int j = 0;
            while (j < 3) {
                this.pixel[j] = (this.points[i][j] + this.points[i + 1][j]) / 2.0;
                ++j;
            }
            panel.projectPosition(this.pixel);
            this.objects[i].setDistance(this.pixel[2] * this.style.getDepthFactor());
            ++i;
        }
        System.arraycopy(this.points[this.div], 0, this.pixel, 0, 3);
        panel.projectPosition(this.pixel);
        this.aCoord[this.div] = (int)this.pixel[0];
        this.bCoord[this.div] = (int)this.pixel[1];
    }
}

