/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementCone;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementCone
extends SimpleAbstractTile {
    public SimpleElementCone(ElementCone _element) {
        super(_element);
    }

    @Override
    protected double[][][] computeTile() {
        ElementCone cone = (ElementCone)this.element;
        int nr = 1;
        int nu = 1;
        int nz = 1;
        double angle1 = cone.getMinimumAngle();
        double angle2 = cone.getMaximumAngle();
        if (Math.abs(angle2 - angle1) > 360.0) {
            angle2 = angle1 + 360.0;
        }
        Resolution res = this.style.getResolution();
        double height = cone.getTruncationHeight();
        if (res != null) {
            switch (res.getType()) {
                case 0: {
                    nr = Math.max(res.getN1(), 1);
                    nu = Math.max(res.getN2(), 1);
                    nz = Math.max(res.getN3(), 1);
                    break;
                }
                case 1: {
                    double dx = Math.abs(this.element.getSizeX()) / 2.0;
                    double dy = Math.abs(this.element.getSizeY()) / 2.0;
                    double dz = Math.abs(this.element.getSizeZ());
                    if (!Double.isNaN(height)) {
                        dz = Math.min(dz, height);
                    }
                    nr = Math.max((int)Math.round(0.49 + Math.max(dx, dy) / res.getMaxLength()), 1);
                    nu = Math.max((int)Math.round(0.49 + Math.abs(angle2 - angle1) * (Math.PI / 180) * (dx + dy) / res.getMaxLength()), 1);
                    nz = Math.max((int)Math.round(0.49 + dz / res.getMaxLength()), 1);
                }
            }
        }
        if (!Double.isNaN(height /= this.element.getSizeZ())) {
            height = Math.min(height, 1.0);
        }
        return ElementCone.createStandardCone(nr, nu, nz, angle1, angle2, cone.isClosedTop(), cone.isClosedBottom(), cone.isClosedLeft(), cone.isClosedRight(), height);
    }
}

