/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;
import org.opensourcephysics.drawing3d.utils.Style;

public class Java3dElementText
extends Java3dElement {
    private OrientedShape3D textOS = new OrientedShape3D();
    private TransformGroup textTG = null;
    private BranchGroup bg = null;
    private Shape3D shape = null;
    private Transform3D t1 = null;
    private Transform3D t2 = null;
    private double scale;
    private static final double nearDistance = 3.0;
    private static final double factorDistance = 4.0;
    private static final int preferredFrameSize = 300;
    private static GeneralPath gp = new GeneralPath();

    static {
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(1.0f, 1.0f);
    }

    public Java3dElementText(ElementText _element) {
        super(_element);
        this.textOS.setCapability(27);
        this.textOS.setCapability(13);
        this.textOS.setCapability(19);
        this.textOS.setCapability(15);
        this.textOS.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.textOS.setAlignmentMode(1);
        this.textOS.setConstantScaleEnable(true);
        this.textTG = new TransformGroup();
        this.textTG.setCapability(12);
        this.textTG.setCapability(13);
        this.textTG.setCapability(17);
        this.textTG.setCapability(18);
        this.textTG.setCapability(14);
        if (((ElementText)this.element).getText() != null) {
            this.element.addChange(8);
        }
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 4) != 0) {
            this.setOSScale();
        }
        if ((_change & 8) != 0) {
            this.recreateNode();
        }
        if ((_change & 0x80) != 0) {
            this.recreateNode();
        }
        if ((_change & 0x40) != 0) {
            this.changeSize();
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    private void setOSScale() {
        if (!((ElementText)this.element).isTrueSize()) {
            return;
        }
        Vector3d size = this.getSizeVector();
        size.x = 0.4;
        size.y = 0.4;
        size.z = 0.4;
        double max = Math.max(size.x, Math.max(size.y, size.z));
        this.textOS.setScale(max * 20.0);
    }

    private void recreateNode() {
        Text2D textNode = null;
        Text3D textNode3d = null;
        ElementText textElement = (ElementText)this.element;
        Style style = this.element.getStyle();
        if (style.getLineColor() == null) {
            return;
        }
        String str = textElement.getText();
        Font font = textElement.getFont();
        if (font == null || str == null) {
            return;
        }
        if (this.textTG != null && this.textTG.numChildren() != 0) {
            this.textTG.removeChild((Node)this.bg);
        }
        if (((ElementText)this.element).isTrueSize()) {
            textNode = new Text2D(str, new Color3f(style.getLineColor()), font.getName(), font.getSize() * 2, font.getStyle());
            this.getAppearance().setTexture(textNode.getAppearance().getTexture());
            this.getAppearance().getTransparencyAttributes().setTransparencyMode(1);
            this.textOS = new OrientedShape3D();
            this.textOS.setCapability(27);
            this.textOS.setCapability(13);
            this.textOS.setCapability(19);
            this.textOS.setCapability(15);
            this.textOS.setRotationPoint(0.0f, 0.0f, 0.0f);
            this.textOS.setAlignmentMode(1);
            this.textOS.setConstantScaleEnable(true);
            this.textOS.setGeometry(textNode.getGeometry());
            this.textOS.setAppearance(this.getAppearance());
            this.setOSScale();
        } else {
            Font3D font3d = new Font3D(font, new FontExtrusion((Shape)gp));
            textNode3d = new Text3D(font3d, textElement.getText(), new Point3f(0.0f, 0.0f, 0.0f));
            textNode3d.setAlignment(textElement.getStyle().getRelativePosition());
            this.shape = new Shape3D();
            this.shape.setGeometry((Geometry)textNode3d);
            this.shape.setAppearance(this.getAppearance());
        }
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        if (((ElementText)this.element).isTrueSize()) {
            this.bg.addChild((Node)this.textOS);
        } else {
            this.bg.addChild((Node)this.shape);
            this.t1 = new Transform3D();
            this.t2 = new Transform3D();
            this.t1.rotX(1.5707963267948966);
            this.t2.rotY(1.5707963267948966);
            this.t1.mul(this.t2);
            this.t1.setScale(0.06);
            this.textTG.setTransform(this.t1);
        }
        this.textTG.addChild((Node)this.bg);
        this.addNode((Node)this.textTG);
    }

    protected void updateText(double distanceToScreen) {
        double distance = distanceToScreen;
        this.scale = distance < 3.0 ? (double)((float)(4.0 * distance * 300.0 / (double)this.element.getPanel().getComponent().getWidth())) : (double)((float)(4.0 * distance * 300.0 / (double)this.element.getPanel().getComponent().getWidth()));
        double max = Math.max(this.element.getSizeX(), Math.max(this.element.getSizeY(), this.element.getSizeZ()));
        if (this.textOS != null) {
            this.textOS.setScale(this.scale * max);
        }
    }

    private void changeSize() {
        if (this.t1 == null) {
            return;
        }
        this.t1.setScale(0.06 * Math.max(this.element.getPanel().getPreferredMaxX(), Math.max(this.element.getPanel().getPreferredMaxY(), this.element.getPanel().getPreferredMaxY())));
        this.textTG.setTransform(this.t1);
    }
}

