/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.opensourcephysics.drawing3d.ElementShape;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementShape
extends Java3dElement {
    private BranchGroup bg;

    public Java3dElementShape(ElementShape _element) {
        super(_element);
        _element.addChange(8);
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        super.processChanges(_change, _cummulativeChange);
        if ((_change & 8) != 0) {
            if (((ElementShape)this.element).getShapeType() == 1 || ((ElementShape)this.element).getShapeType() == 4) {
                this.createEllipsoid();
            }
            if (((ElementShape)this.element).getShapeType() == 2) {
                this.createBox();
            }
            if (((ElementShape)this.element).getShapeType() == 3) {
                this.createCone();
            }
            if (((ElementShape)this.element).getShapeType() == 0) {
                this.createNone();
            }
        }
    }

    private void createEllipsoid() {
        Sphere sphere = new Sphere(0.5f, 35, 50);
        sphere.setAppearance(this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)sphere);
        this.addNode((Node)this.bg);
    }

    private void createBox() {
        Box box = new Box(0.5f, 0.5f, 0.5f, 35, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)box);
        this.addNode((Node)this.bg);
    }

    private void createCone() {
        Cone cone = new Cone(0.5f, 0.75f, 35, 50, 50, this.getAppearance());
        Transform3D t = new Transform3D();
        t.rotX(1.5707963267948966);
        TransformGroup tg = new TransformGroup();
        tg.setCapability(14);
        tg.setCapability(13);
        tg.setTransform(t);
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)cone);
        tg.addChild((Node)this.bg);
        this.addNode((Node)tg);
    }

    private void createNone() {
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.addNode((Node)this.bg);
    }

    @Override
    public boolean isPrimitive() {
        return ((ElementShape)this.element).getShapeType() != 2;
    }
}

