/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.Set;
import org.opensourcephysics.drawing3d.java3d.Java3dDrawingPanel3D;
import org.opensourcephysics.drawing3d.java3d.Java3dStyle;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.TransformationWrapper;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.Transformation;

public abstract class Java3dElement
implements ImplementingObject {
    public static final int AFFECTS_TRANSFORM = 279;
    protected Element element;
    protected boolean primitive;
    private Java3dStyle java3dStyle;
    private BranchGroup branchGroup;
    private BranchGroup last_branchGroup;
    private TransformGroup transformGroup;
    private Transform3D transform1;
    private Transform3D transform2;
    private Vector3d positionVector = new Vector3d();
    private Vector3d sizeVector = new Vector3d();
    private Quat4d quatBuffer1 = new Quat4d(0.0, 0.0, 0.0, 1.0);
    private Vector3d finalTranslation = new Vector3d();
    private ArrayList<Quat4d> listQuat = new ArrayList();
    private ArrayList<Vector3d> listDirect = new ArrayList();

    protected Java3dElement(Element _element) {
        this.element = _element;
        this.java3dStyle = new Java3dStyle(this.element.getStyle());
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(14);
        this.branchGroup.setCapability(13);
        this.branchGroup.setCapability(17);
        this.transform1 = new Transform3D();
        this.transform2 = new Transform3D();
        this.transform2.mul(this.transform1);
        this.transformGroup = new TransformGroup(this.transform2);
        this.transformGroup.setCapability(17);
        this.transformGroup.setCapability(18);
        this.transformGroup.setCapability(14);
        this.transformGroup.setCapability(13);
        this.element.addChange(279);
    }

    @Override
    public void addToScene() {
        Group group = this.element.getGroup();
        if (group != null) {
            ImplementingObject obj = group.getImplementingObject();
            if (obj != null) {
                ((Java3dElement)group.getImplementingObject()).getTransformGroup().addChild((Node)this.branchGroup);
            }
        } else {
            ((Java3dDrawingPanel3D)this.element.getPanel().getImplementingPanel()).getTransformGroup().addChild((Node)this.branchGroup);
        }
    }

    @Override
    public void removeFromScene() {
        Group group = this.element.getGroup();
        if (group != null) {
            Java3dElement implGroup = (Java3dElement)group.getImplementingObject();
            if (implGroup != null) {
                implGroup.getTransformGroup().removeChild((Node)this.branchGroup);
            }
        } else {
            Java3dDrawingPanel3D implPanel = (Java3dDrawingPanel3D)this.element.getPanel().getImplementingPanel();
            if (implPanel != null) {
                implPanel.getTransformGroup().removeChild((Node)this.branchGroup);
            }
        }
    }

    @Override
    public synchronized void processChanges(int _change, int _cummulativeChange) {
        double[] point;
        if (this.element instanceof Set) {
            this.transformGroup.setTransform(new Transform3D());
            return;
        }
        if ((_change & 2) != 0) {
            point = this.element.getScaledPosition();
            this.positionVector.x = point[0];
            this.positionVector.y = point[1];
            this.positionVector.z = point[2];
        }
        if ((_change & 4) != 0) {
            point = this.element.getScaledSize();
            this.sizeVector.x = point[0];
            this.sizeVector.y = point[1];
            this.sizeVector.z = point[2];
        }
        if ((_change & 0x100) != 0) {
            this.modifyTransform();
        }
        if ((_change & 0x117) != 0) {
            this.transform1.set(this.quatBuffer1);
            this.transform2.setIdentity();
            this.finalTranslation.set(new double[]{0.0, 0.0, 0.0});
            int i = this.listQuat.size() - 1;
            while (i >= 0) {
                Transform3D temp = new Transform3D();
                temp.set(this.listQuat.get(i));
                this.finalTranslation.add(this.listDirect.get(i));
                this.transform2.mul(temp);
                --i;
            }
            this.transform2.mul(this.transform1);
            this.finalTranslation.add(this.positionVector);
            this.transform2.setTranslation(this.finalTranslation);
            this.transform2.setScale(this.sizeVector);
            this.transformGroup.setTransform(this.transform2);
        }
        if ((_change & 1) != 0) {
            this.makeVisible(this.element.isVisible());
        }
        if ((_change & 0x10) != 0 || (_change & 8) != 0) {
            this.element.styleChanged(10);
        }
    }

    @Override
    public void styleChanged(int _change) {
        switch (_change) {
            case 5: {
                this.element.addChange(2);
                break;
            }
            case 9: {
                this.element.addChange(16);
            }
        }
        this.java3dStyle.applyStyleChange(_change);
    }

    protected void makeVisible(boolean _visible) {
        if (this.element instanceof Group) {
            for (Element elementJ3D : ((Group)this.element).getElements()) {
                ((Java3dElement)elementJ3D.getImplementingObject()).getAppearance().getRenderingAttributes().setVisible(_visible);
            }
        } else if (this.element.getGroup() == null || this.element.getGroup().isVisible()) {
            this.getAppearance().getRenderingAttributes().setVisible(_visible);
        }
    }

    public abstract boolean isPrimitive();

    protected final void addNode(Node _node) {
        if (_node == null) {
            this.branchGroup.addChild((Node)this.transformGroup);
            return;
        }
        if (this.last_branchGroup != null) {
            this.last_branchGroup.detach();
            this.last_branchGroup.removeAllChildren();
            this.transformGroup.removeAllChildren();
        }
        this.transformGroup.addChild(_node);
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        bg.setCapability(13);
        bg.setCapability(14);
        bg.addChild((Node)this.transformGroup);
        this.branchGroup.addChild((Node)bg);
        this.last_branchGroup = bg;
    }

    protected final BranchGroup getBranchGroup() {
        return this.branchGroup;
    }

    protected final TransformGroup getTransformGroup() {
        return this.transformGroup;
    }

    protected final Vector3d getPositionVector() {
        return this.positionVector;
    }

    protected final Vector3d getSizeVector() {
        return this.sizeVector;
    }

    protected final Appearance getAppearance() {
        return this.java3dStyle.getAppearance();
    }

    private void modifyTransform() {
        this.quatBuffer1 = this.changeTransform(this.element.getTransformation());
        this.listQuat.clear();
        this.listDirect.clear();
        for (TransformationWrapper trWrapper : this.element.getSecondaryTransformations()) {
            if (!trWrapper.isEnabled()) continue;
            this.listQuat.add(this.changeTransform(trWrapper.getTransformation()));
            this.listDirect.add(this.getDirectMovement(trWrapper.getTransformation()));
        }
    }

    private Vector3d getDirectMovement(Transformation tr) {
        Vector3d direct = new Vector3d();
        if (tr == null) {
            direct.set(new double[]{0.0, 0.0, 0.0});
        } else if (tr instanceof Quaternion) {
            double[] origin = ((Quaternion)tr).getOrigin();
            if (origin[0] != 0.0 || origin[1] != 0.0 || origin[2] != 0.0) {
                direct.set(tr.direct(new double[]{0.0, 0.0, 0.0}));
            }
        } else {
            double[] origin = ((Matrix3DTransformation)tr).getOrigin();
            if (origin[0] != 0.0 || origin[1] != 0.0 || origin[2] != 0.0) {
                direct.set(tr.direct(new double[]{0.0, 0.0, 0.0}));
            }
        }
        return direct;
    }

    private Quat4d changeTransform(Transformation tr) {
        Quat4d quat = new Quat4d();
        double[] matrixBuffer = new double[16];
        double[] trPoint = new double[3];
        Transform3D temp = new Transform3D();
        if (tr == null) {
            quat.set(0.0, 0.0, 0.0, 1.0);
        } else if (tr instanceof Quaternion) {
            double[] coordsBuffer = ((Quaternion)tr).getCoordinates();
            System.arraycopy(coordsBuffer, 1, trPoint, 0, 3);
            this.element.getPanel().getCamera().map(trPoint);
            quat.set(trPoint[0], trPoint[1], trPoint[2], coordsBuffer[0]);
        } else if (tr instanceof Matrix3DTransformation) {
            ((Matrix3DTransformation)tr).getTransposedFlatMatrix(matrixBuffer);
            temp.set(matrixBuffer);
            temp.get(quat);
            trPoint[0] = quat.x;
            trPoint[1] = quat.y;
            trPoint[2] = quat.z;
            this.element.getPanel().getCamera().map(trPoint);
            quat.set(trPoint[0], trPoint[1], trPoint[2], quat.w);
        } else {
            System.err.println("Java3dElement Warning! Ignored transformation of an unknown type : " + tr);
        }
        return quat;
    }
}

