/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementTrail;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementTrail;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;

public class ElementTrail
extends Element
implements Data {
    public static final int NO_CONNECTION = 0;
    public static final int LINE_CONNECTION = 1;
    private int maximum = 0;
    private String[] inputLabels = new String[]{"x", "y", "z"};
    private TrailPoint ghostPoint = null;
    private List<TrailPoint> list = new ArrayList<TrailPoint>();
    private List<TrailPoint> displayPoints = new ArrayList<TrailPoint>();
    protected int datasetID = this.hashCode();

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementTrail(this);
            }
            case 1: 
        }
        return new Java3dElementTrail(this);
    }

    public void setMaximumPoints(int maximum) {
        this.maximum = maximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        List<TrailPoint> list = this.list;
        synchronized (list) {
            this.list.clear();
        }
        list = this.displayPoints;
        synchronized (list) {
            this.displayPoints.clear();
        }
        this.ghostPoint = null;
        this.addChange(8);
    }

    public void setLabels(String[] _labels) {
        int i = 0;
        while (i < _labels.length) {
            this.inputLabels[i] = _labels[i];
            ++i;
        }
    }

    public void setXLabel(String _label) {
        this.inputLabels[0] = _label;
    }

    public void setYLabel(String _label) {
        this.inputLabels[1] = _label;
    }

    public void setZLabel(String _label) {
        this.inputLabels[2] = _label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(double _x, double _y, double _z, int _type) {
        TrailPoint point = new TrailPoint(_x, _y, _z, _type);
        List<TrailPoint> list = this.list;
        synchronized (list) {
            if (this.maximum > 0 && this.list.size() >= this.maximum) {
                this.list.remove(0);
            }
            this.list.add(point);
        }
        this.addChange(8);
    }

    public void addPoint(double _x, double _y, double _z) {
        this.addPoint(_x, _y, _z, 1);
    }

    public void addPoint(double[] _point) {
        this.addPoint(_point[0], _point[1], _point[2], 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(TrailPoint trailPoint) {
        TrailPoint point = new TrailPoint(trailPoint);
        List<TrailPoint> list = this.list;
        synchronized (list) {
            if (this.maximum > 0 && this.list.size() >= this.maximum) {
                this.list.remove(0);
            }
            this.list.add(point);
        }
        this.addChange(8);
    }

    public void setGhostPoint(TrailPoint _point) {
        this.ghostPoint = _point;
        this.addChange(8);
    }

    public void closeTrail(int _type) {
        if (this.ghostPoint != null) {
            this.ghostPoint.type = _type;
            this.addPoint(this.ghostPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processChanges(int _cummulativeChange) {
        if ((this.getChange() & 8) != 0) {
            this.displayPoints.clear();
            Object object = this.list;
            synchronized (object) {
                this.displayPoints.addAll(this.list);
            }
            if (this.ghostPoint != null) {
                object = this.ghostPoint;
                synchronized (object) {
                    this.displayPoints.add(new TrailPoint(this.ghostPoint));
                }
            }
        }
        super.processChanges(_cummulativeChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getExtrema(double[] min, double[] max) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] aPoint = new double[3];
        List<TrailPoint> list = this.list;
        synchronized (list) {
            if (this.list.isEmpty()) {
                return;
            }
        }
        list = this.displayPoints;
        synchronized (list) {
            for (TrailPoint trailPoint : this.displayPoints) {
                System.arraycopy(trailPoint.coordinates, 0, aPoint, 0, 3);
                this.sizeAndToSpaceFrame(aPoint);
                minX = Math.min(minX, aPoint[0]);
                maxX = Math.max(maxX, aPoint[0]);
                minY = Math.min(minY, aPoint[1]);
                maxY = Math.max(maxY, aPoint[1]);
                minZ = Math.min(minZ, aPoint[2]);
                maxZ = Math.max(maxZ, aPoint[2]);
            }
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }

    public List<TrailPoint> getDisplayPoints() {
        return this.displayPoints;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getData2D() {
        List<TrailPoint> list = this.displayPoints;
        synchronized (list) {
            int n = this.displayPoints.size();
            double[][] data = new double[3][n];
            int i = 0;
            while (i < n) {
                TrailPoint point = this.displayPoints.get(i);
                data[0][i] = point.coordinates[0];
                data[1][i] = point.coordinates[1];
                data[2][i] = point.coordinates[2];
                ++i;
            }
            return data;
        }
    }

    public double[] getData1D() {
        int n = this.getData2D()[0].length;
        double[] data = new double[3 * n];
        int i = 0;
        while (i < n) {
            data[i] = this.getData2D()[0][i];
            data[i + 1] = this.getData2D()[1][i];
            data[i + 2] = this.getData2D()[2][i];
            ++i;
        }
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.inputLabels;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public Color[] getFillColors() {
        Paint fill = this.getStyle().getFillColor();
        if (fill instanceof Color) {
            return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), (Color)fill};
        }
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public static class TrailPoint {
        private int type;
        private double[] coordinates;

        public TrailPoint(double _x, double _y, double _z, int _type) {
            this.coordinates = new double[]{_x, _y, _z};
            this.type = _type;
        }

        public TrailPoint(TrailPoint point) {
            this.coordinates = (double[])point.coordinates.clone();
            this.type = point.type;
        }

        public void setCoordinates(double _x, double _y, double _z, int _type) {
            this.coordinates[0] = _x;
            this.coordinates[1] = _y;
            this.coordinates[2] = _z;
            this.type = _type;
        }

        public int getType() {
            return this.type;
        }

        public double[] getPoint() {
            return this.coordinates;
        }
    }
}

