/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.java3d.Java3dElementCone;
import org.opensourcephysics.drawing3d.simple3d.SimpleElementCone;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class ElementCone
extends Element {
    private boolean closedBottom = true;
    private boolean closedTop = true;
    private boolean closedLeft = true;
    private boolean closedRight = true;
    private int minAngle = 0;
    private int maxAngle = 360;
    private double truncationHeight = Double.NaN;

    public ElementCone() {
        this.getStyle().setResolution(new Resolution(3, 12, 5));
    }

    @Override
    protected ImplementingObject createImplementingObject(int _implementation) {
        switch (_implementation) {
            default: {
                return new SimpleElementCone(this);
            }
            case 1: 
        }
        return new Java3dElementCone(this);
    }

    public void setClosedBottom(boolean close) {
        if (this.closedBottom == close) {
            return;
        }
        this.closedBottom = close;
        this.addChange(8);
    }

    public boolean isClosedBottom() {
        return this.closedBottom;
    }

    public void setClosedTop(boolean close) {
        if (this.closedTop == close) {
            return;
        }
        this.closedTop = close;
        this.addChange(8);
    }

    public boolean isClosedTop() {
        return this.closedTop;
    }

    public void setClosedLeft(boolean close) {
        if (this.closedLeft == close) {
            return;
        }
        this.closedLeft = close;
        this.addChange(8);
    }

    public boolean isClosedLeft() {
        return this.closedLeft;
    }

    public void setClosedRight(boolean close) {
        if (this.closedRight == close) {
            return;
        }
        this.closedRight = close;
        this.addChange(8);
    }

    public boolean isClosedRight() {
        return this.closedRight;
    }

    public void setTruncationHeight(double height) {
        if (this.truncationHeight == height) {
            return;
        }
        if (height < 0.0) {
            height = Double.NaN;
        }
        this.truncationHeight = height;
        this.addChange(8);
    }

    public double getTruncationHeight() {
        return this.truncationHeight;
    }

    public void setMinimumAngle(int angle) {
        if (this.minAngle == angle) {
            return;
        }
        this.minAngle = Math.max(0, Math.min(360, angle));
        this.addChange(8);
    }

    public int getMinimumAngle() {
        return this.minAngle;
    }

    public void setMaximumAngle(int angle) {
        if (this.maxAngle == angle) {
            return;
        }
        this.maxAngle = Math.max(0, Math.min(360, angle));
        this.addChange(8);
    }

    public int getMaximumAngle() {
        return this.maxAngle;
    }

    public boolean checkStandarCone() {
        return this.closedBottom && this.minAngle == 0 && this.maxAngle == 360 && Double.isNaN(this.truncationHeight);
    }

    public static double[][][] createStandardCone(int nr, int nu, int nz, double angle1, double angle2, boolean top, boolean bottom, boolean left, boolean right, double height) {
        int ref;
        int k;
        int u;
        int totalN = nu * nz;
        if (bottom) {
            totalN += nr * nu;
        }
        if (!Double.isNaN(height) && top) {
            totalN += nr * nu;
        }
        if (Math.abs(angle2 - angle1) < 360.0) {
            if (left) {
                totalN += nr * nz;
            }
            if (right) {
                totalN += nr * nz;
            }
        }
        double[][][] data = new double[totalN][4][3];
        double[] cosu = new double[nu + 1];
        double[] sinu = new double[nu + 1];
        int u2 = 0;
        while (u2 <= nu) {
            double angle = ((double)(nu - u2) * angle1 + (double)u2 * angle2) * (Math.PI / 180) / (double)nu;
            cosu[u2] = Math.cos(angle) / 2.0;
            sinu[u2] = Math.sin(angle) / 2.0;
            ++u2;
        }
        int tile = 0;
        double[] vectorx = Element.X_UNIT_VECTOR;
        double[] vectory = Element.Y_UNIT_VECTOR;
        double[] vectorz = Element.Z_UNIT_VECTOR;
        double[] center = new double[]{-vectorz[0] / 2.0, -vectorz[1] / 2.0, -vectorz[2] / 2.0};
        double theNz = Double.isNaN(height) ? (double)nz : (height == 0.0 ? 2.147483647E9 : (double)nz / height);
        double auxZ = 1.0 / theNz;
        int j = 0;
        while (j < nz) {
            u = 0;
            while (u < nu) {
                k = 0;
                while (k < 3) {
                    data[tile][0][k] = center[k] + (cosu[u] * vectorx[k] + sinu[u] * vectory[k]) * (theNz - (double)j) / theNz + (double)j * auxZ * vectorz[k];
                    data[tile][1][k] = center[k] + (cosu[u + 1] * vectorx[k] + sinu[u + 1] * vectory[k]) * (theNz - (double)j) / theNz + (double)j * auxZ * vectorz[k];
                    data[tile][2][k] = center[k] + (cosu[u + 1] * vectorx[k] + sinu[u + 1] * vectory[k]) * (theNz - (double)j - 1.0) / theNz + (double)(j + 1) * auxZ * vectorz[k];
                    data[tile][3][k] = center[k] + (cosu[u] * vectorx[k] + sinu[u] * vectory[k]) * (theNz - (double)j - 1.0) / theNz + (double)(j + 1) * auxZ * vectorz[k];
                    ++k;
                }
                ++u;
                ++tile;
            }
            ++j;
        }
        if (bottom) {
            int u3 = 0;
            while (u3 < nu) {
                int i = 0;
                while (i < nr) {
                    k = 0;
                    while (k < 3) {
                        data[tile][0][k] = ((double)(nr - i) * center[k] + (double)i * data[u3][0][k]) / (double)nr;
                        data[tile][1][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[u3][0][k]) / (double)nr;
                        data[tile][2][k] = ((double)(nr - i - 1) * center[k] + (double)(i + 1) * data[u3][1][k]) / (double)nr;
                        data[tile][3][k] = ((double)(nr - i) * center[k] + (double)i * data[u3][1][k]) / (double)nr;
                        ++k;
                    }
                    ++i;
                    ++tile;
                }
                ++u3;
            }
        }
        if (!Double.isNaN(height) && top) {
            ref = nu * (nz - 1);
            center[0] = vectorz[0];
            center[1] = vectorz[1];
            center[2] = Double.isNaN(height) ? vectorz[2] - 0.5 : height * vectorz[2] - 0.5;
            u = 0;
            while (u < nu) {
                int i = 0;
                while (i < nr) {
                    int k2 = 0;
                    while (k2 < 3) {
                        data[tile][0][k2] = ((double)(nr - i) * center[k2] + (double)i * data[ref + u][3][k2]) / (double)nr;
                        data[tile][1][k2] = ((double)(nr - i - 1) * center[k2] + (double)(i + 1) * data[ref + u][3][k2]) / (double)nr;
                        data[tile][2][k2] = ((double)(nr - i - 1) * center[k2] + (double)(i + 1) * data[ref + u][2][k2]) / (double)nr;
                        data[tile][3][k2] = ((double)(nr - i) * center[k2] + (double)i * data[ref + u][2][k2]) / (double)nr;
                        ++k2;
                    }
                    ++i;
                    ++tile;
                }
                ++u;
            }
        }
        if (Math.abs(angle2 - angle1) < 360.0) {
            int k3;
            int i;
            int j2;
            double aux;
            center[0] = -vectorz[0] / 2.0;
            center[1] = -vectorz[1] / 2.0;
            center[2] = -vectorz[2] / 2.0;
            if (right) {
                ref = 0;
                double[] nextCenter = new double[3];
                double N = Double.isNaN(height) ? (double)nz : (height == 0.0 ? 2.147483647E9 : (double)nz / height);
                aux = 1.0 / N;
                j2 = 0;
                while (j2 < nz) {
                    center[0] = (double)j2 * aux * vectorz[0];
                    center[1] = (double)j2 * aux * vectorz[1];
                    center[2] = (double)j2 * aux * vectorz[2] - 0.5;
                    nextCenter[0] = (double)(j2 + 1) * aux * vectorz[0];
                    nextCenter[1] = (double)(j2 + 1) * aux * vectorz[1];
                    nextCenter[2] = (double)(j2 + 1) * aux * vectorz[2] - 0.5;
                    i = 0;
                    while (i < nr) {
                        k3 = 0;
                        while (k3 < 3) {
                            data[tile][0][k3] = ((double)(nr - i) * center[k3] + (double)i * data[ref][0][k3]) / (double)nr;
                            data[tile][1][k3] = ((double)(nr - i - 1) * center[k3] + (double)(i + 1) * data[ref][0][k3]) / (double)nr;
                            data[tile][2][k3] = ((double)(nr - i - 1) * nextCenter[k3] + (double)(i + 1) * data[ref][3][k3]) / (double)nr;
                            data[tile][3][k3] = ((double)(nr - i) * nextCenter[k3] + (double)i * data[ref][3][k3]) / (double)nr;
                            ++k3;
                        }
                        ++i;
                        ++tile;
                    }
                    ++j2;
                    ref += nu;
                }
            }
            if (left) {
                ref = nu - 1;
                double[] nextCenter = new double[3];
                double N = Double.isNaN(height) ? (double)nz : (height == 0.0 ? 2.147483647E9 : (double)nz / height);
                aux = 1.0 / N;
                j2 = 0;
                while (j2 < nz) {
                    center[0] = (double)j2 * aux * vectorz[0];
                    center[1] = (double)j2 * aux * vectorz[1];
                    center[2] = (double)j2 * aux * vectorz[2] - 0.5;
                    nextCenter[0] = (double)(j2 + 1) * aux * vectorz[0];
                    nextCenter[1] = (double)(j2 + 1) * aux * vectorz[1];
                    nextCenter[2] = (double)(j2 + 1) * aux * vectorz[2] - 0.5;
                    i = 0;
                    while (i < nr) {
                        k3 = 0;
                        while (k3 < 3) {
                            data[tile][0][k3] = ((double)(nr - i) * center[k3] + (double)i * data[ref][1][k3]) / (double)nr;
                            data[tile][1][k3] = ((double)(nr - i - 1) * center[k3] + (double)(i + 1) * data[ref][1][k3]) / (double)nr;
                            data[tile][2][k3] = ((double)(nr - i - 1) * nextCenter[k3] + (double)(i + 1) * data[ref][2][k3]) / (double)nr;
                            data[tile][3][k3] = ((double)(nr - i) * nextCenter[k3] + (double)i * data[ref][2][k3]) / (double)nr;
                            ++k3;
                        }
                        ++i;
                        ++tile;
                    }
                    ++j2;
                    ref += nu;
                }
            }
        }
        return data;
    }
}

