/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.TextLine;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.Object3D;

public class InteractiveText
extends AbstractInteractiveElement {
    private double a1 = 0.0;
    private double b1 = 0.0;
    private double[] coordinates = new double[3];
    private double[] pixelOrigin = new double[3];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    protected AffineTransform transform = new AffineTransform();
    protected TextLine textLine = new TextLine();
    private Object lastDisplayObject = null;

    public InteractiveText() {
        this("");
    }

    public InteractiveText(String _text) {
        this.style.setFont(new Font("Dialog", 0, 18));
        this.style.setDisplayObject(_text);
        this.sizeEnabled = false;
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        if (this.positionEnabled && Math.abs(this.pixelOrigin[0] - (double)_xpix) < (double)SENSIBILITY && Math.abs(this.pixelOrigin[1] - (double)_ypix) < (double)SENSIBILITY) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    @Override
    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        return this.objects;
    }

    @Override
    public void draw(DrawingPanel3D _panel, Graphics2D _g2, int _index) {
        Color theColor = _panel.projectColor(this.style.edgeColor, this.objects[0].distance);
        Paint theFillPattern = this.style.fillPattern;
        if (theFillPattern instanceof Color) {
            theFillPattern = _panel.projectColor((Color)theFillPattern, this.objects[0].distance);
        }
        this.drawIt(_g2, theColor, theFillPattern);
    }

    @Override
    public void drawQuickly(DrawingPanel3D _panel, Graphics2D _g2) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        this.drawIt(_g2, this.style.edgeColor, this.style.fillPattern);
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.visible) {
            return;
        }
        this.projectPoints(_panel);
        this.drawIt((Graphics2D)_g, this.style.edgeColor, this.style.fillPattern);
    }

    protected void projectPoints(DrawingPanel _panel) {
        if (this.group != null) {
            this.coordinates[0] = this.group.x + this.x * this.group.sizex;
            this.coordinates[1] = this.group.y + this.y * this.group.sizey;
            this.coordinates[2] = this.group.z + this.z * this.group.sizez;
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
        }
        _panel.project(this.coordinates, this.pixelOrigin);
        this.objects[0].distance = this.pixelOrigin[2];
        this.hasChanged = false;
        this.panelWithValidProjection = _panel;
    }

    private void drawIt(Graphics2D _g2, Color _color, Paint _fill) {
        if (this.style.displayObject == null) {
            return;
        }
        if (this.style.font != null && this.style.font != this.textLine.getFont()) {
            this.textLine.setFont(this.style.font);
        }
        if (this.lastDisplayObject != this.style.displayObject) {
            this.textLine.setText(this.style.displayObject.toString());
            this.lastDisplayObject = this.style.displayObject;
        }
        this.textLine.setColor(_color);
        this.adjustPosition(_g2);
        AffineTransform originalTransform = _g2.getTransform();
        this.transform.setTransform(originalTransform);
        this.transform.rotate(-this.style.angle, this.pixelOrigin[0], this.pixelOrigin[1]);
        _g2.setTransform(this.transform);
        this.textLine.drawText(_g2, (int)this.a1, (int)this.b1);
        _g2.setTransform(originalTransform);
    }

    private void adjustPosition(Graphics _g) {
        this.a1 = this.pixelOrigin[0];
        this.b1 = this.pixelOrigin[1];
        int lenx = this.textLine.getWidth(_g);
        int leny = this.textLine.getHeight(_g) / 2;
        switch (this.style.position) {
            default: {
                this.a1 -= (double)lenx / 2.0;
                this.b1 += (double)leny / 2.0;
                break;
            }
            case 1: {
                this.a1 -= (double)lenx / 2.0;
                this.b1 += (double)leny;
                break;
            }
            case 2: {
                this.a1 -= (double)lenx / 2.0;
                break;
            }
            case 3: {
                this.a1 -= (double)lenx;
                this.b1 += (double)leny / 2.0;
                break;
            }
            case 5: {
                this.a1 -= (double)lenx;
                this.b1 += (double)leny;
                break;
            }
            case 7: {
                this.a1 -= (double)lenx;
                break;
            }
            case 4: {
                this.b1 += (double)leny / 2.0;
                break;
            }
            case 6: {
                this.b1 += (double)leny;
            }
            case 8: 
        }
    }
}

