/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.axes.XYAxis;

public class XAxis
extends XYAxis {
    public XAxis() {
        this("X Axis");
    }

    public XAxis(String string) {
        this.setTitle(string);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.yToPix(this.location);
        if (n < 1) {
            this.location = drawingPanel.getYMin();
        }
        if (n > drawingPanel.getHeight() - 1) {
            this.location = drawingPanel.getYMax();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        switch (this.locationType) {
            case 0: 
            case 2: {
                this.drawInsideDisplay(drawingPanel, graphics);
                break;
            }
            case 1: {
                this.drawInsideGutter(drawingPanel, graphics);
                break;
            }
            default: {
                this.drawInsideDisplay(drawingPanel, graphics);
            }
        }
        graphics2D.setClip(shape);
    }

    private void drawInsideDisplay(DrawingPanel drawingPanel, Graphics graphics) {
        Color color = drawingPanel.getForeground();
        int n = drawingPanel.getBottomGutter();
        int n2 = drawingPanel.getRightGutter();
        int n3 = drawingPanel.getLeftGutter();
        int n4 = drawingPanel.getTopGutter();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = 0;
        graphics.setColor(color);
        if (this.locationType == 0) {
            this.location = (drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0;
        }
        int n6 = n3;
        int n7 = drawingPanel.yToPix(this.location);
        int n8 = drawingPanel.getWidth() - n3 - n2;
        graphics.drawLine(n6, n7, n6 + n8, n7);
        this.calculateLabels(drawingPanel.getXMin(), drawingPanel.getXMax(), 1 + n8 / 35);
        String[] stringArray = this.label_string;
        double[] dArray = this.label_value;
        if (stringArray.length != dArray.length) {
            return;
        }
        int n9 = 0;
        int n10 = stringArray.length;
        while (n9 < n10) {
            int n11;
            if (this.axisType == 0) {
                n11 = drawingPanel.xToPix(dArray[n9] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    graphics.setColor(this.majorGridColor);
                    graphics.drawLine(n11, n4 + 1, n11, drawingPanel.getHeight() - n - 1);
                    graphics.setColor(color);
                }
                graphics.drawLine(n11, n7 - 5, n11, n7 + 5);
                n5 = fontMetrics.stringWidth(stringArray[n9]);
                graphics.drawString(stringArray[n9], n11 - n5 / 2, n7 + 18);
            } else {
                n11 = drawingPanel.xToPix(Math.pow(10.0, dArray[n9] * this.decade_multiplier));
                if (this.showMajorGrid) {
                    graphics.setColor(this.majorGridColor);
                    graphics.drawLine(n11, n4 + 1, n11, drawingPanel.getHeight() - n - 1);
                    graphics.setColor(color);
                }
                graphics.drawLine(n11, n7 - 5, n11, n7 + 5);
                n5 = fontMetrics.stringWidth(this.logBase);
                this.drawMultiplier(n11 - n5 / 2, n7 + 18, (int)dArray[n9], (Graphics2D)graphics);
            }
            ++n9;
        }
        n9 = drawingPanel.getHeight() - Math.max(n / 2, 6);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        if (this.axisType == 0 && this.label_exponent != 0) {
            graphics2D.setColor(Color.red);
            graphics2D.drawString("x10", drawingPanel.getWidth() - 36, n9);
            graphics2D.setFont(graphics2D.getFont().deriveFont(0, 9.0f));
            graphics2D.drawString("" + this.label_exponent, drawingPanel.getWidth() - 16, n9 - 6);
        }
        graphics2D.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
            this.axisLabel.setY(drawingPanel.getYMin() - 20.0 / drawingPanel.getYPixPerUnit());
            this.axisLabel.setColor(color);
            this.axisLabel.draw(drawingPanel, graphics2D);
        }
        graphics2D.setFont(font);
    }

    private void drawInsideGutter(DrawingPanel drawingPanel, Graphics graphics) {
        Color color = drawingPanel.getForeground();
        int n = drawingPanel.getBottomGutter();
        int n2 = drawingPanel.getRightGutter();
        int n3 = drawingPanel.getLeftGutter();
        int n4 = drawingPanel.getTopGutter();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = 0;
        graphics.setColor(color);
        int n6 = n3;
        int n7 = drawingPanel.getHeight() - n - 1;
        int n8 = drawingPanel.getWidth() - n3 - n2;
        this.calculateLabels(drawingPanel.getXMin(), drawingPanel.getXMax(), 1 + n8 / 35);
        String[] stringArray = this.label_string;
        double[] dArray = this.label_value;
        if (stringArray.length != dArray.length) {
            return;
        }
        int n9 = 0;
        int n10 = stringArray.length;
        while (n9 < n10) {
            int n11;
            if (this.axisType == 0) {
                n11 = drawingPanel.xToPix(dArray[n9] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    graphics.setColor(this.majorGridColor);
                    graphics.drawLine(n11, n4 + 1, n11, n7);
                    graphics.setColor(color);
                }
                graphics.drawLine(n11, n7, n11, n7 + 5);
                n5 = fontMetrics.stringWidth(stringArray[n9]);
                graphics.drawString(stringArray[n9], n11 - n5 / 2, n7 + 18);
            } else {
                n11 = drawingPanel.xToPix(Math.pow(10.0, dArray[n9] * this.decade_multiplier));
                if (this.showMajorGrid) {
                    graphics.setColor(this.majorGridColor);
                    graphics.drawLine(n11, n4 + 1, n11, n7);
                    graphics.setColor(color);
                }
                graphics.drawLine(n11, n7, n11, n7 + 5);
                n5 = fontMetrics.stringWidth(this.logBase);
                this.drawMultiplier(n11 - n5 / 2, n7 + 18, (int)dArray[n9], (Graphics2D)graphics);
            }
            ++n9;
        }
        graphics.drawLine(n6, n7, n6 + n8, n7);
        n9 = drawingPanel.getHeight() - Math.max(n / 2 - 15, 6);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.axisType == 0 && this.label_exponent != 0) {
            graphics2D.setColor(Color.red);
            graphics2D.drawString("x10", drawingPanel.getWidth() - 36, n9);
            graphics2D.setFont(graphics2D.getFont().deriveFont(0, 9.0f));
            graphics2D.drawString("" + this.label_exponent, drawingPanel.getWidth() - 16, n9 - 6);
        }
        graphics2D.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setX(drawingPanel.pixToX((drawingPanel.getWidth() + n3 - n2) / 2));
            FontMetrics fontMetrics2 = drawingPanel.getFontMetrics(this.labelFont);
            this.axisLabel.setY(drawingPanel.pixToY(drawingPanel.getHeight() - Math.max(n - 2 * fontMetrics2.getHeight() - 4, 10)));
            this.axisLabel.setColor(color);
            this.axisLabel.draw(drawingPanel, graphics2D);
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.enabled) {
            return null;
        }
        if (Math.abs(drawingPanel.yToPix(this.location) - n2) < 2) {
            return this;
        }
        return null;
    }

    public void setXY(double d, double d2) {
        this.location = d2;
    }

    public void setY(double d) {
        this.location = d;
    }
}

