/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.Component;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.opensourcephysics.display.OSPRuntime;

public class FileUtils {
    public static void updateComponentTreeUI(Component c) {
        if (OSPRuntime.isMac()) {
            if (UIManager.getLookAndFeel().toString().toLowerCase().indexOf("aqua") < 0) {
                SwingUtilities.updateComponentTreeUI(c);
            }
        } else {
            SwingUtilities.updateComponentTreeUI(c);
        }
    }

    public static String getPlainName(File _file) {
        String name = _file.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String getPath(File _file) {
        int a;
        String path;
        try {
            path = _file.getCanonicalPath();
        }
        catch (Exception exc) {
            path = _file.getAbsolutePath();
        }
        if (OSPRuntime.isWindows() && (a = (path = path.replace('\\', '/')).indexOf(58)) > 0) {
            path = String.valueOf(path.substring(0, a).toUpperCase()) + path.substring(a);
        }
        if (_file.isDirectory() && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    public static String correctUrlString(String _urlStr) {
        String noSpaces = "";
        StringTokenizer tkn = new StringTokenizer(_urlStr, " ", true);
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            noSpaces = token.equals(" ") ? String.valueOf(noSpaces) + "%20" : String.valueOf(noSpaces) + token;
        }
        String noAnds = "";
        tkn = new StringTokenizer(noSpaces, "&", true);
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            noAnds = token.equals("&") ? String.valueOf(noAnds) + "%26" : String.valueOf(noAnds) + token;
        }
        return noAnds;
    }
}

