/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.colos.ejs.library.control.ConstantParser;

public class JSliderDouble
extends JSlider {
    public static final int RESOLUTION = 100000;
    private boolean interactiveChange = true;
    private boolean outOfLimits = false;
    private int ticks = 0;
    private double scale;
    private double minimum;
    private double maximum = Double.NaN;
    private TitledBorder titledBorder;
    private EtchedBorder etchedBorder;
    private DecimalFormat format = null;
    private DecimalFormat ticksFormat = null;
    private Color currentColor = null;
    private double doubleValue;
    ChangeListener listener;

    public JSliderDouble(ChangeListener _additionalChangeListener) {
        this.listener = _additionalChangeListener;
        this.setPaintLabels(false);
        this.setPaintTicks(false);
        this.setPaintTrack(true);
        this.setMinimum(0);
        this.setMaximum(100000);
        this.setValue(0);
        this.doubleValue = 0.0;
        this.setForeground(Color.BLACK);
        this.etchedBorder = new EtchedBorder(1);
        this.titledBorder = new TitledBorder(this.etchedBorder, "");
        this.titledBorder.setTitleJustification(2);
        this.setBorder(this.etchedBorder);
        this.minimum = 0.0;
        this.setDoubleMaximum(1.0);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!JSliderDouble.this.outOfLimits) {
                    JSliderDouble.this.doubleValue = JSliderDouble.this.minimum + (double)JSliderDouble.this.getValue() / JSliderDouble.this.scale;
                }
                if (JSliderDouble.this.format != null) {
                    JSliderDouble.this.titledBorder.setTitle(JSliderDouble.this.format.format(JSliderDouble.this.doubleValue));
                    JSliderDouble.this.repaint();
                }
                JSliderDouble.this.listener.stateChanged(evt);
            }
        });
    }

    public boolean isInteractiveChange() {
        return this.interactiveChange;
    }

    public void setDoubleValue(double value) {
        this.doubleValue = value;
        int intValue = (int)((value - this.minimum) * this.scale);
        if (intValue < 0 || intValue > 100000) {
            this.outOfLimits = true;
            this.setValue(intValue);
            this.outOfLimits = false;
        } else {
            this.setValue(intValue);
        }
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public double getDoubleMinimum() {
        return this.minimum;
    }

    public void setDoubleMinimum(double val) {
        if (val == this.minimum) {
            return;
        }
        this.minimum = val;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.recomputeTicks();
        this.interactiveChange = false;
        this.setDoubleValue(this.doubleValue);
        this.interactiveChange = true;
    }

    public double getDoubleMaximum() {
        return this.maximum;
    }

    public void setDoubleMaximum(double val) {
        if (val == this.maximum) {
            return;
        }
        this.maximum = val;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.recomputeTicks();
        this.interactiveChange = false;
        this.setDoubleValue(this.doubleValue);
        this.interactiveChange = true;
    }

    public void setTicksFormat(DecimalFormat _format) {
        if (_format == null) {
            this.ticksFormat = null;
            this.setPaintLabels(false);
        } else {
            if (_format.equals(this.ticksFormat)) {
                return;
            }
            this.ticksFormat = _format;
            this.setPaintLabels(true);
        }
        this.recomputeTicks();
    }

    public void setNumberOfTicks(int _ticks) {
        if (_ticks == this.ticks) {
            return;
        }
        this.ticks = _ticks;
        this.recomputeTicks();
    }

    public void setTitleFormat(DecimalFormat _format) {
        if (_format == null) {
            this.format = null;
            this.setBorder(this.etchedBorder);
            return;
        }
        if (_format.equals(this.format)) {
            return;
        }
        this.format = _format;
        this.titledBorder.setTitle(this.format.format(this.getDoubleValue()));
        this.setBorder(this.titledBorder);
        this.repaint();
    }

    public void setTitleFormat(String _formatStr) {
        this.setTitleFormat((DecimalFormat)ConstantParser.formatConstant(_formatStr).getObject());
    }

    public void setTitleFont(Font aFont) {
        this.titledBorder.setTitleFont(aFont);
    }

    public void setTitleForeground(Color aColor) {
        this.titledBorder.setTitleColor(aColor);
        Dictionary labels = this.getLabelTable();
        if (labels != null) {
            Enumeration e = labels.elements();
            while (e.hasMoreElements()) {
                Object object = e.nextElement();
                if (!(object instanceof JLabel)) continue;
                ((JLabel)object).setForeground(aColor);
            }
        }
        this.currentColor = aColor;
    }

    private void recomputeTicks() {
        if (this.ticks < 2) {
            this.setPaintTicks(false);
            return;
        }
        int spacing = 100000 / (this.ticks - 1);
        this.setMinorTickSpacing(spacing);
        this.setMajorTickSpacing(2 * spacing);
        this.setPaintTicks(true);
        if (this.ticksFormat != null) {
            Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
            int i = 0;
            while (i <= 100000) {
                table.put(new Integer(i), new JLabel(this.ticksFormat.format(this.minimum + (double)i / this.scale)));
                i += 2 * spacing;
            }
            this.setLabelTable(table);
        }
        if (this.currentColor != null) {
            this.setTitleForeground(this.currentColor);
        }
    }
}

