/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.JSliderDouble;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

public class ControlSlider
extends ControlSwingElement {
    protected static final int SLIDER_ADDED = 12;
    protected static final int MY_FONT = 20;
    protected static final int MY_FOREGROUND = 18;
    private static final int VARIABLE = 0;
    private static final int VALUE = 1;
    protected JSliderDouble slider;
    private boolean defaultValueSet;
    private double defaultValue;
    private String formatStr;
    private DoubleValue internalValue;
    private boolean interactiveChange = true;
    private boolean mustSetClosest = false;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.slider = new JSliderDouble(new MyChangeListener());
        this.defaultValue = 0.0;
        this.defaultValueSet = false;
        this.formatStr = null;
        this.internalValue = new DoubleValue(this.defaultValue);
        this.internalValue.value = this.slider.getDoubleValue();
        this.slider.addMouseListener(new MyMouseListener());
        return this.slider;
    }

    @Override
    public void reset() {
        if (this.mustSetClosest) {
            this.slider.setSnapToTicks(true);
            this.mustSetClosest = false;
        }
        if (this.defaultValueSet) {
            this.interactiveChange = false;
            this.internalValue.value = this.defaultValue;
            this.slider.setDoubleValue(this.internalValue.value);
            this.interactiveChange = true;
            this.variableChanged(0, this.internalValue);
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("format");
            infoList.add("ticks");
            infoList.add("ticksFormat");
            infoList.add("closest");
            infoList.add("orientation");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("action")) {
            return "releaseAction";
        }
        if (_property.equals("pressaction")) {
            return "pressAction";
        }
        if (_property.equals("dragaction")) {
            return "dragAction";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "int|double";
        }
        if (_property.equals("value")) {
            return "int|double CONSTANT";
        }
        if (_property.equals("minimum")) {
            return "int|double";
        }
        if (_property.equals("maximum")) {
            return "int|double";
        }
        if (_property.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("format")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("ticks")) {
            return "int";
        }
        if (_property.equals("ticksFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("closest")) {
            return "boolean";
        }
        if (_property.equals("orientation")) {
            return "Orientation|int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.internalValue.value == _value.getDouble()) break;
                this.interactiveChange = false;
                this.internalValue.value = _value.getDouble();
                this.slider.setDoubleValue(this.internalValue.value);
                this.interactiveChange = true;
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = _value.getDouble();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.slider.setDoubleMinimum(_value.getDouble());
                break;
            }
            case 3: {
                this.slider.setDoubleMaximum(_value.getDouble());
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 5: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 7: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.formatStr = null;
                    this.slider.setTitleFormat((DecimalFormat)_value.getObject());
                    break;
                }
                String newFormatStr = TeXParser.parseTeX(_value.getString());
                if (newFormatStr.equals(this.formatStr)) {
                    return;
                }
                this.formatStr = newFormatStr;
                this.slider.setTitleFormat(this.formatStr);
                break;
            }
            case 8: {
                this.slider.setNumberOfTicks(_value.getInteger());
                break;
            }
            case 9: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.slider.setTicksFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.slider.setTicksFormat((DecimalFormat)ConstantParser.formatConstant(TeXParser.parseTeX(_value.getString())).getObject());
                break;
            }
            case 10: {
                if (this.editorIsReading()) {
                    this.mustSetClosest = _value.getBoolean();
                    break;
                }
                this.slider.setSnapToTicks(_value.getBoolean());
                break;
            }
            case 11: {
                if (this.slider.getOrientation() == _value.getInteger()) break;
                this.slider.setOrientation(_value.getInteger());
                break;
            }
            default: {
                super.setValue(_index - 12, _value);
                break;
            }
            case 20: {
                if (_value.getObject() instanceof Font) {
                    this.slider.setTitleFont((Font)_value.getObject());
                }
                super.setValue(8, _value);
                break;
            }
            case 18: {
                if (_value.getObject() instanceof Color) {
                    this.slider.setTitleForeground((Color)_value.getObject());
                }
                super.setValue(6, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.slider.setDoubleMinimum(0.0);
                break;
            }
            case 3: {
                this.slider.setDoubleMaximum(1.0);
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 5: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 7: {
                this.slider.setTitleFormat((DecimalFormat)null);
                this.formatStr = null;
                break;
            }
            case 8: {
                this.slider.setNumberOfTicks(0);
                break;
            }
            case 9: {
                this.slider.setPaintLabels(false);
                break;
            }
            case 10: {
                this.slider.setSnapToTicks(false);
                break;
            }
            case 11: {
                this.slider.setOrientation(0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 12);
                break;
            }
            case 20: {
                this.slider.setTitleFont(this.myDefaultFont);
                super.setDefaultValue(8);
                break;
            }
            case 18: {
                this.slider.setTitleForeground(this.myDefaultFrgd);
                super.setDefaultValue(6);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return "<none>";
            }
            case 2: {
                return "0.0";
            }
            case 3: {
                return "1.0";
            }
            case 4: 
            case 5: 
            case 6: {
                return "<no_action>";
            }
            case 7: {
                return "<none>";
            }
            case 8: {
                return "0";
            }
            case 9: {
                return "<none>";
            }
            case 10: {
                return "false";
            }
            case 11: {
                return "HORIZONTAL";
            }
        }
        return super.getDefaultValueString(_index - 12);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(_index - 12);
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ControlSlider.this.slider.isInteractiveChange() && ControlSlider.this.interactiveChange) {
                ((ControlSlider)ControlSlider.this).internalValue.value = ControlSlider.this.slider.getDoubleValue();
                ControlSlider.this.variableChanged(0, ControlSlider.this.internalValue);
                if (ControlSlider.this.isUnderEjs) {
                    ControlSlider.this.setFieldListValueWithAlternative(0, 1, ControlSlider.this.internalValue);
                }
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (ControlSlider.this.slider.isEnabled()) {
                ControlSlider.this.invokeActions(10);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (ControlSlider.this.slider.isEnabled()) {
                ControlSlider.this.invokeActions(0);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControlSlider.this.interactiveChange = false;
                    ((MyMouseListener)MyMouseListener.this).ControlSlider.this.slider.setDoubleValue(((ControlSlider)((MyMouseListener)MyMouseListener.this).ControlSlider.this).internalValue.value);
                    ControlSlider.this.interactiveChange = true;
                    ((MyMouseListener)MyMouseListener.this).ControlSlider.this.slider.repaint();
                }
            });
        }
    }
}

