/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;

public abstract class ControlDrawable
extends ControlElement {
    public static final int DRAWABLE_NAME = 0;
    public static final int PARENT = 1;
    protected ControlParentOfDrawables myParent;
    private Drawable myDrawable = this.createDrawable();
    private String menuNameEntry = null;
    private static List<String> infoList = null;

    public ControlDrawable() {
        this.myObject = this.myDrawable;
    }

    protected abstract Drawable createDrawable();

    protected void setName(String _name) {
    }

    public final Drawable getDrawable() {
        return this.myDrawable;
    }

    public final void replaceDrawable(Drawable _dr) {
        if (this.myParent != null) {
            this.myParent.getDrawingPanel().replaceDrawable(this.myDrawable, _dr);
        }
        this.myDrawable = _dr;
        this.myObject = this.myDrawable;
    }

    public void setParent(ControlParentOfDrawables _dp) {
        if (this.myParent != null) {
            this.myParent.removeDrawable(this.myDrawable);
            if (this instanceof NeedsPreUpdate) {
                this.myParent.removeFromPreupdateList((NeedsPreUpdate)((Object)this));
            }
        }
        if (_dp != null) {
            int index = -1;
            String indexInParent = this.getProperty("_ejs_indexInParent_");
            if (indexInParent != null) {
                index = Integer.parseInt(indexInParent);
            }
            this.setProperty("_ejs_indexInParent_", null);
            if (index >= 0) {
                _dp.addDrawableAtIndex(index, this.myDrawable);
            } else {
                _dp.addDrawable(this.myDrawable);
            }
            if (this.isUnderEjs) {
                _dp.getDrawingPanel().render();
            }
            if (this instanceof NeedsPreUpdate) {
                _dp.addToPreupdateList((NeedsPreUpdate)((Object)this));
            }
            this.myParent = _dp;
        }
    }

    public final ControlParentOfDrawables getParent() {
        return this.myParent;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.myParent instanceof ControlDrawablesParent) {
            ((ControlDrawablesParent)this.myParent).getDrawingPanel().render();
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("menuName");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("name")) {
            return "String CONSTANT";
        }
        if (_property.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (_property.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        return null;
    }

    public String getMenuNameEntry() {
        if (this.menuNameEntry != null) {
            if (this.menuNameEntry.equals("null")) {
                return null;
            }
            return this.menuNameEntry;
        }
        return this.getProperty("name");
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setName(_value.getString());
                super.setValue(0, _value);
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null) {
                    this.setParent(null);
                }
                if ((parent = this.myGroup.getElement(_value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> not found for " + this.toString());
                    break;
                }
                if (parent instanceof ControlParentOfDrawables) {
                    this.setParent((ControlParentOfDrawables)((Object)parent));
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> is not a ControlParentOfDrawables");
                break;
            }
            case 2: {
                this.menuNameEntry = _value.getString();
                this.setName(this.menuNameEntry);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.setName("");
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.menuNameEntry = null;
                break;
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "";
            }
            case 1: {
                return "null";
            }
            case 2: {
                return this.getProperty("name");
            }
        }
        return super.getDefaultValueString(_index - 3);
    }

    @Override
    public Value getValue(int _index) {
        return null;
    }
}

