/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.JProgressBarDouble;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

public class ControlBar
extends ControlSwingElement {
    protected JProgressBarDouble bar;
    private String formatStr = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.bar = new JProgressBarDouble(0);
        return this.bar;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("format");
            infoList.add("orientation");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "int|double";
        }
        if (_property.equals("minimum")) {
            return "int|double";
        }
        if (_property.equals("maximum")) {
            return "int|double";
        }
        if (_property.equals("format")) {
            return "Format|Object|String  TRANSLATABLE";
        }
        if (_property.equals("orientation")) {
            return "Orientation|int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.bar.setDoubleValue(_value.getDouble());
                break;
            }
            case 1: {
                this.bar.setDoubleMinimum(_value.getDouble());
                break;
            }
            case 2: {
                this.bar.setDoubleMaximum(_value.getDouble());
                break;
            }
            case 3: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.formatStr = null;
                    this.bar.setFormat((DecimalFormat)_value.getObject());
                    break;
                }
                String newFormatStr = TeXParser.parseTeX(_value.getString());
                if (newFormatStr.equals(this.formatStr)) {
                    return;
                }
                this.formatStr = newFormatStr;
                this.bar.setFormat((DecimalFormat)ConstantParser.formatConstant(this.formatStr).getObject());
                break;
            }
            case 4: {
                if (this.bar.getOrientation() == _value.getInteger()) break;
                this.bar.setOrientation(_value.getInteger());
                break;
            }
            default: {
                super.setValue(_index - 5, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.bar.setDoubleMinimum(0.0);
                break;
            }
            case 2: {
                this.bar.setDoubleMaximum(1.0);
                break;
            }
            case 3: {
                this.formatStr = null;
                this.bar.setFormat((DecimalFormat)null);
                break;
            }
            case 4: {
                this.bar.setOrientation(0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 5);
            }
        }
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(_index - 5);
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "1.0";
            }
            case 3: {
                return "<none>";
            }
            case 4: {
                return "HORIZONTAL";
            }
        }
        return super.getDefaultValueString(_index - 5);
    }
}

