/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.MultiTrail;
import org.opensourcephysics.tools.ToolForData;

public class ControlTrail3D
extends ControlElement3D
implements NeedsPreUpdate,
Resetable,
DataCollector {
    private static final int TRAIL3D_PROPERTIES_ADDED = 12;
    private MultiTrail trail;
    private boolean isSet = false;
    private double x;
    private double y;
    private double z;
    private double[] xArray = null;
    private double[] yArray = null;
    private double[] zArray = null;
    private static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.MultiTrail";
    }

    @Override
    protected Element createElement() {
        this.trail = new MultiTrail();
        return this.trail;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 12;
    }

    @Override
    public void reset() {
        this.trail.clear();
    }

    @Override
    public void initialize() {
        this.trail.initialize();
    }

    @Override
    public void preupdate() {
        if (!this.trail.isActive()) {
            return;
        }
        if (this.isSet) {
            if (this.xArray == null) {
                if (this.yArray == null) {
                    if (this.zArray == null) {
                        this.trail.addPoint(this.x, this.y, this.z);
                    } else {
                        this.trail.addPoints(this.x, this.y, this.zArray);
                    }
                } else if (this.zArray == null) {
                    this.trail.addPoints(this.x, this.yArray, this.z);
                } else {
                    this.trail.addPoints(this.x, this.yArray, this.zArray);
                }
            } else if (this.yArray == null) {
                if (this.zArray == null) {
                    this.trail.addPoints(this.xArray, this.y, this.z);
                } else {
                    this.trail.addPoints(this.xArray, this.y, this.zArray);
                }
            } else if (this.zArray == null) {
                this.trail.addPoints(this.xArray, this.yArray, this.z);
            } else {
                this.trail.addPoints(this.xArray, this.yArray, this.zArray);
            }
        }
        this.isSet = false;
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlTrail3D.getDataInformationMenuEntries(this.getTopWindow(), this.trail));
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("maximumPoints");
            infoList.add("connected");
            infoList.add("inputX");
            infoList.add("inputY");
            infoList.add("inputZ");
            infoList.add("skippoints");
            infoList.add("active");
            infoList.add("norepeat");
            infoList.add("clearAtInput");
            infoList.add("xLabel");
            infoList.add("yLabel");
            infoList.add("zLabel");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("maximumPoints")) {
            return "int";
        }
        if (_property.equals("connected")) {
            return "boolean";
        }
        if (_property.equals("inputX")) {
            return "int|double|double[]";
        }
        if (_property.equals("inputY")) {
            return "int|double|double[]";
        }
        if (_property.equals("inputZ")) {
            return "int|double|double[]";
        }
        if (_property.equals("skippoints")) {
            return "int";
        }
        if (_property.equals("active")) {
            return "boolean";
        }
        if (_property.equals("norepeat")) {
            return "boolean";
        }
        if (_property.equals("clearAtInput")) {
            return "boolean";
        }
        if (_property.equals("xLabel")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("yLabel")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("zLabel")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public ControlElement setProperty(String _property, String _value) {
        _property = _property.trim();
        if (_value != null) {
            boolean useDefaultTitle;
            boolean bl = useDefaultTitle = _value.startsWith("%_model.") && _value.endsWith("()%");
            if (_property.equals("inputX")) {
                this.trail.setXLabel(useDefaultTitle ? "Input X" : _value);
            } else if (_property.equals("inputY")) {
                this.trail.setYLabel(useDefaultTitle ? "Input Y" : _value);
            } else if (_property.equals("inputZ")) {
                this.trail.setYLabel(useDefaultTitle ? "Input Z" : _value);
            }
        }
        return super.setProperty(_property, _value);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.trail.setMaximumPoints(_value.getInteger());
                break;
            }
            case 1: {
                this.trail.setConnectionType(_value.getBoolean() ? 1 : 0);
                break;
            }
            case 2: {
                if (_value.getObject() instanceof double[]) {
                    this.xArray = (double[])_value.getObject();
                } else {
                    this.x = _value.getDouble();
                    this.xArray = null;
                }
                this.isSet = true;
                break;
            }
            case 3: {
                if (_value.getObject() instanceof double[]) {
                    this.yArray = (double[])_value.getObject();
                } else {
                    this.y = _value.getDouble();
                    this.yArray = null;
                }
                this.isSet = true;
                break;
            }
            case 4: {
                if (_value.getObject() instanceof double[]) {
                    this.zArray = (double[])_value.getObject();
                } else {
                    this.z = _value.getDouble();
                    this.zArray = null;
                }
                this.isSet = true;
                break;
            }
            case 5: {
                this.trail.setSkipPoints(_value.getInteger());
                break;
            }
            case 6: {
                this.trail.setActive(_value.getBoolean());
                break;
            }
            case 7: {
                this.trail.setNoRepeat(_value.getBoolean());
                break;
            }
            case 8: {
                this.trail.setClearAtInput(_value.getBoolean());
                break;
            }
            case 9: {
                this.trail.setXLabel(_value.getString());
                break;
            }
            case 10: {
                this.trail.setYLabel(_value.getString());
                break;
            }
            case 11: {
                this.trail.setZLabel(_value.getString());
                break;
            }
            default: {
                super.setValue(_index - 12, _value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.trail.setMaximumPoints(0);
                break;
            }
            case 1: {
                this.trail.setConnectionType(1);
                break;
            }
            case 2: {
                this.x = 0.0;
                this.xArray = null;
                break;
            }
            case 3: {
                this.y = 0.0;
                this.yArray = null;
                break;
            }
            case 4: {
                this.z = 0.0;
                this.zArray = null;
                break;
            }
            case 5: {
                this.trail.setSkipPoints(0);
                break;
            }
            case 6: {
                this.trail.setActive(true);
                break;
            }
            case 7: {
                this.trail.setNoRepeat(false);
                break;
            }
            case 8: {
                this.trail.setClearAtInput(false);
                break;
            }
            case 9: {
                this.trail.setXLabel(null);
                break;
            }
            case 10: {
                this.trail.setYLabel(null);
                break;
            }
            case 11: {
                this.trail.setZLabel(null);
                break;
            }
            default: {
                super.setDefaultValue(_index - 12);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(_index - 12);
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "0";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "0.0";
            }
            case 3: {
                return "0.0";
            }
            case 4: {
                return "0.0";
            }
            case 5: {
                return "0";
            }
            case 6: {
                return "true";
            }
            case 7: {
                return "false";
            }
            case 8: {
                return "false";
            }
            case 9: {
                return "<none>";
            }
            case 10: {
                return "<none>";
            }
            case 11: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(_index - 12);
    }
}

