/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.drawing3d.ControlGroup3D;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.Set;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.utils.Resolution;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Transformation;
import org.opensourcephysics.tools.ToolForData;

public abstract class ControlSet3D
extends ControlElement3D {
    protected static final int SET3D_ADDED = 2;
    protected static final int NUM_ELEMENTS = 0;
    protected static final int ELEMENT_SELECTED = 1;
    protected Set set;
    protected Element[] elements;
    protected int numElements = 0;
    protected ObjectValue[] allposValues;
    protected ObjectValue[] allsizesValues;
    protected IntegerValue selectedValue = new IntegerValue(-1);
    protected double[] theXs;
    protected double[] theYs;
    protected double[] theZs;
    protected double[] theSizeXs;
    protected double[] theSizeYs;
    protected double[] theSizeZs;
    protected double[][] allThePos;
    protected double[][] allTheSizes;
    protected double lineWidth = 1.0;
    protected boolean numberOfElements_isSet = false;
    private boolean propagatingValue = false;
    protected double defaultElementX;
    protected double defaultElementY;
    protected double defaultElementZ;
    protected double defaultElementSizeX;
    protected double defaultElementSizeY;
    protected double defaultElementSizeZ;
    protected Color defElementLines;
    protected Paint defElementFill;
    private static List<String> infoList = null;
    int selectedElement = -1;

    public ControlSet3D() {
        this.checkNumberOfElements(1, true);
        this.defaultElementX = this.elements[0].getX();
        this.defaultElementY = this.elements[0].getY();
        this.defaultElementSizeX = this.elements[0].getSizeX();
        this.defaultElementSizeY = this.elements[0].getSizeY();
        this.defElementLines = this.elements[0].getStyle().getLineColor();
        this.defElementFill = this.elements[0].getStyle().getFillColor();
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.Set";
    }

    @Override
    protected Element createElement() {
        this.set = new Set();
        return this.set;
    }

    protected abstract Element createAnElement();

    protected abstract int getPropertiesAddedToSet();

    @Override
    protected final int getPropertiesDisplacement() {
        return this.getPropertiesAddedToSet() + 2;
    }

    protected void copyAnElement(Element oldElement, Element newElement) {
        oldElement.getStyle().copyTo(newElement.getStyle());
        newElement.setDataObject(oldElement.getDataObject());
        if (oldElement.getPanel() != null) {
            newElement.setPanel(oldElement.getPanel());
        }
        newElement.setName(oldElement.getName());
        newElement.setXYZ(oldElement.getX(), oldElement.getY(), oldElement.getZ());
        newElement.setSizeXYZ(oldElement.getSizeX(), oldElement.getSizeY(), oldElement.getSizeZ());
        newElement.setTransformation(oldElement.getTransformation());
        newElement.addSecondaryTransformations(oldElement.getSecondaryTransformations());
        newElement.setVisible(oldElement.isVisible());
        newElement.getInteractionTarget(0).setEnabled(oldElement.getInteractionTarget(0).getEnabled());
        newElement.getInteractionTarget(0).setAffectsGroup(oldElement.getInteractionTarget(0).getAffectsGroup());
        newElement.getInteractionTarget(1).setEnabled(oldElement.getInteractionTarget(1).getEnabled());
        newElement.getInteractionTarget(1).setAffectsGroup(oldElement.getInteractionTarget(1).getAffectsGroup());
    }

    protected final void checkNumberOfElements(int newNumber, boolean force) {
        if (this.numElements == newNumber && !force) {
            return;
        }
        if (newNumber < 1) {
            return;
        }
        this.setNumberOfElements(newNumber);
        EjsControl controlGroup = this.getGroup();
        if (controlGroup != null && !controlGroup.isReportingChange() && !this.propagatingValue) {
            this.propagatingValue = true;
            controlGroup.propagateValues();
            this.propagatingValue = false;
        }
    }

    protected void setNumberOfElements(int newNumber) {
        Element[] oldElements = this.elements;
        this.elements = new Element[newNumber];
        int i = 0;
        while (i < newNumber) {
            this.elements[i] = this.createAnElement();
            Element oldElement = null;
            if (i < this.numElements) {
                oldElement = oldElements[i];
            } else if (oldElements != null) {
                oldElement = oldElements[0];
            }
            if (oldElement != null) {
                this.copyAnElement(oldElement, this.elements[i]);
            }
            ++i;
        }
        this.set.removeAllElements();
        i = 0;
        while (i < newNumber) {
            this.set.addElement(this.elements[i]);
            this.elements[i].setName(String.valueOf(this.set.getName()) + "[" + i + "]");
            ++i;
        }
        this.theXs = new double[newNumber];
        this.theYs = new double[newNumber];
        this.theZs = new double[newNumber];
        this.theSizeXs = new double[newNumber];
        this.theSizeYs = new double[newNumber];
        this.theSizeZs = new double[newNumber];
        i = 0;
        while (i < newNumber) {
            this.theXs[i] = this.elements[i].getX();
            this.theYs[i] = this.elements[i].getY();
            this.theZs[i] = this.elements[i].getZ();
            this.theSizeXs[i] = this.elements[i].getSizeX();
            this.theSizeYs[i] = this.elements[i].getSizeY();
            this.theSizeZs[i] = this.elements[i].getSizeZ();
            this.elements[i].addInteractionListener(this);
            ++i;
        }
        this.allposValues = new ObjectValue[3];
        this.allsizesValues = new ObjectValue[3];
        this.allposValues[0] = new ObjectValue(this.theXs);
        this.allposValues[1] = new ObjectValue(this.theYs);
        this.allposValues[2] = new ObjectValue(this.theZs);
        this.allsizesValues[0] = new ObjectValue(this.theSizeXs);
        this.allsizesValues[1] = new ObjectValue(this.theSizeYs);
        this.allsizesValues[2] = new ObjectValue(this.theSizeZs);
        this.numElements = newNumber;
        oldElements = null;
    }

    public Element elementAt(int i) {
        return this.elements[i];
    }

    @Override
    public void reset() {
        this.set.clear();
    }

    @Override
    public void initialize() {
        this.set.initialize();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        int i = 0;
        while (i < this.numElements) {
            this.elements[i].setName(String.valueOf(name) + "[" + i + "]");
            ++i;
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("numberOfElements");
            infoList.add("elementSelected");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("numberOfElements")) {
            return "int PREVIOUS";
        }
        if (_property.equals("elementSelected")) {
            return "int";
        }
        if (_property.equals("x")) {
            return "int|double|double[]";
        }
        if (_property.equals("y")) {
            return "int|double|double[]";
        }
        if (_property.equals("z")) {
            return "int|double|double[]";
        }
        if (_property.equals("sizeX")) {
            return "int|double|double[]";
        }
        if (_property.equals("sizeY")) {
            return "int|double|double[]";
        }
        if (_property.equals("sizeZ")) {
            return "int|double|double[]";
        }
        if (_property.equals("transformation")) {
            return "3DTransformation|double[]|String|Object|Object[]";
        }
        if (_property.equals("visible")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("lineColor")) {
            return "int|int[]|Color|Color[]|Object|Object[]";
        }
        if (_property.equals("lineWidth")) {
            return "int|double|double[]";
        }
        if (_property.equals("fillColor")) {
            return "int|int[]|Color|Color[]|Object|Object[]";
        }
        if (_property.equals("resolution")) {
            return "3DResolution|String|Object|Object[]|double";
        }
        if (_property.equals("drawingFill")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("drawingLines")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("enabledPosition")) {
            return "Interaction3D|int|int[]|boolean|boolean[]";
        }
        if (_property.equals("movesGroup")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("enabledSize")) {
            return "Interaction3D|int|int[]|boolean|boolean[]";
        }
        if (_property.equals("resizesGroup")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("sensitivity")) {
            return "int|int[]";
        }
        if (_property.equals("position")) {
            return "double[][]";
        }
        if (_property.equals("size")) {
            return "double[][]";
        }
        if (_property.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("elementposition")) {
            return "ArrowPosition|int|int[]";
        }
        if (_property.equals("depthFactor")) {
            return "double|double[]";
        }
        if (_property.equals("measured")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("extraColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (_property.equals("numberOfElements")) {
            return "int PREVIOUS";
        }
        if (_property.equals("elementSelected")) {
            return "int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public ControlElement setProperty(String _property, String _value) {
        _property = _property.trim();
        if (_value != null) {
            boolean useDefaultTitle;
            boolean bl = useDefaultTitle = _value.startsWith("%_model.") && _value.endsWith("()%");
            if (_property.equals("x")) {
                this.set.setXLabel(useDefaultTitle ? "x" : _value);
            } else if (_property.equals("y")) {
                this.set.setYLabel(useDefaultTitle ? "y" : _value);
            } else if (_property.equals("z")) {
                this.set.setYLabel(useDefaultTitle ? "z" : _value);
            }
        }
        return super.setProperty(_property, _value);
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlSet3D.getDataInformationMenuEntries(this.getTopWindow(), this.set));
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getInteger() != this.numElements) {
                    this.checkNumberOfElements(_value.getInteger(), true);
                }
                this.numberOfElements_isSet = true;
                break;
            }
            case 1: {
                this.selectedValue.value = _value.getInteger();
            }
        }
        switch (_index -= 2) {
            case 2: {
                this.allThePos = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theXs.length, val.length);
                    while (i < n) {
                        this.theXs[i] = val[i];
                        this.elements[i].setX(this.theXs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theXs.length;
                    while (i < n) {
                        this.theXs[i] = val;
                        this.elements[i].setX(this.theXs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                this.allThePos = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theYs.length, val.length);
                    while (i < n) {
                        this.theYs[i] = val[i];
                        this.elements[i].setY(this.theYs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theYs.length;
                    while (i < n) {
                        this.theYs[i] = val;
                        this.elements[i].setY(this.theYs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                this.allThePos = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theZs.length, val.length);
                    while (i < n) {
                        this.theZs[i] = val[i];
                        this.elements[i].setZ(this.theZs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theZs.length;
                    while (i < n) {
                        this.theZs[i] = val;
                        this.elements[i].setZ(this.theZs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 26: {
                if (!(_value.getObject() instanceof double[][])) break;
                this.allThePos = (double[][])_value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allThePos.length, false);
                }
                int i = 0;
                int n = Math.min(this.numElements, this.allThePos.length);
                while (i < n) {
                    double[] point = this.allThePos[i];
                    this.theXs[i] = point[0];
                    this.theYs[i] = point[1];
                    this.theZs[i] = point[2];
                    this.elements[i].setXYZ(this.theXs[i], this.theYs[i], this.theZs[i]);
                    ++i;
                }
                break;
            }
            case 5: {
                this.allTheSizes = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theSizeXs.length, val.length);
                    while (i < n) {
                        this.theSizeXs[i] = val[i];
                        this.elements[i].setSizeX(this.theSizeXs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theSizeXs.length;
                    while (i < n) {
                        this.theSizeXs[i] = val;
                        this.elements[i].setSizeX(this.theSizeXs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 6: {
                this.allTheSizes = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theSizeYs.length, val.length);
                    while (i < n) {
                        this.theSizeYs[i] = val[i];
                        this.elements[i].setSizeY(this.theSizeYs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theSizeYs.length;
                    while (i < n) {
                        this.theSizeYs[i] = val;
                        this.elements[i].setSizeY(this.theSizeYs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 7: {
                this.allTheSizes = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theSizeZs.length, val.length);
                    while (i < n) {
                        this.theSizeZs[i] = val[i];
                        this.elements[i].setSizeZ(this.theSizeZs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theSizeZs.length;
                    while (i < n) {
                        this.theSizeZs[i] = val;
                        this.elements[i].setSizeZ(this.theSizeZs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 27: {
                if (!(_value.getObject() instanceof double[][])) break;
                this.allTheSizes = (double[][])_value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allTheSizes.length, false);
                }
                int i = 0;
                int n = Math.min(this.numElements, this.allTheSizes.length);
                while (i < n) {
                    double[] size = this.allTheSizes[i];
                    this.theSizeXs[i] = size[0];
                    this.theSizeYs[i] = size[1];
                    this.theSizeZs[i] = size[2];
                    this.elements[i].setSizeXYZ(this.theSizeXs[i], this.theSizeYs[i], this.theSizeZs[i]);
                    ++i;
                }
                break;
            }
            case 8: {
                if (_value.getObject() instanceof Transformation) {
                    Transformation transf = (Transformation)_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].setTransformation(transf);
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].setTransformation((Transformation)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof double[])) break;
                    double[] array = (double[])_value.getObject();
                    if (array.length == 6) {
                        double[] v1 = new double[]{array[0], array[1], array[2]};
                        double[] v2 = new double[]{array[3], array[4], array[5]};
                        Matrix3DTransformation transf = Matrix3DTransformation.createAlignmentTransformation(v1, v2);
                        int i = 0;
                        while (i < this.numElements) {
                            this.elements[i].setTransformation(transf);
                            ++i;
                        }
                    } else {
                        if (array.length != 4) break;
                        double[] v = new double[]{array[1], array[2], array[3]};
                        Matrix3DTransformation transf = Matrix3DTransformation.rotation(array[0], v);
                        int i = 0;
                        while (i < this.numElements) {
                            this.elements[i].setTransformation(transf);
                            ++i;
                        }
                    }
                }
                break;
            }
            case 9: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].setVisible(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].setVisible(val);
                        ++i;
                    }
                }
                break;
            }
            case 10: {
                if (_value instanceof IntegerValue) {
                    Color col = DisplayColors.getLineColor(_value.getInteger());
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getStyle().setLineColor(col);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setLineColor(DisplayColors.getLineColor(val[i]));
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setLineColor((Color)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color)) break;
                    Color val = (Color)_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getStyle().setLineColor(val);
                        ++i;
                    }
                }
                break;
            }
            case 11: {
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setLineWidth((float)val[i]);
                        ++i;
                    }
                } else {
                    float val = (float)_value.getDouble();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].getStyle().setLineWidth(val);
                        ++i;
                    }
                }
                break;
            }
            case 12: {
                if (_value instanceof IntegerValue) {
                    Color col = DisplayColors.getLineColor(_value.getInteger());
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getStyle().setFillColor(col);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setFillColor(DisplayColors.getLineColor(val[i]));
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setFillColor((Color)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color)) break;
                    Color val = (Color)_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getStyle().setFillColor(val);
                        ++i;
                    }
                }
                break;
            }
            case 13: {
                if (_value.getObject() instanceof Resolution) {
                    Resolution res = (Resolution)_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getStyle().setResolution(res);
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setResolution((Resolution)val[i]);
                        ++i;
                    }
                } else {
                    Resolution res = ControlSet3D.decodeResolution(_value.toString());
                    if (res == null) break;
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getStyle().setResolution(res);
                        ++i;
                    }
                }
                break;
            }
            case 14: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setDrawingFill(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].getStyle().setDrawingFill(val);
                        ++i;
                    }
                }
                break;
            }
            case 15: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setDrawingLines(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].getStyle().setDrawingLines(val);
                        ++i;
                    }
                }
                break;
            }
            case 16: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(0).setEnabled(val[i]);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(0).setEnabled(val[i]);
                        ++i;
                    }
                } else if (_value instanceof BooleanValue) {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getInteractionTarget(0).setEnabled(val);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getInteractionTarget(0).setEnabled(val);
                        ++i;
                    }
                }
                break;
            }
            case 17: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(0).setAffectsGroup(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].getInteractionTarget(0).setAffectsGroup(val);
                        ++i;
                    }
                }
                break;
            }
            case 18: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(1).setEnabled(val[i]);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(1).setEnabled(val[i]);
                        ++i;
                    }
                } else if (_value instanceof BooleanValue) {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getInteractionTarget(1).setEnabled(val);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getInteractionTarget(1).setEnabled(val);
                        ++i;
                    }
                }
                break;
            }
            case 19: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getInteractionTarget(1).setAffectsGroup(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].getInteractionTarget(1).setAffectsGroup(val);
                        ++i;
                    }
                }
                break;
            }
            case 20: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setSensitivity(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].getStyle().setSensitivity(val);
                        ++i;
                    }
                }
                break;
            }
            case 29: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        if (this.elements[i].getStyle().getRelativePosition() != val[i]) {
                            this.elements[i].getStyle().setRelativePosition(val[i]);
                        }
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        if (this.elements[i].getStyle().getRelativePosition() != val) {
                            this.elements[i].getStyle().setRelativePosition(val);
                        }
                        ++i;
                    }
                }
                break;
            }
            case 30: {
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setDepthFactor(val[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].getStyle().setDepthFactor(val);
                        ++i;
                    }
                }
                break;
            }
            case 31: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].setCanBeMeasured(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    int n = this.numElements;
                    while (i < n) {
                        this.elements[i].setCanBeMeasured(val);
                        ++i;
                    }
                }
                break;
            }
            case 32: {
                if (_value instanceof IntegerValue) {
                    Color col = DisplayColors.getLineColor(_value.getInteger());
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getStyle().setExtraColor(col);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setExtraColor(DisplayColors.getLineColor(val[i]));
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.numElements, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setExtraColor((Color)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color)) break;
                    Color val = (Color)_value.getObject();
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].getStyle().setExtraColor(val);
                        ++i;
                    }
                }
                break;
            }
            case 37: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorOrigin((double[])_value.getObject());
                    ++i;
                }
                break;
            }
            case 38: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorDirection((double[])_value.getObject());
                    ++i;
                }
                break;
            }
            case 39: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorRegions((double[])_value.getObject());
                    ++i;
                }
                break;
            }
            case 40: {
                if (_value.getObject() instanceof int[]) {
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].setColorPalette((int[])_value.getObject());
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color[])) break;
                    int i = 0;
                    while (i < this.numElements) {
                        this.elements[i].setColorPalette((Color[])_value.getObject());
                        ++i;
                    }
                }
                break;
            }
            case 41: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorBelowWhenEqual(_value.getBoolean());
                    ++i;
                }
                break;
            }
            default: {
                super.setValue(_index, _value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.setNumberOfElements(1);
                this.numberOfElements_isSet = false;
                break;
            }
            case 1: {
                this.selectedValue.value = -1;
                break;
            }
            default: {
                super.setDefaultValue(_index - 2);
            }
        }
        switch (_index -= 2) {
            case 2: {
                int i = 0;
                int n = this.theXs.length;
                while (i < n) {
                    this.theXs[i] = this.defaultX;
                    this.elements[i].setX(this.theXs[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                int n = this.theYs.length;
                while (i < n) {
                    this.theYs[i] = this.defaultY;
                    this.elements[i].setY(this.theYs[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                int n = this.theZs.length;
                while (i < n) {
                    this.theZs[i] = this.defaultZ;
                    this.elements[i].setZ(this.theZs[i]);
                    ++i;
                }
                break;
            }
            case 26: {
                this.allThePos = null;
                break;
            }
            case 5: {
                int i = 0;
                int n = this.theSizeXs.length;
                while (i < n) {
                    this.theSizeXs[i] = this.defaultSizeX;
                    this.elements[i].setSizeX(this.theSizeXs[i]);
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                int n = this.theSizeYs.length;
                while (i < n) {
                    this.theSizeYs[i] = this.defaultSizeY;
                    this.elements[i].setSizeY(this.theSizeYs[i]);
                    ++i;
                }
                break;
            }
            case 7: {
                int i = 0;
                int n = this.theSizeZs.length;
                while (i < n) {
                    this.theSizeZs[i] = this.defaultSizeZ;
                    this.elements[i].setSizeZ(this.theSizeZs[i]);
                    ++i;
                }
                break;
            }
            case 27: {
                this.allTheSizes = null;
                break;
            }
            case 8: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setTransformation(null);
                    ++i;
                }
                break;
            }
            case 9: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setVisible(true);
                    ++i;
                }
                break;
            }
            case 10: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setLineColor(this.defLines);
                    ++i;
                }
                break;
            }
            case 11: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setLineWidth(1.0f);
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setFillColor(this.defFill);
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setResolution(this.defaultRes);
                    ++i;
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setDrawingFill(true);
                    ++i;
                }
                break;
            }
            case 15: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setDrawingLines(true);
                    ++i;
                }
                break;
            }
            case 16: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getInteractionTarget(0).setEnabled(false);
                    ++i;
                }
                break;
            }
            case 17: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getInteractionTarget(0).setAffectsGroup(false);
                    ++i;
                }
                break;
            }
            case 18: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getInteractionTarget(1).setEnabled(false);
                    ++i;
                }
                break;
            }
            case 19: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getInteractionTarget(1).setAffectsGroup(false);
                    ++i;
                }
                break;
            }
            case 20: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setSensitivity(5);
                    ++i;
                }
                break;
            }
            case 29: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setRelativePosition(5);
                    ++i;
                }
                break;
            }
            case 30: {
                int i = 0;
                int n = this.numElements;
                while (i < n) {
                    this.elements[i].getStyle().setDepthFactor(1.0);
                    ++i;
                }
                break;
            }
            case 31: {
                int i = 0;
                int n = this.numElements;
                while (i < n) {
                    this.elements[i].setCanBeMeasured(true);
                    ++i;
                }
                break;
            }
            case 32: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].getStyle().setExtraColor(this.defExtraColor);
                    ++i;
                }
                break;
            }
            case 37: {
                double[] colorOrigin = new double[]{0.0, 0.0, 0.0};
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorOrigin(colorOrigin);
                    ++i;
                }
                break;
            }
            case 38: {
                double[] colorDirection = new double[]{1.0, 0.0, 0.0};
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorDirection(colorDirection);
                    ++i;
                }
                break;
            }
            case 39: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorRegions(null);
                    ++i;
                }
                break;
            }
            case 40: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorPalette((Color[])null);
                    ++i;
                }
                break;
            }
            case 41: {
                int i = 0;
                while (i < this.numElements) {
                    this.elements[i].setColorBelowWhenEqual(true);
                    ++i;
                }
                break;
            }
            default: {
                super.setDefaultValue(_index);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "1";
            }
            case 1: {
                return "-1";
            }
        }
        switch (_index -= 2) {
            case 2: {
                return Double.toString(this.defaultElementX);
            }
            case 3: {
                return Double.toString(this.defaultElementY);
            }
            case 4: {
                return Double.toString(this.defaultElementZ);
            }
            case 5: {
                return Double.toString(this.defaultElementSizeX);
            }
            case 6: {
                return Double.toString(this.defaultElementSizeY);
            }
            case 7: {
                return Double.toString(this.defaultElementSizeZ);
            }
            case 10: {
                return this.defElementLines.toString();
            }
            case 12: {
                return this.defElementFill.toString();
            }
        }
        return super.getDefaultValueString(_index);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return null;
            }
            case 1: {
                return this.selectedValue;
            }
        }
        switch (_index -= 2) {
            case 2: {
                return this.allposValues[0];
            }
            case 3: {
                return this.allposValues[1];
            }
            case 4: {
                return this.allposValues[2];
            }
            case 26: {
                return new ObjectValue(this.allThePos);
            }
            case 27: {
                return new ObjectValue(this.allTheSizes);
            }
            case 5: {
                return this.allsizesValues[0];
            }
            case 6: {
                return this.allsizesValues[1];
            }
            case 7: {
                return this.allsizesValues[2];
            }
        }
        return super.getValue(_index);
    }

    protected void propagatePosition(ControlElement3D origin, int _index) {
        this.theXs[_index] = this.elements[_index].getX();
        this.theYs[_index] = this.elements[_index].getY();
        this.theZs[_index] = this.elements[_index].getZ();
        if (this.allThePos != null) {
            this.allThePos[_index][0] = this.theXs[_index];
            this.allThePos[_index][1] = this.theYs[_index];
            this.allThePos[_index][2] = this.theZs[_index];
            ObjectValue objVal = new ObjectValue(this.allThePos);
            this.variableChanged(this.getFullPositionSpot(), objVal);
            if (this != origin) {
                origin.variableChanged(origin.getFullPositionSpot(), objVal);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objVal);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.allposValues);
            if (this != origin) {
                origin.variablesChanged(origin.getPosSpot(), this.allposValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.allposValues);
            }
        }
    }

    protected void propagateSize(ControlElement3D origin, int _index) {
        this.theSizeXs[_index] = this.elements[_index].getSizeX();
        this.theSizeYs[_index] = this.elements[_index].getSizeY();
        this.theSizeZs[_index] = this.elements[_index].getSizeZ();
        if (this.allTheSizes != null) {
            this.allTheSizes[_index][0] = this.theSizeXs[_index];
            this.allTheSizes[_index][1] = this.theSizeYs[_index];
            this.allTheSizes[_index][2] = this.theSizeZs[_index];
            ObjectValue objVal = new ObjectValue(this.allTheSizes);
            if (this != origin) {
                origin.variableChanged(origin.getFullSizeSpot(), objVal);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objVal);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.allsizesValues);
            if (this != origin) {
                origin.variablesChanged(origin.getSizeSpot(), this.allsizesValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.allsizesValues);
            }
        }
    }

    private void reportMouseMotion(Object _info, int _index) {
        InteractionTarget target = (InteractionTarget)_info;
        ControlGroup3D gr = this.getControlGroup();
        if (target == this.elements[_index].getInteractionTarget(0)) {
            if (target.getAffectsGroup() && gr != null) {
                gr.propagatePosition(this);
            } else {
                this.propagatePosition(this, _index);
            }
        } else if (target == this.elements[_index].getInteractionTarget(1)) {
            if (target.getAffectsGroup() && gr != null) {
                gr.propagateSize(this);
            } else {
                this.propagateSize(this, _index);
            }
        }
    }

    protected int getElementInteracted(InteractionEvent _event) {
        Element el = (Element)_event.getSource();
        int i = 0;
        while (i < this.numElements) {
            if (this.elements[i] == el) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void interactionPerformed(InteractionEvent _event) {
        switch (_event.getID()) {
            case 2003: {
                this.selectedValue.value = this.getElementInteracted(_event);
                this.variableChanged(1 + this.getPropertiesDisplacement(), this.selectedValue);
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                this.variableChanged(1 + this.getPropertiesDisplacement(), this.selectedValue);
                break;
            }
            case 2000: {
                this.selectedElement = this.selectedValue.value = this.getElementInteracted(_event);
                this.variableChanged(1 + this.getPropertiesDisplacement(), this.selectedValue);
                this.reportMouseMotion(_event.getInfo(), this.selectedValue.value);
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(_event.getInfo(), this.selectedElement);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.variableChanged(1 + this.getPropertiesDisplacement(), this.selectedValue);
            }
        }
    }
}

