/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.util.Enumeration;
import java.util.Vector;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.Value;

public class GroupVariable {
    private String name;
    private Value value;
    private boolean definedInModel = false;
    private boolean obsolete = false;
    private Vector<Item> elementList;
    private Vector<MethodWithOneParameter> methodList;

    public GroupVariable(String _aName, Value _aValue) {
        this.name = _aName;
        this.elementList = new Vector();
        this.methodList = new Vector();
        this.value = _aValue != null ? _aValue.cloneValue() : new DoubleValue(0.0);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setValue(Value _aValue) {
        if (this.value.getClass() != _aValue.getClass()) {
            this.value = _aValue.cloneValue();
        } else {
            this.value.copyValue(_aValue);
        }
    }

    public Value getValue() {
        return this.value;
    }

    public void setDefinedInModel(boolean _defined) {
        this.definedInModel = _defined;
    }

    public boolean isDefinedInModel() {
        return this.definedInModel;
    }

    public void setValueObsolete(boolean _obsolete) {
        this.obsolete = _obsolete;
    }

    public boolean isValueObsolete() {
        return this.obsolete;
    }

    public void addElementListener(ControlElement _element, int _index) {
        this.elementList.add(new Item(_element, _index));
    }

    public boolean hasElementsRegistered() {
        return !this.elementList.isEmpty();
    }

    public void removeElementListener(ControlElement _element, int _index) {
        for (Item item : this.elementList) {
            if (item.element != _element || item.index != _index) continue;
            this.elementList.removeElement(item);
            return;
        }
    }

    public void propagateValue(ControlElement _element, boolean _collectingData) {
        if (_collectingData) {
            Enumeration<Item> e = this.elementList.elements();
            while (e.hasMoreElements()) {
                Item item = e.nextElement();
                if (!(item.element instanceof DataCollector)) continue;
                item.element.setActive(false);
                if (item.element.myMethodsForProperties[item.index] != null) {
                    item.element.setValue(item.index, item.element.myMethodsForProperties[item.index].invoke(2, null));
                } else if (item.element.myExpressionsForProperties[item.index] != null) {
                    item.element.setValue(item.index, item.element.myExpressionsForProperties[item.index]);
                } else {
                    item.element.setValue(item.index, this.value);
                }
                item.element.setActive(true);
            }
        } else {
            Enumeration<Item> e = this.elementList.elements();
            while (e.hasMoreElements()) {
                Item item = e.nextElement();
                if (item.element == _element) continue;
                item.element.setActive(false);
                if (item.element.myMethodsForProperties[item.index] != null) {
                    item.element.setValue(item.index, item.element.myMethodsForProperties[item.index].invoke(2, null));
                } else if (item.element.myExpressionsForProperties[item.index] != null) {
                    item.element.setValue(item.index, item.element.myExpressionsForProperties[item.index]);
                } else {
                    item.element.setValue(item.index, this.value);
                }
                item.element.setActive(true);
            }
        }
    }

    public void addListener(Object _target, String _method) {
        this.addListener(_target, _method, null);
    }

    public void addListener(Object _target, String _method, Object _anObject) {
        this.methodList.add(new MethodWithOneParameter(1, _target, _method, null, null, _anObject));
    }

    public void removeListener(Object _target, String _method) {
        for (MethodWithOneParameter method : this.methodList) {
            if (!method.equals(1, _target, _method)) continue;
            this.methodList.removeElement(method);
            return;
        }
    }

    public void invokeListeners(ControlElement _element) {
        for (MethodWithOneParameter method : this.methodList) {
            method.invoke(1, _element);
        }
    }

    private class Item {
        public ControlElement element;
        public int index;

        Item(ControlElement _anElement, int _anIndex) {
            this.element = _anElement;
            this.index = _anIndex;
        }
    }
}

