var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Dreu_AuthorIcon.png"]="data:image/png;base64,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";
__base64Images["./wc_icon.png"]="data:image/png;base64,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";
__base64Images["./Problem2_1.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./mjb_icon.png"]="data:image/png;base64,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";
__base64Images["./t_bird.gif"]="data:image/gif;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
