/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadViewerTableModel
extends AbstractTableModel {
    private Object dataLock;
    private int rowCount = 0;
    private Object[][] cellData = new Object[0][0];
    private Object[][] pendingCellData;
    private final int columnCount;
    private final String[] columnName;
    private final Class[] columnClass;
    private Thread internalThread;
    private volatile boolean noStopRequested;

    public ThreadViewerTableModel() {
        String[] stringArray = new String[]{"Priority", "Alive", "Daemon", "Interrupted", "ThreadGroup", "Thread Name"};
        this.columnName = stringArray;
        Class[] classArray = new Class[]{Integer.class, Boolean.class, Boolean.class, Boolean.class, String.class, String.class};
        this.columnClass = classArray;
        this.columnCount = this.columnName.length;
        this.dataLock = new Object();
        this.noStopRequested = true;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ThreadViewerTableModel.this.runWork();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.internalThread = new Thread(runnable, "ThreadViewer");
        this.internalThread.setPriority(8);
        this.internalThread.setDaemon(true);
        this.internalThread.start();
    }

    private void runWork() {
        Runnable runnable = new Runnable(){

            public void run() {
                ThreadViewerTableModel.this.transferPendingCellData();
                ThreadViewerTableModel.this.fireTableDataChanged();
            }
        };
        while (this.noStopRequested) {
            try {
                this.createPendingCellData();
                SwingUtilities.invokeAndWait(runnable);
                Thread.sleep(5000L);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                this.stopRequest();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void stopRequest() {
        this.noStopRequested = false;
        this.internalThread.interrupt();
    }

    public boolean isAlive() {
        return this.internalThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPendingCellData() {
        Thread[] threadArray = ThreadViewerTableModel.findAllThreads();
        Object[][] objectArray = new Object[threadArray.length][this.columnCount];
        int n = 0;
        while (n < threadArray.length) {
            Thread thread = threadArray[n];
            Object[] objectArray2 = objectArray[n];
            objectArray2[0] = new Integer(thread.getPriority());
            objectArray2[1] = new Boolean(thread.isAlive());
            objectArray2[2] = new Boolean(thread.isDaemon());
            objectArray2[3] = new Boolean(thread.isInterrupted());
            objectArray2[4] = thread.getThreadGroup().getName();
            objectArray2[5] = thread.getName();
            ++n;
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.pendingCellData = objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferPendingCellData() {
        Object object = this.dataLock;
        synchronized (object) {
            this.cellData = this.pendingCellData;
            this.rowCount = this.cellData.length;
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.cellData[n][n2];
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.columnClass[n];
    }

    @Override
    public String getColumnName(int n) {
        return this.columnName[n];
    }

    public static Thread[] findAllThreads() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup != null) {
            threadGroup2 = threadGroup;
            threadGroup = threadGroup.getParent();
        }
        int n = threadGroup2.activeCount() * 2;
        Thread[] threadArray = new Thread[n];
        int n2 = threadGroup2.enumerate(threadArray);
        Thread[] threadArray2 = new Thread[n2];
        System.arraycopy(threadArray, 0, threadArray2, 0, n2);
        return threadArray2;
    }
}

