/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class XuggleVideo
extends VideoAdapter {
    IContainer container;
    int streamIndex = -1;
    IStreamCoder videoCoder;
    IVideoResampler resampler;
    IPacket packet;
    IVideoPicture picture;
    IStream stream;
    IRational timebase;
    IConverter converter;
    Map<Integer, Long> frameTimeStamps = new HashMap<Integer, Long>();
    Map<Integer, Long> keyTimeStamps = new HashMap<Integer, Long>();
    private double[] startTimes;
    private long systemStartPlayTime;
    private double frameStartPlayTime;
    private boolean playSmoothly = true;
    private int frame;
    private int prevFrame;
    private Timer failDetectTimer;

    public XuggleVideo(final String string) throws IOException {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        int n2 = frameArray.length;
        while (n < n2) {
            if (frameArray[n].getName().equals("Tracker")) {
                this.addPropertyChangeListener("progress", (PropertyChangeListener)((Object)frameArray[n]));
                this.addPropertyChangeListener("stalled", (PropertyChangeListener)((Object)frameArray[n]));
                break;
            }
            ++n;
        }
        this.failDetectTimer = new Timer(6000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XuggleVideo.this.frame == XuggleVideo.this.prevFrame) {
                    XuggleVideo.this.firePropertyChange("stalled", null, string);
                    XuggleVideo.this.failDetectTimer.stop();
                }
                XuggleVideo.this.prevFrame = XuggleVideo.this.frame;
            }
        });
        this.failDetectTimer.setRepeats(true);
        this.load(string);
    }

    public void play() {
        if (this.getFrameCount() == 1) {
            return;
        }
        int n = this.getFrameNumber() + 1;
        this.playing = true;
        this.support.firePropertyChange("playing", null, new Boolean(true));
        this.startPlayingAtFrame(n);
    }

    public void stop() {
        this.playing = false;
        this.support.firePropertyChange("playing", null, new Boolean(false));
    }

    public void setFrameNumber(int n) {
        if (n == this.getFrameNumber()) {
            return;
        }
        super.setFrameNumber(n);
        BufferedImage bufferedImage = this.getImage(this.getFrameNumber());
        if (bufferedImage != null) {
            this.rawImage = bufferedImage;
            this.isValidImage = false;
            this.isValidFilteredImage = false;
            this.firePropertyChange("framenumber", null, new Integer(this.getFrameNumber()));
            if (this.isPlaying()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        XuggleVideo.this.continuePlaying();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public double getFrameTime(int n) {
        if (n >= this.startTimes.length || n < 0) {
            return -1.0;
        }
        return this.startTimes[n];
    }

    public double getTime() {
        return this.getFrameTime(this.getFrameNumber());
    }

    public void setTime(double d) {
        d = Math.abs(d);
        int n = 0;
        while (n < this.startTimes.length) {
            double d2 = this.startTimes[n];
            if (d < d2) {
                this.setFrameNumber(n - 1);
                break;
            }
            ++n;
        }
    }

    public double getStartTime() {
        return this.getFrameTime(this.getStartFrameNumber());
    }

    public void setStartTime(double d) {
        d = Math.abs(d);
        int n = 0;
        while (n < this.startTimes.length) {
            double d2 = this.startTimes[n];
            if (d < d2) {
                this.setStartFrameNumber(n - 1);
                break;
            }
            ++n;
        }
    }

    public double getEndTime() {
        int n = this.getEndFrameNumber();
        if (n < this.getFrameCount() - 1) {
            return this.getFrameTime(n + 1);
        }
        return this.getDuration();
    }

    public void setEndTime(double d) {
        d = Math.abs(d);
        d = Math.min(this.getDuration(), d);
        int n = 0;
        while (n < this.startTimes.length) {
            double d2 = this.startTimes[n];
            if (d < d2) {
                this.setEndFrameNumber(n - 1);
                break;
            }
            ++n;
        }
    }

    public double getDuration() {
        int n = this.getFrameCount() - 1;
        if (n == 0) {
            return 100.0;
        }
        double d = this.getFrameTime(n) - this.getFrameTime(n - 1);
        return this.getFrameTime(n) + d;
    }

    public void setRate(double d) {
        super.setRate(d);
        if (this.isPlaying()) {
            this.startPlayingAtFrame(this.getFrameNumber());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.container == null) {
            return;
        }
        this.videoCoder.close();
        this.videoCoder.delete();
        this.videoCoder = null;
        this.stream.delete();
        this.stream = null;
        if (this.picture != null) {
            this.picture.delete();
            this.picture = null;
            this.packet.delete();
            this.packet = null;
        }
        this.container.close();
        this.container.delete();
        this.container = null;
    }

    public void setSmoothPlay(boolean bl) {
        this.playSmoothly = bl;
    }

    public boolean isSmoothPlay() {
        return this.playSmoothly;
    }

    protected void finalize() {
    }

    private void startPlayingAtFrame(int n) {
        this.systemStartPlayTime = System.currentTimeMillis();
        this.frameStartPlayTime = this.getFrameTime(n);
        this.setFrameNumber(n);
    }

    private void continuePlaying() {
        int n = this.getFrameNumber();
        if (n < this.getEndFrameNumber()) {
            long l = System.currentTimeMillis() - this.systemStartPlayTime;
            double d = this.frameStartPlayTime + this.getRate() * (double)l;
            int n2 = this.getFrameNumberBefore(d);
            while (n2 > -1 && n2 <= n) {
                l = System.currentTimeMillis() - this.systemStartPlayTime;
                d = this.frameStartPlayTime + this.getRate() * (double)l;
                n2 = this.getFrameNumberBefore(d);
            }
            if (n2 == -1) {
                n2 = this.getEndFrameNumber();
            }
            this.setFrameNumber(n2);
        } else if (this.looping) {
            this.startPlayingAtFrame(this.getStartFrameNumber());
        } else {
            this.stop();
        }
    }

    private int getFrameNumberBefore(double d) {
        int n = 0;
        while (n < this.startTimes.length) {
            if (d < this.startTimes[n]) {
                return n - 1;
            }
            ++n;
        }
        n = this.startTimes.length - 1;
        double d2 = 2.0 * this.startTimes[n] - this.startTimes[n - 1];
        if (d < d2) {
            return n;
        }
        return -1;
    }

    private void load(String string) throws IOException {
        int n;
        int n2;
        IStreamCoder iStreamCoder;
        Object object;
        RandomAccessFile randomAccessFile;
        Resource resource = ResourceLoader.getResource(string);
        if (resource == null) {
            throw new IOException("unable to create resource for " + string);
        }
        URL uRL = resource.getURL();
        boolean bl = uRL.getProtocol().toLowerCase().indexOf("file") > -1;
        String string2 = bl ? resource.getAbsolutePath() : uRL.toExternalForm();
        OSPLog.finest("Xuggle video loading " + string2 + " local?: " + bl);
        this.container = IContainer.make();
        if (bl ? this.container.open(randomAccessFile = new RandomAccessFile(string2, "r"), IContainer.Type.READ, null) < 0 : this.container.open(string2, IContainer.Type.READ, null) < 0) {
            throw new IOException("unable to open " + string);
        }
        int n3 = 0;
        while (n3 < this.container.getNumStreams()) {
            object = this.container.getStream((long)n3);
            iStreamCoder = object.getStreamCoder();
            if (iStreamCoder.getCodecType().equals((Object)ICodec.Type.CODEC_TYPE_VIDEO)) {
                this.stream = object;
                this.streamIndex = n3;
                this.videoCoder = iStreamCoder;
                this.timebase = this.stream.getTimeBase().copy();
                break;
            }
            ++n3;
        }
        if (this.streamIndex == -1) {
            throw new IOException("no video stream found in " + string);
        }
        if (this.videoCoder.open() < 0) {
            throw new IOException("unable to open video decoder for " + string);
        }
        this.setProperty("name", XML.getName(string));
        if (string.indexOf(":") == -1) {
            this.setProperty("path", XML.forwardSlash(string));
            this.setProperty("absolutePath", resource.getAbsolutePath());
        } else {
            this.setProperty("path", XML.getRelativePath(string));
            this.setProperty("absolutePath", string);
        }
        IContainer iContainer = IContainer.make();
        if (bl) {
            object = new RandomAccessFile(string2, "r");
            iContainer.open((RandomAccessFile)object, IContainer.Type.READ, null);
        } else {
            iContainer.open(this.container.getURL(), IContainer.Type.READ, null);
        }
        object = iContainer.getStream((long)this.streamIndex);
        iStreamCoder = object.getStreamCoder();
        iStreamCoder.open();
        IVideoPicture iVideoPicture = IVideoPicture.make((IPixelFormat.Type)iStreamCoder.getPixelType(), (int)iStreamCoder.getWidth(), (int)iStreamCoder.getHeight());
        IPacket iPacket = IPacket.make();
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.firePropertyChange("progress", null, 0);
        this.prevFrame = 0;
        this.frame = 0;
        this.failDetectTimer.start();
        block1: while (iContainer.readNextPacket(iPacket) >= 0) {
            if (VideoIO.isCanceled()) {
                this.failDetectTimer.stop();
                this.firePropertyChange("progress", null, null);
                iStreamCoder.close();
                iStreamCoder.delete();
                object.delete();
                iVideoPicture.delete();
                iPacket.delete();
                iContainer.close();
                iContainer.delete();
                this.dispose();
                throw new IOException("Canceled by user");
            }
            if (!this.isVideoPacket(iPacket)) continue;
            if (l == Long.MIN_VALUE || iPacket.isKeyPacket()) {
                l = iPacket.getTimeStamp();
            }
            n2 = 0;
            while (n2 < iPacket.getSize()) {
                n = iStreamCoder.decodeVideo(iVideoPicture, iPacket, n2);
                if (n < 0) continue block1;
                n2 += n;
                if (!iVideoPicture.isComplete()) continue;
                if (l2 == Long.MIN_VALUE) {
                    l2 = iPacket.getTimeStamp();
                }
                this.frameTimeStamps.put(this.frame, iPacket.getTimeStamp());
                arrayList.add((double)(iPacket.getTimeStamp() - l2) * this.timebase.getValue());
                this.keyTimeStamps.put(this.frame, l);
                this.firePropertyChange("progress", null, this.frame);
                ++this.frame;
            }
        }
        iStreamCoder.close();
        iStreamCoder.delete();
        object.delete();
        iVideoPicture.delete();
        iPacket.delete();
        iContainer.close();
        iContainer.delete();
        this.frameCount = this.frameTimeStamps.size();
        this.startFrameNumber = 0;
        this.endFrameNumber = this.frameCount - 1;
        this.startTimes = new double[this.frameCount];
        this.startTimes[0] = 0.0;
        n2 = 1;
        while (n2 < this.startTimes.length) {
            this.startTimes[n2] = (Double)arrayList.get(n2) * 1000.0;
            ++n2;
        }
        this.picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
        this.packet = IPacket.make();
        this.loadNextPacket();
        BufferedImage bufferedImage = this.getImage(0);
        if (bufferedImage == null) {
            n = 1;
            while (n < this.frameTimeStamps.size()) {
                bufferedImage = this.getImage(n);
                if (bufferedImage != null) break;
                ++n;
            }
        }
        this.firePropertyChange("progress", null, null);
        this.failDetectTimer.stop();
        if (bufferedImage == null) {
            throw new IOException("No images");
        }
        this.setImage(bufferedImage);
    }

    private void reload() throws IOException {
        String string = this.container.getURL();
        this.container.close();
        this.videoCoder.close();
        this.videoCoder.delete();
        this.stream.delete();
        boolean bl = string.toLowerCase().indexOf("file:") > -1;
        String string2 = bl ? ResourceLoader.getNonURIPath(string) : string;
        this.container = IContainer.make();
        if (bl) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
            this.container.open(randomAccessFile, IContainer.Type.READ, null);
        } else {
            this.container.open(string2, IContainer.Type.READ, null);
        }
        this.stream = this.container.getStream((long)this.streamIndex);
        this.videoCoder = this.stream.getStreamCoder();
        this.videoCoder.open();
    }

    private void setImage(BufferedImage bufferedImage) {
        this.rawImage = bufferedImage;
        this.size = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.refreshBufferedImage();
        this.coords = new ImageCoordSystem(this.frameCount);
        this.coords.addPropertyChangeListener(this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    private boolean isKeyPacket(IPacket iPacket) {
        return this.isVideoPacket(iPacket) && iPacket.isKeyPacket();
    }

    private boolean isVideoPacket(IPacket iPacket) {
        return iPacket.getStreamIndex() == this.streamIndex;
    }

    private IPacket getKeyPacket(long l) {
        long l2 = l - this.packet.getTimeStamp();
        if (l2 == 0L) {
            return this.packet;
        }
        IRational iRational = this.packet.getTimeBase();
        int n = iRational.getDenominator();
        if (l2 > 0L && l2 < (long)n) {
            while (this.container.readNextPacket(this.packet) >= 0) {
                if (this.isKeyPacket(this.packet) && this.packet.getTimeStamp() == l) {
                    return this.packet;
                }
                if (!this.isVideoPacket(this.packet) || this.packet.getTimeStamp() <= l) continue;
                l2 = l - this.packet.getTimeStamp();
                break;
            }
        }
        if (l2 > 0L && this.container.seekKeyFrame(this.streamIndex, l, l, l, 0) >= 0) {
            while (this.container.readNextPacket(this.packet) >= 0) {
                if (this.isKeyPacket(this.packet) && this.packet.getTimeStamp() == l) {
                    return this.packet;
                }
                if (!this.isVideoPacket(this.packet) || this.packet.getTimeStamp() <= l) continue;
                l2 = l - this.packet.getTimeStamp();
                break;
            }
        }
        if (this.getFrameNumber(l) == 0) {
            this.resetContainer();
            return this.packet;
        }
        if (l2 < 0L && this.container.seekKeyFrame(this.streamIndex, l, l, l, IContainer.SEEK_FLAG_BACKWARDS) >= 0) {
            while (this.container.readNextPacket(this.packet) >= 0) {
                if (this.isKeyPacket(this.packet) && this.isVideoPacket(this.packet) && this.packet.getTimeStamp() == l) {
                    return this.packet;
                }
                if (!this.isVideoPacket(this.packet) || this.packet.getTimeStamp() <= l) continue;
                l2 = l - this.packet.getTimeStamp();
                break;
            }
        }
        this.resetContainer();
        while (this.container.readNextPacket(this.packet) >= 0) {
            if (this.isKeyPacket(this.packet) && this.packet.getTimeStamp() == l) {
                return this.packet;
            }
            if (this.isVideoPacket(this.packet) && this.packet.getTimeStamp() > l) break;
        }
        return null;
    }

    private IPacket getKeyPacketForFrame(int n) {
        long l = this.keyTimeStamps.get(n);
        return this.getKeyPacket(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadPicture(int n) {
        long l = this.packet.getTimeStamp();
        long l2 = this.getTimeStamp(n);
        long l3 = this.keyTimeStamps.get(n);
        if (l == l2 && this.isVideoPacket(this.packet)) {
            return this.picture.isComplete();
        }
        if (l >= l3 && l < l2) {
            if (!this.loadNextPacket()) return false;
            int n2 = this.getFrameNumber(this.packet);
            while (n2 > -2 && n2 < n) {
                if (!this.loadNextPacket()) return false;
                n2 = this.getFrameNumber(this.packet);
            }
            return this.picture.isComplete();
        } else {
            if (this.getKeyPacketForFrame(n) == null) return this.picture.isComplete();
            if (!this.loadPacket(this.packet)) return false;
            int n3 = this.getFrameNumber(this.packet);
            while (n3 > -2 && n3 < n) {
                if (!this.loadNextPacket()) return false;
                n3 = this.getFrameNumber(this.packet);
            }
        }
        return this.picture.isComplete();
    }

    private long getTimeStamp(int n) {
        return this.frameTimeStamps.get(n);
    }

    private int getFrameNumber(long l) {
        int n = 0;
        while (n < this.frameTimeStamps.size()) {
            long l2 = this.frameTimeStamps.get(n);
            if (l2 == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getFrameNumber(IPacket iPacket) {
        if (iPacket.getStreamIndex() != this.streamIndex) {
            return -2;
        }
        return this.getFrameNumber(iPacket.getTimeStamp());
    }

    private BufferedImage getImage(int n) {
        if (n < 0 || n >= this.frameTimeStamps.size()) {
            return null;
        }
        if (this.loadPicture(n)) {
            return this.getBufferedImage(this.picture);
        }
        return null;
    }

    private BufferedImage getBufferedImage(IVideoPicture iVideoPicture) {
        Object object;
        if (iVideoPicture.getPixelType() != IPixelFormat.Type.BGR24) {
            if (this.resampler == null) {
                this.resampler = IVideoResampler.make((int)iVideoPicture.getWidth(), (int)iVideoPicture.getHeight(), (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)iVideoPicture.getWidth(), (int)iVideoPicture.getHeight(), (IPixelFormat.Type)iVideoPicture.getPixelType());
                if (this.resampler == null) {
                    OSPLog.warning("Could not create color space resampler");
                    return null;
                }
            }
            if (this.resampler.resample((IVideoPicture)(object = IVideoPicture.make((IPixelFormat.Type)this.resampler.getOutputPixelFormat(), (int)iVideoPicture.getWidth(), (int)iVideoPicture.getHeight())), iVideoPicture) < 0 || object.getPixelType() != IPixelFormat.Type.BGR24) {
                OSPLog.warning("Could not encode video as BGR24");
                return null;
            }
            iVideoPicture = object;
        }
        if (this.converter == null) {
            object = ConverterFactory.findRegisteredConverter((String)"XUGGLER-BGR-24");
            this.converter = ConverterFactory.createConverter((String)object.getDescriptor(), (IVideoPicture)iVideoPicture);
        }
        object = this.converter.toImage(iVideoPicture);
        if (this.playSmoothly) {
            System.gc();
        }
        return object;
    }

    private boolean loadNextPacket() {
        while (this.container.readNextPacket(this.packet) >= 0) {
            if (!this.isVideoPacket(this.packet)) continue;
            return this.loadPacket(this.packet);
        }
        return false;
    }

    private boolean loadPacket(IPacket iPacket) {
        int n;
        int n2 = iPacket.getSize();
        for (int i = 0; i < n2; i += n) {
            n = this.videoCoder.decodeVideo(this.picture, iPacket, i);
            if (n >= 0) continue;
            return false;
        }
        return true;
    }

    private void resetContainer() {
        if (this.container.seekKeyFrame(-1, Long.MIN_VALUE, 0L, Long.MAX_VALUE, IContainer.SEEK_FLAG_BACKWARDS) >= 0) {
            this.loadNextPacket();
        } else {
            try {
                this.reload();
                this.loadNextPacket();
            }
            catch (IOException iOException) {
                OSPLog.warning("Container could not be reset");
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            XuggleVideo xuggleVideo = (XuggleVideo)object;
            String string = (String)xuggleVideo.getProperty("base");
            String string2 = (String)xuggleVideo.getProperty("absolutePath");
            xMLControl.setValue("path", XML.getPathRelativeTo(string2, string));
            if (!xuggleVideo.getFilterStack().isEmpty()) {
                xMLControl.setValue("filters", xuggleVideo.getFilterStack().getFilters());
            }
        }

        public Object createObject(XMLControl xMLControl) {
            try {
                String string = xMLControl.getString("path");
                String string2 = XML.getExtension(string);
                XuggleVideo xuggleVideo = new XuggleVideo(string);
                VideoType videoType = VideoIO.getVideoType("xuggle", string2);
                if (videoType != null) {
                    xuggleVideo.setProperty("video_type", videoType);
                }
                return xuggleVideo;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            XuggleVideo xuggleVideo = (XuggleVideo)object;
            Collection collection = (Collection)xMLControl.getObject("filters");
            if (collection != null) {
                xuggleVideo.getFilterStack().clear();
                for (Filter filter : collection) {
                    xuggleVideo.getFilterStack().addFilter(filter);
                }
            }
            return object;
        }
    }
}

