/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.text.DecimalFormat;
import javax.swing.JProgressBar;
import org.colos.ejs.library.control.ConstantParser;

public class JProgressBarDouble
extends JProgressBar {
    public static final int RESOLUTION = 100000;
    private double scale;
    private double minimum;
    private double maximum = Double.NaN;
    private double doubleValue;
    private DecimalFormat format = null;

    public JProgressBarDouble(int n) {
        super(n);
        this.setBorderPainted(true);
        this.setStringPainted(false);
        this.setMinimum(0);
        this.setMaximum(100000);
        this.setValue(0);
        this.minimum = 0.0;
        this.doubleValue = 0.0;
        this.setDoubleMaximum(1.0);
    }

    public void setDoubleValue(double d) {
        if (d == this.doubleValue) {
            return;
        }
        this.doubleValue = d;
        if (this.doubleValue < this.minimum) {
            this.setValue(0);
        } else if (this.doubleValue > this.maximum) {
            this.setValue(100000);
        } else {
            int n = (int)((this.doubleValue - this.minimum) * this.scale);
            this.setValue(n);
        }
        if (this.format != null) {
            this.setString(this.format.format(this.doubleValue));
        }
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public double getDoubleMinimum() {
        return this.minimum;
    }

    public void setDoubleMinimum(double d) {
        if (d == this.minimum) {
            return;
        }
        this.minimum = d;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.setDoubleValue(this.doubleValue);
    }

    public double getDoubleMaximum() {
        return this.maximum;
    }

    public void setDoubleMaximum(double d) {
        if (d == this.maximum) {
            return;
        }
        this.maximum = d;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.setDoubleValue(this.doubleValue);
    }

    public void setFormat(DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            this.format = null;
            this.setStringPainted(false);
            return;
        }
        if (decimalFormat.equals(this.format)) {
            return;
        }
        this.format = decimalFormat;
        this.setString(this.format.format(this.doubleValue));
        this.setStringPainted(true);
        this.repaint();
    }

    public void setFormat(String string) {
        this.setFormat((DecimalFormat)ConstantParser.formatConstant(string).getObject());
    }
}

