var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./DataFitting/DataFittingLogoFull.png"]="data:image/png;base64,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";
__base64Images["./DataFitting/min.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOoAAAAyBAMAAACg11o/AAAAMFBMVEX///+Kiop0dHQEBAQwMDBQUFAWFhbm5ubMzMyenp62trZAQEAMDAwiIiJiYmIAAAB2Iha0AAAAAXRSTlMAQObYZgAABSRJREFUWAntVltoHFUY/nd3NjM7m90N9k1RF9GKrYa85cGHrsEHpWAXVPBFXR/a4rULFQq26hB8KJiS9UVqvQ0RKgZtVhCCSY2LPigW2rQP0ig1QzRWbUO2WtuqhfH7z5nLzm52ZpfEgpAP/nP+y/efM+ecOReiELz0XX81JCxC6tLYubHFKFY38fxxqkfx471Wri8RxeomvmdAq0Xx1d00Qq9HsbqJx2azxUj+jbSZZsqRtM4Jaat3OJI9Q/fQoBVJ65yQMZQ7ItmnaSedqkTS1gnrM/BfzMA7S2bbZnP2DsaXtv03c9SVifYlJj2zxbbNFQmNabynIaqlX16Ry86snRcxbeNFrh8RRkux/Lt0De8qtMTY0Zi2CTYkVae/oC1dnZ6erzMngPkrjrkBH5itBGKekbENqccGPR8rqRmLq0BaGu2wmCq3rKPrFc7b3Vc5D9AtoleE1lqoW2qO80gg+PKLJbYDaWoB0wuhZBVFlqeZlSBStuurEJ0Oxnzr3X8cPeX7oN2pltkOpn0KD8sNHMqUUFiQJjyOOXCglVytuU7a+KZWbBWuprSP4ISkLP7HckX0aQhaoOj5Q3wv+0Kunl3BBXVa+ELUTWl8C0OO7LkeykRFrTrkQKXZJdfO9BEN30+K5Tr8evSSr9OrC3lh/XRximtO0/snFwpswKywaLZdh7G8dZvFTiDNu2/Hs9Kgm/90FEoYWIOHKIdWmhGzi54rtZP/TEDndjEwAx9LZ+LObkhb6AEi8C1lTUcNVmlvzXJlShnP0UQ5SBDW5/7yjxqa/IR4TYSQhsXbTqawKIkgi8DdFCfN0YPVCXfNcvjntct0nvbWmKHtZ6BJRq+//GfYVvIYUQHKECENpxG+Sj0KjbJVKaxrF0ilLGstmHC3BacnS/Q9xZGIbXgvw2IVs+ntMFUcVDyAHguFIXrls4jwyAEae43zdn2Dvc3rSklvrBgXWrog/g9J9csHERTQxYnNaq4iHDzD/LVlOsl24wwrA3AUqP82DgSxz3TsXiiJCk7txAsbgxTM3jeuh0+6/fFbYY6iu1sKxGlmT1HN0+BYCWPKSyEgUcBaWEnrQzaCeMI1lT6MtU+p0eFDz7s+t+5BzMFJnJ4HeTU24Cww6oS02JURK0v6k+8X0IIpBYT0/LHpz+zyKNRmZCzXw8upD/1cpfOTrsurf/A02rvwK5X5bfwopiBV4r9AG7p96Cxlj2HwfEII8RPu8lVPm/Y0tcYqVmvuPdVzSiWNDwrgYVinIFhFmQY9c2gA3b4JjcXH2xTzDanFZ30PjprthCUdyMV9p9BaPneOdJP/Qj6JxAkFPUH1PNF90Fh8JBd+8Q2pvYXPE7CIsJpPaV+TNqv85jidKvWVo3h7r065qSqcvL7uT3CAHjBJh5clFOhEIpsniuXppkX3K6RbliOGYy04tV6i5DlmHobE8ihcKFBYQuFuG22e29i0MtfbNgd41wPppCVqqj7GdWPaWdgsoXh6nPHa5hPi3dSG2jPFpA+uO2oXJGPfoqzV48U2KaFuxXaBc7Qttrkk76JoS+0ooPMgBMwQvssZHw8hrYf+fzPAdzhDMVCsHvLVwO0oBop20GQg9qPRjtGVn68Zgc4aTBgOfXUVvyolwhoUdzjTwkhOO51U/qshrMGDOXUamFyrXvFq6KBBcYev4Vj9V0PYWInv8DXs1X81hPY6p36CR+qazTBeDZ00WJdDTS1/LJXVlf6rIbRB3OHXHt4dfk27du/wbjv9F85CbY3s/Vy9AAAAAElFTkSuQmCC";
__base64Images["./DataFitting/system.png"]="data:image/png;base64,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";
__base64Images["./DataFitting/derivate.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAXAAAAAzBAMAAAB8jE56AAAAMFBMVEX///8WFhZAQEBiYmIEBASKiooiIiIMDAwwMDDMzMyenp5QUFDm5uZ0dHS2trYAAAA4iG+KAAAAAXRSTlMAQObYZgAAB71JREFUaAXVWF2MG1cV/vy7Hu94vCQqEj9C7i6UCG0jK+GnarOtX5BolQdLVDxRxSC1qJEgVsNLhaAmpQIeFgxIJFFB6xYhxEtxFUAUkDraVDgPhbhdiVao2075Cw+kXgWqJmmo+c6945k7ntkkW5htc6Rz55zv/Mzx9ZmZey8AZ93FNUm/tpaB3KH75m8YJ9Zvf/TsnkRDAnjyC2u71/oJhhSgiocZDxj1gKNIospMvZqEJ2HDw3gVjSTL/x+baWG2A9zmAtnE7PZTm/yiBO+nG1a7PJdgSAEqdFFpAJ9h6lxy+k/hlmRDHC20KrXsvjieElLZAF5n2VZy/gXcP0y2xNBsvdTMn4zBqQD2ifWHN+BcxOpm6e/Fcm8z2xRe7Gbc4p+mwJTUM138sY3c+V3/SukGKaW1Pw4cqKE4h1tTukNKaUttFt5EvoYhuindI5W01Rrwc2ClCRf1VO6QUtJRE/gS8JILlHsp3SOVtCMP5QbwNSYvobLUn7pJdfwOoS+Ox28YFteQQzHZN7TzPw1IRGHAVmNkMCARDdVwy/cw8IBPEHoQJ5y2YRIxNx4qxHrmfGiZ7YayISX6GnYz7EXiwsATaowMBsQFCYTjVH6XcxC44bX5+UOXrI24/dAFH7vTpfDo9Yscb/ah6UvUN7Q+ulfJZljW5QqDjFyPw4TKC3WKEUjuJ2yStSCf8u/9IsAqrUAMhKde80WHOcmfA6xOYI0KEd/QZF+S9UQ0zO6wBcg4Rg7o9O/mKEegUwSETRq4hZapo9xCMwJQKY9rPtRTq7CVOopdH5m+RHxDY6X9tCjRsA8REb5XTBN6znYpRqBsj7clm/Qr4A5TB06sxWt68mLow3dntYXvhMCUZPqGplJNydGwvxMjWzLFAR0RKQo5Lf7RZJMOA5819WQ58283MMx0kG9dZq1o+gZBmBkqObrEzBMj5/qhH/BlUaIQGoSEDXoV+KqhbiJa48ikrPRxN2fl+R5fQjGK+FoL68oh9+0jnggMw9k9J58XmY3TU1xsKk0PN53fLRZCztriUkeDB3kRDsli4e8PVUPKqnf3O33kwOuGCU+6uJ2zwr0Hw2Nk+j7ijnrKYaTdGGYNi62XukrN1tm7deS1pj2cDbkK9EPcU/FfZwuEhHG9qqrFLJsWLm4hZce9ULHY8ZeAn2bqDi8xMnytC3hY25/TF/rnkOk7WpvtA+Sqq1U1VtpyEaiO98ATBfiNz0pRw9UWjgf2h0GZJrDBj96Km2vbH1T4caEf+C6hb7ElEPfh2EUuDSXMRrUHrEp9uZriKkVLZXD5D3SAMxDIBSdI55eNenSzrgsfTxHTT9PoXIg8RFFcHkexhmcFt74hNGn40Pf0UKxd8k7x0mH4GeVKjYNR+DGVoQ5kyJYqHOUN+qj8UrSwQf/Z7OGM9jhmwxnPNfkPSo/sRLWpHjcjn4ih78ibmPz3qWqtxznr6oFMahX5O3SrYHaOsy6Pc9gqQY+Dr8MdYroSDbzA4y5pv69QvQMjF/vPzgUWXxh4E+R0F1Z3vcM5ZMUVvksY5rB1f4/8H55hWwwVzwT+jFtxkfsWBPIyfXuo899Ig7BB8Q+QYTTE6wLZ2bn3ljqkXa7D1+G8+5+dwOQLoS/n9S/lLv/xQoMPMxuXYQeOH+YPf/kxfsMznuJS08hwJ/DCQyBUuHC0nvPzv48OwgYNuoWWUi9/CFesBzF5PhBN1Xr/WNuB3H1uYPEFw9deWOvZ5Tl2T4sP2yOqY4+tn1pz8bFFevsfINXvkyy/pGNDHgFr+YXlfX7+Bq3CBlk3+h8zdQhnGKLifFQFBgq4iOJjDXfKNu0rnVwc0okvNR1G+eBfba4zKZDttpHh8+rBDSCVv1zjeomcRBV9CJdkIhZfMmY9ZPqVOU7ahtRkUMyX38dX8i49DrKjPd+zUa0A36QiLN9KTY63n93zNzeAVP5Sl+9SchLN6EO4JBOxn7i+oT5xsDvs0KNdfB8PehNMX2O+bO1zfxbbhr+KpWi1SrfCqfFRJRtL1upu6tmPhJDKL9EqA6/TVNCHcNOw1q37fTw3DBzuQmHvbwMtFOK+L3PFuUgHZ44DX0kBlSgJoxCknd3jCmBCVDo+85JEFc5IMg08jVuHXC1wZG8l0sDHA9/aCe2Xna1TMMP2UReebOCUOBlenAj8TrmaQ8SQ9CHcd5eC327YsOMVoR8/+8B5E02Wp33tw33tOPDfAslhbxo9I4dw5ffy+DBOpWBFkGSN+m/FNxr55jR9CLfStfzpiWRx1ITL4EXwJGUrvknxW8X0Idw9DHPaW419S/2rNR7C2VxxQa3l3tJatnTzUZOHcM4bW4p5WziP5BDO5kbp+E3e/1jQsh8vn8T0Ka8O4e6Gs3SKcz9Fq0Hbb/bdNQO6Wvnk7SaYmqwP4VaXbrZlxTZFXKppKnzYr2rKIVHdnsLDQzi1VYpWonYrCorsx6NOE022DYq2qXD/blyvfzoQJ4LarSjlyoVz27A6T1IHGJME23JdiPc4dyu2FLOojjsuX4XaNiiX7Z7xhLrUbkXhV55xOSfR9DYoXO1WrrbwYm+VJw1Htr9V/PkyL9yt2LtYzdW0ij4RYfSPzsV7zky6DbLaraj7lG/7wBXvx23DNUmTbcO1VnywbdiWwv8LkiswjhMH6rEAAAAASUVORK5CYII=";
__base64Images["./DataFitting/systemDef.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAPkAAAAxBAMAAADq2hJ6AAAAMFBMVEX///9AQEB0dHS2trYMDAwEBASKiooWFhYiIiIwMDCenp5iYmLMzMxQUFDm5uYAAAAgETWjAAAAAXRSTlMAQObYZgAABLZJREFUWAntVk1oXFUU/mYmmUzyJm+i7UIsxtd2YTWoY0QqCnbElT/IrFyVdigIFkGDFSoFaepCpBaMWQjBgk+6dNEkVluU1KFETEFINuJCiy9aweDCpGILEjp+57x735/oYhhmEHNg7vnud+79zv19c4FOmHthfK4TOu1p5PtmK+317EQv92csdkKnTY0XsNBmz05024FnvE7otKdxCtN+ez23em2tQPdXwI1SBiEyztIJNhMJW7RuHKW9erDVqtou9LFqEiKhEMLvbZ/hZoh2W0J9kk1HTLMvroXg0vGpRMdIFcjHo7Ji0lDFHB/ld0ak+pkUtFygzhRJNh0xDUqtZoiKB8QvbUhJ1dhGI2jFhFCxywSVBouyHbprAck0m4pIVMw9WFMPPKr+upSiGtmaRVEKIVTsFMG+gEWpyULtdgvo02wyEjU6q7NldUiowk0pRTWynG9gLCYExcoT9Oek8pUUag9bQJ9mk5Go0XDLjzDXvMaKqkZkYdLAWEwIijkr9CekEv9L9UvVWJpNRmwL4LhuuKmXRghUNW5QNzAWE4JipQb9tfk7gDcJxud+vZucT0j7/NMjGdZGwrgtl29YRF8Z27miqoWx0fmpMHCSLi0mPMX6m9yqDVSa2M8F80qT9zeRm5UgSp5zM8OaCA+s3PGjr2k7FFsrIZBy3wg2VfUS3spvhvyOv4kJT7FKwHWqS3aeFgcDKwVgOBQ7j2Itw5pIqBmXd/4Z40/A7KI6i9dRDfkrQEZMeIrJe4xbdRZYlw9UxWfdGWHB/UBuJMOaiIYTRd8fQVQ7gaF1VQ3AMbnbJcAnZ1pstUaWYpKd1/02zQ4Zhc1e3ESfJ9kT7D9kL7TC8Urb68hNqqqMAtgp3BwyYnlpL9kDve7PubLGwLecvywJzVnHb7ofCTaMMJjad+CbQHqI8br3NwJRxfAEAj21uJIV07NOsb6qXPeh9TyeYFdu1Y+U9tgX+RqeR4bNeeR1mEiay77GnBrXzxPV6sCK6+HA+ARwK/Jpsf6f7tI0gw257s7kS3gPePnrp3lYMFDFl7Mo190nkWYlgnINWRugiDGeoQvFgKrFzcVZB4Vjj00BR7Jie8+saRrZgafgvuHLDl3etTYW6GdguQbcu+sV3beYlQ+EPZMmm7q340qfj1/uAVXL0/dNX4TzeMBYPSt2bpQsxdwavdpVC/Ahkcef+zuQZhn57nyDoZTxamQsUi2dqQcYknhK7ORDPF6SZpvtmKtadJqgweNX5JjT7GnkPD1Rtqn6PamaVqxqP9Y9DDazYvVKHpA03IDQor/PAofq+vgBV32CKRMWlr9l7DVE5IaeNdCJqEh1Ce9X8QAyYuXJwY9FDCh6ts8hAwbpKXR4TCeQZBnZg4XAdjB+sWnAfByIVclxAhkxaShpzAtHQL4qJXAxdKZMsowcxjEvFUd03ZaSV3F33MgJImzFhEiniZr8K8iNLTTSDQa2PUh75ND2FufYdfugZc3vem5AZh5aD5JvpfyfrsBqzU5cPp3dNn2nSNIX93c7NfOVGjZpL7LrO0UH0IvsfKes3kIL5O3fddN3Ss/mru+UnmXnO2V1Zmbm3Z6svL5TdOofbTTU/1eKvwA48E2qY/uFiQAAAABJRU5ErkJggg==";
__base64Images["./DataFitting/2016-06-15_1419s.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
__base64Images["./DataFitting/function.png"]="data:image/png;base64,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";
